/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.legacy;

import com.appdynamics.agent.sim.legacy.AccountKey;
import com.appdynamics.agent.sim.legacy.AgentRegistrationConfigListener;
import com.appdynamics.agent.sim.legacy.DefaultLegacyAgentRegistrationStateManager;
import com.appdynamics.agent.sim.legacy.DefaultLegacyRegistrationState;
import com.appdynamics.agent.sim.legacy.LegacyAgentRegistrationStateManager;
import com.appdynamics.agent.sim.legacy.MachineId;
import com.appdynamics.agent.sim.monitor.annotations.MonitorOutputHandlers;
import com.appdynamics.sim.common.biz.shared.machines.AgentRegistrationConfig;
import com.appdynamics.voltron.configuration.DynamicConfigurationClientModule;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.IMetricReporterFactory;
import com.singularity.ee.agent.commonservices.timeskewhandling.spi.IControllerTimeSkewHandler;
import com.singularity.ee.agent.systemagent.LegacyRegistrationState;
import com.singularity.ee.agent.systemagent.SystemAgent;
import com.singularity.ee.agent.systemagent.SystemAgentName;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.IMonitorOutputHandler;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ISystemAgentMetricSenderFactory;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.SystemAgentMetricSenderFactory;
import com.singularity.ee.agent.systemagent.task.classloading.CompatibilityClassLoaderModule;
import com.singularity.ee.agent.util.scrub.ISensitiveDataScrubber;
import com.singularity.ee.agent.util.scrub.MachineAgentSensitiveDataScrubber;
import com.singularity.ee.util.httpclient.SimpleHttpClientWrapper;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyAgentModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LegacyAgentModule.class);
    private static final long MAX_WAIT_TIME = Long.getLong("appdynamics.machine.agent.legacy.maxWaitTimeMillis", 25000L);
    private static final long WAIT_TIME = Long.getLong("appdynamics.machine.agent.legacy.retryTimeMillis", 500L);

    protected void configure() {
        this.bind(String.class).annotatedWith(SystemAgentName.class).toInstance((Object)"Machine Agent");
        this.bind(ISensitiveDataScrubber.class).to(MachineAgentSensitiveDataScrubber.class);
        this.bind(SystemAgent.class).asEagerSingleton();
        this.bind(ISystemAgentMetricSenderFactory.class).to(SystemAgentMetricSenderFactory.class);
        this.bind(LegacyAgentRegistrationStateManager.class).to(DefaultLegacyAgentRegistrationStateManager.class);
        this.bind(LegacyRegistrationState.class).to(DefaultLegacyRegistrationState.class);
        Multibinder.newSetBinder((Binder)this.binder(), IMonitorOutputHandler.class, MonitorOutputHandlers.class);
        this.install((Module)new CompatibilityClassLoaderModule());
        this.install((Module)new DynamicConfigurationClientModule(){

            protected void configureListenersAndValidators() {
                this.bindConfigListener("_agentRegistrationConfig", AgentRegistrationConfig.class).to(AgentRegistrationConfigListener.class).in(Scopes.SINGLETON);
                this.bindInjectableConfig("_agentRegistrationConfig", AgentRegistrationConfig.class, AgentRegistrationConfig.INVALID_CONFIG, true);
            }
        });
    }

    @Provides
    private IControllerTimeSkewHandler provideControllerTimeSkewHandler(final SystemAgent agent) {
        return this.tryUntilNotNull(new Callable<IControllerTimeSkewHandler>(){

            @Override
            public IControllerTimeSkewHandler call() throws Exception {
                return agent.getSkewHandler();
            }
        });
    }

    @Provides
    private IMetricReporterFactory provideMetricReporterFactory(final SystemAgent agent) {
        return this.tryUntilNotNull(new Callable<IMetricReporterFactory>(){

            @Override
            public IMetricReporterFactory call() throws Exception {
                return agent.getAgentMonitorManager().getNodeMonitorManager().getManagedMonitorDelegate().getMetricService().getMetricReporterFactory();
            }
        });
    }

    @Provides
    private IEventGenerationService provideEventGenerationService(final SystemAgent agent) {
        return this.tryUntilNotNull(new Callable<IEventGenerationService>(){

            @Override
            public IEventGenerationService call() throws Exception {
                return agent.getAgentMonitorManager().getNodeMonitorManager().getManagedMonitorDelegate().getEventService();
            }
        });
    }

    @Provides
    private IAgentScheduledExecutorService provideAgentSchedulerService(final SystemAgent agent) {
        return this.tryUntilNotNull(new Callable<IAgentScheduledExecutorService>(){

            @Override
            public IAgentScheduledExecutorService call() throws Exception {
                return agent.getScheduler();
            }
        });
    }

    @Provides
    private SimpleHttpClientWrapper provideSimpleHttpClientWrapper(SystemAgent agent) {
        return agent.getHttpClientWrapper();
    }

    private <T> T tryUntilNotNull(Callable<T> getter) {
        for (long time = MAX_WAIT_TIME; time > 0L; time -= WAIT_TIME) {
            try {
                T obj = getter.call();
                if (obj != null) {
                    return obj;
                }
            }
            catch (NullPointerException e) {
                if (time <= 0L) {
                    throw e;
                }
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            try {
                Thread.sleep(WAIT_TIME);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        throw new IllegalStateException("Could not load dependency.");
    }

    @Provides
    @MachineId
    private Optional<Long> provideLegacyMachineId(Provider<AgentRegistrationConfig> agentRegistrationConfigProvider) {
        AgentRegistrationConfig agentRegistrationConfig = (AgentRegistrationConfig)agentRegistrationConfigProvider.get();
        String machineInstanceEntityId = agentRegistrationConfig.getMachineInstanceEntityId();
        if (!"0".equals(machineInstanceEntityId)) {
            return Optional.of((Object)Long.parseLong(machineInstanceEntityId));
        }
        return Optional.absent();
    }

    @Provides
    @AccountKey
    private Optional<String> provideAccountKey(Provider<AgentRegistrationConfig> agentRegistrationConfigProvider) {
        AgentRegistrationConfig agentRegistrationConfig = (AgentRegistrationConfig)agentRegistrationConfigProvider.get();
        return Optional.fromNullable((Object)agentRegistrationConfig.getAccountKey());
    }
}

