/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.legacy;

import com.appdynamics.agent.sim.legacy.LegacyAgentRegistrationStateManager;
import com.appdynamics.agent.sim.scheduling.annotations.SystemScheduler;
import com.appdynamics.sim.common.biz.shared.machines.AgentRegistrationConfig;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.singularity.ee.agent.AgentAccountInfoStore;
import com.singularity.ee.agent.systemagent.LegacyRegistrationState;
import com.singularity.ee.agent.systemagent.SystemAgent;
import com.singularity.ee.rest.controller.request.AControllerRequest;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class DefaultLegacyAgentRegistrationStateManager
implements LegacyAgentRegistrationStateManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultLegacyAgentRegistrationStateManager.class);
    private final Provider<SystemAgent> systemAgent;
    private final LegacyRegistrationState registrationState;
    private final ScheduledExecutorService executorService;

    @Inject
    DefaultLegacyAgentRegistrationStateManager(Provider<SystemAgent> systemAgent, LegacyRegistrationState registrationState, @SystemScheduler ScheduledExecutorService executorService) {
        this.systemAgent = systemAgent;
        this.registrationState = registrationState;
        this.executorService = executorService;
    }

    @Override
    public void updateState(AgentRegistrationConfig configuration) {
        Optional machineInstanceId = Optional.fromNullable((Object)configuration.getMachineInstanceEntityId());
        String accountKey = configuration.getAccountKey();
        final SystemAgent agent = (SystemAgent)this.systemAgent.get();
        if (!machineInstanceId.equals(this.registrationState.getMachineInstanceIdText())) {
            this.registrationState.setMachineInstanceIdText((Optional<String>)machineInstanceId);
            log.info("Registered machine with machine ID [" + String.valueOf(machineInstanceId) + "]");
            agent.setBootstrapMachineInstanceID((String)machineInstanceId.orNull());
        }
        this.registrationState.setAccountKey(accountKey);
        Optional<String> accountKeyOpt = this.registrationState.getAccountKey();
        if (accountKeyOpt.isPresent()) {
            agent.setAccountKey((String)accountKeyOpt.get());
            AControllerRequest.registerAccountKey((String)AgentAccountInfoStore.getInstance().getAccountName(), (String)accountKey);
            if (!this.registrationState.isRegistered()) {
                this.registrationState.setRegistered(true);
                log.info("Scheduling System-Agent start...");
                this.executorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        log.info("Starting machine agent...");
                        agent.start();
                    }
                }, 0L, TimeUnit.SECONDS);
            }
        }
    }
}

