/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.k8s;

import com.appdynamics.agent.sim.k8s.K8sClient;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sContainerTags {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sContainerTags.class);
    private static final Map<String, String> EMPTY_TAG_MAP = new HashMap<String, String>();
    private final K8sClient k8sClient;
    private ConcurrentMap<String, Map<String, String>> containerToTagsMap;

    @Inject
    public K8sContainerTags(K8sClient k8sClient) {
        this.k8sClient = k8sClient;
        this.containerToTagsMap = new ConcurrentHashMap<String, Map<String, String>>();
    }

    public void updateContainers(Set<String> activeContainerIds) {
        log.debug("Active container ids: " + String.valueOf(activeContainerIds));
        this.containerToTagsMap.keySet().retainAll(activeContainerIds);
        for (String containerId : activeContainerIds) {
            if (this.containerToTagsMap.containsKey(containerId)) continue;
            this.containerToTagsMap.put(containerId, new HashMap());
        }
    }

    public void updateTags() {
        for (String containerId : this.containerToTagsMap.keySet()) {
            ImmutableMap tagsMap;
            try {
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                log.debug("Retrieving kubernetes labels for container: " + containerId);
                mapBuilder.putAll(this.k8sClient.getReplicaSetLabelsByContainerId(containerId));
                log.debug("Finished retrieving kubernetes labels");
                tagsMap = mapBuilder.build();
            }
            catch (Exception e) {
                log.debug("Skip retrieving Kubernetes tags for container " + containerId + ". Server is either not orchestrated by Kubernetes or  not able to connect to Kubernetes Master API");
                log.error("Error retrieving tags from Kubernetes", (Throwable)e);
                tagsMap = EMPTY_TAG_MAP;
            }
            this.containerToTagsMap.put(containerId, (Map<String, String>)tagsMap);
        }
    }

    public Map<String, String> getTagsByContainerId(String containerId) {
        Map tagsMap = (Map)this.containerToTagsMap.get(containerId);
        if (tagsMap == null) {
            return Collections.emptyMap();
        }
        return tagsMap;
    }

    public void clearTags() {
        this.containerToTagsMap.clear();
    }
}

