/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.gpu.dcgm;

import com.appdynamics.agent.sim.gpu.dcgm.GpuDcgmMetricData;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;

public enum DcgmExporterMetricNames {
    DCGM_FI_DEV_GPU_UTIL("DCGM_FI_DEV_GPU_UTIL", "GPU Utilization", (gpuData, value) -> gpuData.getGpu().setUtilization(value.longValue())),
    DCGM_FI_DEV_GPU_TEMP("DCGM_FI_DEV_GPU_TEMP", "Gpu Temperature", (gpuData, value) -> gpuData.getGpu().setTemperature(value.longValue())),
    DCGM_FI_DEV_MEM_COPY_UTIL("DCGM_FI_DEV_MEM_COPY_UTIL", "Memory Utilization", (gpuData, value) -> gpuData.getMemory().setUtilization(value.longValue())),
    DCGM_FI_DEV_MEMORY_TEMP("DCGM_FI_DEV_MEMORY_TEMP", "Memory Temperature", (gpuData, value) -> gpuData.getMemory().setTemperature(value.longValue())),
    DCGM_FI_DEV_BAR1_TOTAL("DCGM_FI_DEV_BAR1_TOTAL", "BAR1 Total", (gpuData, value) -> gpuData.getBar1_memory().setTotal(value.longValue())),
    DCGM_FI_DEV_BAR1_USED("DCGM_FI_DEV_BAR1_USED", "BAR1 Used", (gpuData, value) -> gpuData.getBar1_memory().setUsed(value.longValue())),
    DCGM_FI_DEV_BAR1_FREE("DCGM_FI_DEV_BAR1_FREE", "BAR1 Free", (gpuData, value) -> gpuData.getBar1_memory().setFree(value.longValue())),
    DCGM_FI_PROF_PIPE_FP64_ACTIVE("DCGM_FI_PROF_PIPE_FP64_ACTIVE", "FP64 Active", (gpuData, value) -> gpuData.getComputePipelines().setFp64_active((long)(value * 100.0))),
    DCGM_FI_PROF_PIPE_FP32_ACTIVE("DCGM_FI_PROF_PIPE_FP32_ACTIVE", "FP32 Active", (gpuData, value) -> gpuData.getComputePipelines().setFp32_active((long)(value * 100.0))),
    DCGM_FI_PROF_PIPE_FP16_ACTIVE("DCGM_FI_PROF_PIPE_FP16_ACTIVE", "FP16 Active", (gpuData, value) -> gpuData.getComputePipelines().setFp16_active((long)(value * 100.0))),
    DCGM_FI_PROF_PIPE_TENSOR_HMMA_ACTIVE("DCGM_FI_PROF_PIPE_TENSOR_HMMA_ACTIVE", "Tensor HMMA Active", (gpuData, value) -> gpuData.getComputePipelines().setHmma_active((long)(value * 100.0))),
    DCGM_FI_PROF_PIPE_TENSOR_IMMA_ACTIVE("DCGM_FI_PROF_PIPE_TENSOR_IMMA_ACTIVE", "Tensor IMMA Active", (gpuData, value) -> gpuData.getComputePipelines().setImma_active((long)(value * 100.0))),
    DCGM_FI_PROF_PIPE_TENSOR_DFMA_ACTIVE("DCGM_FI_PROF_PIPE_TENSOR_DFMA_ACTIVE", "Tensor DFMA Active", (gpuData, value) -> gpuData.getComputePipelines().setDfma_active((long)(value * 100.0))),
    DCGM_FI_DEV_CLOCK_THROTTLE_REASONS("DCGM_FI_DEV_CLOCK_THROTTLE_REASONS", "Clock Throttle Reasons", (gpuData, value) -> {}),
    DCGM_FI_DEV_MEM_CLOCK("DCGM_FI_DEV_MEM_CLOCK", "Memory Clock", (gpuData, value) -> gpuData.getClocks().setMemory(value.longValue())),
    DCGM_FI_DEV_MAX_MEM_CLOCK("DCGM_FI_DEV_MAX_MEM_CLOCK", "Max Memory Clock", (gpuData, value) -> gpuData.getClocks().setMax_memory(value.longValue())),
    DCGM_FI_DEV_SUPPORTED_CLOCKS("DCGM_FI_DEV_SUPPORTED_CLOCKS", "Supported Clocks", (gpuData, value) -> {}),
    DCGM_FI_DEV_VIDEO_CLOCK("DCGM_FI_DEV_VIDEO_CLOCK", "Video Clock", (gpuData, value) -> gpuData.getClocks().setVideo(value.longValue())),
    DCGM_FI_DEV_MAX_VIDEO_CLOCK("DCGM_FI_DEV_MAX_VIDEO_CLOCK", "Max Video Clock", (gpuData, value) -> gpuData.getClocks().setMax_video(value.longValue())),
    DCGM_FI_DEV_SM_CLOCK("DCGM_FI_DEV_SM_CLOCK", "SM Clock", (gpuData, value) -> gpuData.getClocks().setSm(value.longValue())),
    DCGM_FI_DEV_MAX_SM_CLOCK("DCGM_FI_DEV_MAX_SM_CLOCK", "Max SM Clock", (gpuData, value) -> gpuData.getClocks().setMax_sm(value.longValue())),
    DCGM_FI_DEV_POWER_USAGE("DCGM_FI_DEV_POWER_USAGE", "Power Usage", (gpuData, value) -> gpuData.getPower().setDraw(value.longValue())),
    DCGM_FI_DEV_POWER_MGMT_LIMIT("DCGM_FI_DEV_POWER_MGMT_LIMIT", "Power Management Limit", (gpuData, value) -> gpuData.getPower().setLimit(value.longValue())),
    DCGM_FI_DEV_POWER_USAGE_INSTANT("DCGM_FI_DEV_POWER_USAGE_INSTANT", "Instant Power Usage", (gpuData, value) -> gpuData.getPower().setUsed_instant(value.longValue())),
    DCGM_FI_DEV_FB_TOTAL("DCGM_FI_DEV_FB_TOTAL", "Framebuffer Total", (gpuData, value) -> gpuData.getFramebuffer_memory().setTotal(value.longValue())),
    DCGM_FI_DEV_FB_USED("DCGM_FI_DEV_FB_USED", "Framebuffer Used", (gpuData, value) -> gpuData.getFramebuffer_memory().setUsed(value.longValue())),
    DCGM_FI_DEV_FB_FREE("DCGM_FI_DEV_FB_FREE", "Framebuffer Free", (gpuData, value) -> gpuData.getFramebuffer_memory().setFree(value.longValue())),
    DCGM_FI_DEV_FB_RESERVED("DCGM_FI_DEV_FB_RESERVED", "Framebuffer Reserved", (gpuData, value) -> gpuData.getFramebuffer_memory().setReserved(value.longValue())),
    DCGM_FI_DEV_FB_USED_PERCENT("DCGM_FI_DEV_FB_USED_PERCENT", "Framebuffer Used (%)", (gpuData, value) -> gpuData.getFramebuffer_memory().setUsed_pct(value.longValue())),
    DCGM_FI_DEV_PSTATE("DCGM_FI_DEV_PSTATE", "P-State", (gpuData, value) -> gpuData.getPerformance().setP_state(value.longValue())),
    DCGM_FI_PROF_PCIE_TX_BYTES("DCGM_FI_PROF_PCIE_TX_BYTES", "PCIe TX Bytes", (gpuData, value) -> gpuData.getPerformance().setTx_throughput((long)(value / 1048576.0))),
    DCGM_FI_PROF_PCIE_RX_BYTES("DCGM_FI_PROF_PCIE_RX_BYTES", "PCIe RX Bytes", (gpuData, value) -> gpuData.getPerformance().setRx_throughput((long)(value / 1048576.0))),
    DCGM_FI_PROF_PIPE_TENSOR_ACTIVE("DCGM_FI_PROF_PIPE_TENSOR_ACTIVE", "Tensor Pipe Active (%)", (gpuData, value) -> gpuData.getPerformance().setTensor_pipe_active_pct((long)(value * 100.0))),
    DCGM_FI_PROF_DRAM_ACTIVE("DCGM_FI_PROF_DRAM_ACTIVE", "DRAM Active (%)", (gpuData, value) -> gpuData.getPerformance().setDram_active_pct((long)(value * 100.0))),
    DCGM_FI_PROF_GR_ENGINE_ACTIVE("DCGM_FI_PROF_GR_ENGINE_ACTIVE", "Graphics\u2011Engine Active (%)", (gpuData, value) -> gpuData.getPerformance().setGraphics_engine_active_pct((long)(value * 100.0)));

    private final String metricName;
    private final String displayName;
    private final BiConsumer<GpuDcgmMetricData.GpuData, Double> updater;
    private static Set<String> METRIC_NAMES;

    private DcgmExporterMetricNames(String metricName, String displayName, BiConsumer<GpuDcgmMetricData.GpuData, Double> updater) {
        this.metricName = metricName;
        this.displayName = displayName;
        this.updater = updater;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void update(GpuDcgmMetricData.GpuData gpuData, double value) {
        this.updater.accept(gpuData, value);
    }

    public static boolean isMetricIncluded(String givenMetricName) {
        return METRIC_NAMES.contains(givenMetricName);
    }

    static {
        METRIC_NAMES = new HashSet<String>();
        for (DcgmExporterMetricNames metric : DcgmExporterMetricNames.values()) {
            METRIC_NAMES.add(metric.getMetricName());
        }
    }
}

