/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.extensions;

import com.appdynamics.agent.sim.configuration.bootstrap.AgentHomeDir;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.scheduling.annotations.SystemScheduler;
import com.appdynamics.agent.sim.time.AgentTimeSupplier;
import com.appdynamics.voltron.configuration.ConfigurationException;
import com.appdynamics.voltron.configuration.ConfigurationWriter;
import com.appdynamics.voltron.configuration.providers.UriConfigMonitor;
import com.appdynamics.voltron.extensions.ExtensionsConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class ExtensionsConfigurationProvider
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtensionsConfigurationProvider.class);
    @Generated
    private final Object $lock = new Object[0];
    @VisibleForTesting
    static final String LIBS_DIR = "lib";
    @VisibleForTesting
    static final String CONFIG_DIR = "conf";
    private static final long PERIOD_BETWEEN_EXTENSION_DIR_MISSING_WARNINGS = TimeUnit.MINUTES.toMillis(30L);
    private final String agentHomeDir;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final ConfigurationWriter configurationWriter;
    private final ScheduledExecutorService scheduler;
    private final UriConfigMonitor uriConfigMonitor;
    private final AgentTimeSupplier timeSupplier;
    private final Path extensionsDirectoryPath;
    private volatile ScheduledFuture<?> future;
    private volatile Optional<ExtensionsConfiguration> prevConfig;
    private volatile long lastExtensionWarningPrinted;

    @Inject
    ExtensionsConfigurationProvider(@AgentHomeDir String agentHomeDir, BootstrapConfiguration bootstrapConfiguration, ConfigurationWriter configurationWriter, @SystemScheduler ScheduledExecutorService scheduler, UriConfigMonitor uriConfigMonitor, AgentTimeSupplier timeSupplier) {
        this.agentHomeDir = agentHomeDir;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.configurationWriter = configurationWriter;
        this.scheduler = scheduler;
        this.uriConfigMonitor = uriConfigMonitor;
        this.timeSupplier = timeSupplier;
        String extensionsDirectory = bootstrapConfiguration.getExtensionsDirectory();
        try {
            this.extensionsDirectoryPath = this.getExtensionsDirectoryPath(extensionsDirectory);
        }
        catch (InvalidPathException e) {
            throw new ProvisionException("The extensions path '" + extensionsDirectory + "' specified in the configuration is not valid.", (Throwable)e);
        }
        this.prevConfig = Optional.absent();
        this.lastExtensionWarningPrinted = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void start() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future == null) {
                log.debug("Scheduling extensions loading every {} milliseconds", (Object)this.bootstrapConfiguration.getExtensionsUpdateIntervalMillis());
                this.future = this.scheduler.scheduleWithFixedDelay(this, this.bootstrapConfiguration.getExtensionsUpdateIntervalMillis(), this.bootstrapConfiguration.getExtensionsUpdateIntervalMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stop() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Stopping extensions loading.");
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.$lock;
        synchronized (object) {
            try {
                this.doRun();
            }
            catch (Exception e) {
                log.warn("Could not get extensions", (Throwable)e);
            }
        }
    }

    private void doRun() {
        HashMap<String, Set<URL>> extensionLibraries = new HashMap<String, Set<URL>>();
        if (!Files.isDirectory(this.extensionsDirectoryPath, new LinkOption[0])) {
            String msg = "The extensions path '" + String.valueOf(this.extensionsDirectoryPath) + "' is not a directory or does not exist. Will not load any extensions.";
            if (this.timeSupplier.getAgentTime() - this.lastExtensionWarningPrinted >= PERIOD_BETWEEN_EXTENSION_DIR_MISSING_WARNINGS) {
                log.warn(msg);
            } else {
                log.debug(msg);
            }
            return;
        }
        File[] extensionDirectoryFiles = this.extensionsDirectoryPath.toFile().listFiles();
        if (extensionDirectoryFiles == null) {
            return;
        }
        HashSet<Object> removedExtensions = this.prevConfig.isPresent() ? new HashSet(((ExtensionsConfiguration)this.prevConfig.get()).getExtensionUrls().keySet()) : new HashSet(0);
        for (File extensionDirFile : extensionDirectoryFiles) {
            if (!extensionDirFile.isDirectory()) continue;
            log.trace("Checking extension dir {}", (Object)extensionDirFile);
            this.uriConfigMonitor.addUriToMonitorForConfigFiles(this.getExtensionConfigUri(extensionDirFile));
            String extensionName = extensionDirFile.getName();
            extensionLibraries.put(extensionName, this.getExtensionJarUrls(extensionDirFile));
            removedExtensions.remove(extensionName);
        }
        for (String string : removedExtensions) {
            this.uriConfigMonitor.removeUriToMonitorForConfigFiles(this.extensionsDirectoryPath.resolve(string).resolve(CONFIG_DIR).toUri());
        }
        ExtensionsConfiguration newConfig = new ExtensionsConfiguration();
        newConfig.setExtensionUrls(extensionLibraries);
        newConfig.setMaxExtensionStartTimeMillis(this.bootstrapConfiguration.getExtensionsMaxStartTimeMillis().longValue());
        newConfig.setMaxExtensionStopTimeMillis(this.bootstrapConfiguration.getExtensionsMaxStopTimeMillis().longValue());
        if (!this.prevConfig.isPresent() || !newConfig.equals(this.prevConfig.get())) {
            try {
                this.configurationWriter.writeConfiguration("SimExtensions", (Object)newConfig);
                this.prevConfig = Optional.of((Object)newConfig);
            }
            catch (ConfigurationException | IOException | InterruptedException throwable) {
                log.warn("Could not apply new extension configuration: " + String.valueOf(newConfig), throwable);
            }
        }
    }

    @VisibleForTesting
    URI getExtensionConfigUri(File extensionDir) {
        return extensionDir.toURI().resolve(CONFIG_DIR);
    }

    @VisibleForTesting
    Path getExtensionsDirectoryPath(String extensionsDirectory) {
        Path path = Paths.get(extensionsDirectory, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        Path home = Paths.get(this.agentHomeDir, new String[0]);
        return home.resolve(path);
    }

    @VisibleForTesting
    Set<URL> getExtensionJarUrls(File extensionDir) {
        File libsDir = new File(extensionDir, LIBS_DIR);
        HashSet<URL> jarUrls = new HashSet<URL>();
        File[] files = libsDir.listFiles();
        if (files == null) {
            log.warn("Could not read files in {} to configure the extension. Skipping.", (Object)libsDir);
            return jarUrls;
        }
        for (File libFile : files) {
            if (!libFile.getName().endsWith(".jar")) continue;
            try {
                jarUrls.add(libFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.warn("Could not get JAR URL for " + String.valueOf(libFile) + ". This may be a bug in the JRE.", (Throwable)e);
            }
        }
        return jarUrls;
    }
}

