/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.encryption;

import com.appdynamics.agent.sim.encryption.DecryptIvString;
import com.appdynamics.agent.sim.encryption.DecryptKeyString;
import com.appdynamics.agent.sim.encryption.DecryptMessageDigestAlgo;
import com.appdynamics.agent.sim.encryption.DecryptionService;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDigestDecryptionService
implements DecryptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageDigestDecryptionService.class);
    private final String messageDigestAlgo;
    private final String keyString;
    private final String ivString;

    @Inject
    MessageDigestDecryptionService(@DecryptMessageDigestAlgo String decryptMessageDigestAlgo, @DecryptKeyString String decryptKeyString, @DecryptIvString String decryptIvString) {
        this.messageDigestAlgo = decryptMessageDigestAlgo;
        this.keyString = decryptKeyString;
        this.ivString = decryptIvString;
    }

    private SecretKey defineKey(String key) {
        byte[] keyBytes;
        try {
            keyBytes = key.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("key cannot be read");
        }
        if (keyBytes.length != 16 && keyBytes.length != 24 && keyBytes.length != 32) {
            throw new IllegalArgumentException("keyBytes wrong length for AES key");
        }
        return new SecretKeySpec(keyBytes, this.messageDigestAlgo);
    }

    private IvParameterSpec defineIV(String iv) {
        try {
            return new IvParameterSpec(iv.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("IV cannot be read");
        }
    }

    @Override
    public Optional<String> decryptInputStream(InputStream stream) {
        Cipher cipher;
        Optional decryptedScriptContent = Optional.absent();
        Security.addProvider((Provider)new BouncyCastleFipsProvider());
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BCFIPS");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Cipher cannot be instantiated", e);
        }
        try {
            cipher.init(2, (Key)this.defineKey(this.keyString), this.defineIV(this.ivString));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException("Cipher cannot be initialized", e);
        }
        try (CipherInputStream cipherIn = new CipherInputStream(stream, cipher);
             ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] data = new byte[8192];
            while ((bytesRead = cipherIn.read(data)) != -1) {
                buffer.write(data, 0, bytesRead);
            }
            String decryptedContent = buffer.toString("UTF-8");
            decryptedScriptContent = Optional.fromNullable((Object)decryptedContent);
        }
        catch (Exception e) {
            log.warn("Failed to decrypt machine agent script:\n{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return decryptedScriptContent;
    }
}

