/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.docker;

import com.appdynamics.agent.sim.docker.DockerEngine;
import com.appdynamics.agent.sim.docker.DockerFeign;
import com.appdynamics.agent.sim.docker.HttpRawResponseParser;
import com.appdynamics.agent.sim.docker.UnixSocketFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.xml.ws.WebServiceException;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnixSocketHttpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnixSocketHttpUtils.class);
    static final String UNIX_SOCKET_SPEC = "unix://";
    static final String GET_METHOD = "GET";
    private static final String RESPONSE_START_OBJECT = "{";
    private static final String RESPONSE_START_ARRAY = "[";
    private static final int BUFFER_SIZE = 8192;
    private static final int SOCKET_TIMEOUT = 5000;
    private final UnixSocketFactory unixSocketFactory;
    private final Supplier<String> dockerUrlSupplier;
    private final ErrorDecoder errorDecoder;

    @Inject
    UnixSocketHttpUtils(UnixSocketFactory unixSocketFactory, @DockerEngine Supplier<String> dockerUrlSupplier, @DockerFeign ErrorDecoder errorDecoder) {
        this.unixSocketFactory = unixSocketFactory;
        this.dockerUrlSupplier = dockerUrlSupplier;
        this.errorDecoder = errorDecoder;
    }

    Optional<String> getResponseForRequestedUrl(@NonNull String requestMethod, String url) {
        Optional<String> result;
        if (requestMethod == null) {
            throw new NullPointerException("requestMethod is marked non-null but is null");
        }
        if (!GET_METHOD.equalsIgnoreCase(requestMethod)) {
            throw new UnsupportedOperationException("Request method " + requestMethod + " is not supported on UNIX sockets. Only 'GET' is supported.");
        }
        Socket socket = null;
        try {
            socket = this.sendRequest(requestMethod, url);
            result = this.readResponse(socket, url);
        }
        catch (Exception e) {
            String message = "Failed to get a response from " + url + " using a " + requestMethod + " request.  The error encountered is: " + String.valueOf(e);
            throw new WebServiceException(message);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private Socket sendRequest(String requestMethod, String url) throws IOException {
        Socket socket = this.unixSocketFactory.newInstance();
        File socketFile = new File(this.getDockerSocketFile());
        socket.connect(this.unixSocketFactory.newAddress(socketFile), 5000);
        OutputStream os = socket.getOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        writer.write(this.decorateUrlWithHttpHeader(requestMethod, url));
        writer.flush();
        return socket;
    }

    private Optional<String> readResponse(Socket socket, String url) throws Exception {
        Optional<String> responseOpt = this.readResponse(socket.getInputStream());
        if (responseOpt.isPresent()) {
            String response = (String)responseOpt.get();
            this.checkHttpHeaderForError(response, url);
            if (response.contains(RESPONSE_START_OBJECT) || response.contains(RESPONSE_START_ARRAY)) {
                return Optional.of((Object)this.removeHttpHeader(response));
            }
            log.trace("Invalid response encountered from unix socket: " + response);
        }
        return Optional.absent();
    }

    @VisibleForTesting
    void checkHttpHeaderForError(String response, String urlForDebugging) throws Exception {
        HttpRawResponseParser responseParser = new HttpRawResponseParser();
        Optional<Response> responseOptional = responseParser.parseRawHttpResponseWithError(response);
        if (!responseOptional.isPresent()) {
            return;
        }
        throw this.errorDecoder.decode(urlForDebugging, (Response)responseOptional.get());
    }

    @VisibleForTesting
    Optional<String> readResponse(InputStream inputStream) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            char[] buffer = new char[8192];
            int bytesRead = inputStreamReader.read(buffer);
            if (bytesRead < 0) {
                Optional optional = Optional.absent();
                return optional;
            }
            StringBuilder contents = new StringBuilder();
            while (bytesRead > 0) {
                contents.append(buffer, 0, bytesRead);
                bytesRead = inputStreamReader.read(buffer);
            }
            Optional optional = Optional.of((Object)contents.toString());
            return optional;
        }
    }

    private String decorateUrlWithHttpHeader(String requestMethod, String url) {
        return requestMethod + " " + url + " HTTP/1.0\r\n\n";
    }

    private String removeHttpHeader(String msg) {
        int objectStart = msg.indexOf(RESPONSE_START_OBJECT);
        int arrayStart = msg.indexOf(RESPONSE_START_ARRAY);
        if (objectStart >= 0 && arrayStart >= 0) {
            return msg.substring(Math.min(objectStart, arrayStart));
        }
        if (objectStart >= 0) {
            return msg.substring(objectStart);
        }
        if (arrayStart >= 0) {
            return msg.substring(arrayStart);
        }
        log.warn("Neither '{' nor '[' found in response, returning original message");
        return msg;
    }

    private String getDockerSocketFile() {
        String url = (String)this.dockerUrlSupplier.get();
        if (!url.startsWith(UNIX_SOCKET_SPEC)) {
            throw new WebServiceException("Invalid protocol specified for unix socket.  Must start with 'unix://' - " + url);
        }
        String socketFileName = url.substring(UNIX_SOCKET_SPEC.length());
        File socketFile = new File(socketFileName);
        if (!socketFile.exists()) {
            throw new WebServiceException("Cannot connect to Docker.  The unix socket file " + socketFileName + " does not exist.  Please provide a valid file to access.");
        }
        return socketFileName;
    }
}

