/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.docker;

import com.appdynamics.agent.sim.docker.HttpResponseParseException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import feign.Request;
import feign.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

class HttpRawResponseParser {
    private static final Splitter SPLITTER_LINE = Splitter.on((String)"\n");
    private static final Splitter SPLITTER_EMPTY_LINE = Splitter.on((String)"\n\n");
    private static final Splitter SPLITTER_SPACE = Splitter.on((String)" ");
    private static final Splitter SPLITTER_COLON = Splitter.on((String)":");
    private static final int NUM_RESPONSE_TOKENS = 2;
    private static final int NUM_STATUS_LINE_TOKENS = 3;
    private static final int NUM_HEADER_TOKENS = 2;
    private static final int NUM_CHAR_FOR_EXCEPTION = 200;

    HttpRawResponseParser() {
    }

    public Optional<Response> parseRawHttpResponseWithError(@NonNull String response) throws HttpResponseParseException {
        Map<String, Collection<String>> headersMap;
        int code;
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String responseWithUnifiedLineSeparator = response.replaceAll("\\r", "");
        String responseSample = responseWithUnifiedLineSeparator.substring(0, Math.min(responseWithUnifiedLineSeparator.length(), 200));
        List responseTokens = SPLITTER_EMPTY_LINE.trimResults().splitToList((CharSequence)responseWithUnifiedLineSeparator);
        if (responseTokens.size() != 2) {
            throw new HttpResponseParseException("Invalid number of blocks in response: " + responseSample);
        }
        String statusLineAndHeaders = (String)responseTokens.get(0);
        List statusLineAndHeadersList = SPLITTER_LINE.trimResults().splitToList((CharSequence)statusLineAndHeaders);
        if (statusLineAndHeadersList.isEmpty()) {
            throw new HttpResponseParseException("No status line or headers found in response: " + responseSample);
        }
        String statusLine = (String)statusLineAndHeadersList.get(0);
        List statusTokens = SPLITTER_SPACE.limit(3).trimResults().splitToList((CharSequence)statusLine);
        if (statusTokens.size() != 3) {
            throw new HttpResponseParseException("Invalid status line : " + responseSample);
        }
        try {
            code = Integer.parseInt((String)statusTokens.get(1));
        }
        catch (Exception e) {
            throw new HttpResponseParseException("Invalid status code with exception: " + e.getMessage());
        }
        if (code >= 200 && code < 300) {
            return Optional.absent();
        }
        String reason = (String)statusTokens.get(2);
        try {
            headersMap = this.parseResponseHeadersMap(statusLineAndHeadersList.subList(1, statusLineAndHeadersList.size()));
        }
        catch (Throwable e) {
            throw new HttpResponseParseException("Error parsing response headers: " + e.getMessage());
        }
        String body = (String)responseTokens.get(1);
        Response responseObj = Response.builder().status(code).reason(reason).headers(headersMap).body(body.getBytes()).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"docker", Collections.emptyMap(), (byte[])new byte[0], null)).build();
        return Optional.of((Object)responseObj);
    }

    @VisibleForTesting
    Map<String, Collection<String>> parseResponseHeadersMap(List<String> headers) throws HttpResponseParseException {
        HashMap<String, HashSet<String>> headersMap = new HashMap<String, HashSet<String>>();
        for (String header : headers) {
            List headerTokens = SPLITTER_COLON.limit(2).trimResults().splitToList((CharSequence)header);
            if (headerTokens.size() != 2) {
                throw new HttpResponseParseException("Invalid header: " + header);
            }
            String headerName = (String)headerTokens.get(0);
            if (headerName.isEmpty()) {
                throw new HttpResponseParseException("Missing header name: " + header);
            }
            String headerValue = (String)headerTokens.get(1);
            if (headerValue.isEmpty()) {
                throw new HttpResponseParseException("Missing header value: " + header);
            }
            HashSet<String> headerValues = (HashSet<String>)headersMap.get(headerName);
            if (headerValues == null) {
                headerValues = new HashSet<String>();
                headersMap.put(headerName, headerValues);
            }
            headerValues.add(headerValue);
        }
        return ImmutableMap.copyOf(headersMap);
    }
}

