/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.dmm;

import com.appdynamics.agent.sim.configuration.AgentConfig;
import com.appdynamics.agent.sim.configuration.bootstrap.AgentConfigDir;
import com.appdynamics.agent.sim.dmm.MetricCategoryBucket;
import com.appdynamics.agent.sim.dmm.MetricCategoryDataSet;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileMetricOverriderDataSet
implements MetricCategoryDataSet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileMetricOverriderDataSet.class);
    private static final String FILE_NAME = "metric-category-data.json";
    private final ObjectMapper objectMapper;
    private final Map<String, List<Integer>> data;

    @Inject
    FileMetricOverriderDataSet(@AgentConfig ObjectMapper objectMapper, @AgentConfigDir String agentConfDir) throws IOException {
        this.objectMapper = objectMapper;
        File metricConfigFile = new File(agentConfDir, FILE_NAME);
        if (metricConfigFile.exists()) {
            Collection<MetricCategoryBucket> metricCategoryBuckets = this.readFromFile(metricConfigFile.getPath());
            this.data = this.buildMetricData(metricCategoryBuckets);
        } else {
            log.debug("Config file {} to override metric modes could not be found. Metric modes will not be updated.", (Object)metricConfigFile);
            this.data = ImmutableMap.of();
        }
    }

    @Override
    public Map<String, List<Integer>> getData() {
        return this.data;
    }

    @VisibleForTesting
    Collection<MetricCategoryBucket> readFromFile(@NonNull String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        try (FileInputStream stream = new FileInputStream(filePath);){
            Collection metricData;
            Collection collection = metricData = (Collection)this.objectMapper.readValue((InputStream)stream, (TypeReference)new TypeReference<List<MetricCategoryBucket>>(){});
            return collection;
        }
    }

    @VisibleForTesting
    Map<String, List<Integer>> buildMetricData(@NonNull Collection<MetricCategoryBucket> metricData) {
        if (metricData == null) {
            throw new NullPointerException("metricData is marked non-null but is null");
        }
        HashMap<String, List<Integer>> categoryMap = new HashMap<String, List<Integer>>();
        for (MetricCategoryBucket metricCategoryBucket : metricData) {
            int n = metricCategoryBucket.getMode().getModeValue();
            for (String metricName : metricCategoryBucket.getMetrics()) {
                if (categoryMap.containsKey(metricName)) {
                    ((List)categoryMap.get(metricName)).add(n);
                    continue;
                }
                this.addToMetricNameToCategoryMap(categoryMap, metricName, n);
            }
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : categoryMap.entrySet()) {
            mapBuilder.put((Object)((String)entry.getKey()), (Object)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
        }
        ImmutableMap immutableMap = mapBuilder.build();
        log.debug("Metric categories based on file overrides - {}", (Object)immutableMap);
        return immutableMap;
    }

    private void addToMetricNameToCategoryMap(Map<String, List<Integer>> map, String metricName, int modeValue) {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        newList.add(modeValue);
        map.put(metricName, newList);
    }
}

