/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.dmm;

import com.appdynamics.agent.sim.common.SimMachineIdsSupplier;
import com.appdynamics.agent.sim.configuration.AgentConfig;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.dmm.DynamicMonitoringModeManager;
import com.appdynamics.agent.sim.scheduling.annotations.SystemScheduler;
import com.appdynamics.sim.common.rest.config.SimAgentConfigService;
import com.appdynamics.sim.common.rest.dmm.DynamicMonitoringMachineAgentDto;
import com.appdynamics.sim.common.rest.dmm.DynamicMonitoringModeAgent;
import com.appdynamics.sim.common.rest.machines.GenericConfig;
import com.appdynamics.voltron.rest.utils.RestException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMonitoringModeTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicMonitoringModeTask.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final boolean OMIT_STACK_TRACE = true;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final DynamicMonitoringModeManager dynamicMonitoringModeManager;
    private final SimAgentConfigService simAgentConfigService;
    private final ScheduledExecutorService executorService;
    private final ObjectMapper objectMapper;
    private final SimMachineIdsSupplier simMachineIdsSupplier;
    private ScheduledFuture<?> future;

    @Inject
    DynamicMonitoringModeTask(BootstrapConfiguration bootstrapConfiguration, DynamicMonitoringModeManager dynamicMonitoringModeManager, SimAgentConfigService simAgentConfigService, SimMachineIdsSupplier simMachineIdsSupplier, @SystemScheduler ScheduledExecutorService executorService, @AgentConfig ObjectMapper objectMapper) {
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.dynamicMonitoringModeManager = dynamicMonitoringModeManager;
        this.simAgentConfigService = simAgentConfigService;
        this.simMachineIdsSupplier = simMachineIdsSupplier;
        this.executorService = executorService;
        this.objectMapper = objectMapper;
    }

    @Override
    public void run() {
        Object simMachineIds = this.simMachineIdsSupplier.get();
        if (!simMachineIds.isEmpty()) {
            this.removeNonRunningMachineMappings((Set<Long>)simMachineIds);
            this.updateDynamicMonitoringMode((Set<Long>)simMachineIds);
        }
    }

    @VisibleForTesting
    void updateDynamicMonitoringMode(Set<Long> simMachineIds) {
        for (long simMachineId : simMachineIds) {
            try {
                DynamicMonitoringModeAgent currentMode = this.dynamicMonitoringModeManager.get(simMachineId);
                GenericConfig agentInputConfig = this.buildAgentConfig();
                GenericConfig responseConfig = this.simAgentConfigService.updateConfig(simMachineId, agentInputConfig);
                Optional dynamicMonitoringMachineAgentDtoOptional = responseConfig.of("_dynamicMonitoringMachineAgentConfig", DynamicMonitoringMachineAgentDto.class);
                log.trace("DynamicMonitoringMachineAgentDto: " + String.valueOf(dynamicMonitoringMachineAgentDtoOptional));
                if (dynamicMonitoringMachineAgentDtoOptional.isPresent()) {
                    Optional dynamicMonitoringModeOptional = ((DynamicMonitoringMachineAgentDto)dynamicMonitoringMachineAgentDtoOptional.get()).getModesOpt();
                    if (dynamicMonitoringModeOptional.isPresent()) {
                        DynamicMonitoringModeAgent responseMonitoringMode;
                        Set modes = (Set)dynamicMonitoringModeOptional.get();
                        if (modes.size() <= 0 || (responseMonitoringMode = (DynamicMonitoringModeAgent)modes.iterator().next()) == currentMode) continue;
                        log.info("Changing Dynamic Monitoring Mode of the SIM machine with ID: {} from mode {} to new mode {}", new Object[]{simMachineId, currentMode.toString(), responseMonitoringMode.toString()});
                        this.dynamicMonitoringModeManager.put(simMachineId, responseMonitoringMode);
                        continue;
                    }
                    log.debug("Dynamic Monitoring mode not returned from the config api");
                    continue;
                }
                log.trace("Dynamic Monitoring Machine Agent Dto returned from updateConfig is absent");
            }
            catch (RestException r) {
                log.warn("Encountered error checking monitoring mode. Will retry in " + this.bootstrapConfiguration.getAgentConfigUpdateIntervalSeconds() + " seconds.\n{}", (Object)r.getMessage(true));
            }
            catch (RuntimeException e) {
                log.warn("Encountered error checking monitoring mode. Will retry in " + this.bootstrapConfiguration.getAgentConfigUpdateIntervalSeconds() + " seconds.");
                log.debug("Encountered error during registration.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    void lifecycleStart() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future == null && this.bootstrapConfiguration.getAgentConfigUpdateEnabled().booleanValue()) {
                long pollingInterval = this.bootstrapConfiguration.getAgentConfigUpdateIntervalSeconds();
                this.future = this.executorService.scheduleAtFixedRate(this, 0L, pollingInterval, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void lifecycleStop() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    private GenericConfig buildAgentConfig() {
        GenericConfig.Builder configBuilder = this.getGenericConfigBuilder();
        DynamicMonitoringMachineAgentDto dynamicMonitoringMachineAgentDto = new DynamicMonitoringMachineAgentDto(Optional.absent());
        configBuilder.put("_dynamicMonitoringMachineAgentConfig", (Object)dynamicMonitoringMachineAgentDto);
        return configBuilder.build();
    }

    @VisibleForTesting
    GenericConfig.Builder getGenericConfigBuilder() {
        return GenericConfig.builder((ObjectMapper)this.objectMapper);
    }

    @VisibleForTesting
    void removeNonRunningMachineMappings(Set<Long> simMachineIds) {
        Set<Long> previouslyKnownMachineIds = this.dynamicMonitoringModeManager.getAllMachineIds();
        Sets.SetView nonReportingMachineIds = Sets.difference(previouslyKnownMachineIds, simMachineIds);
        if (!nonReportingMachineIds.isEmpty()) {
            log.debug("Machines with IDs : {} are not reporting any more. Clearing these machines from machine Id to dmm mode map.", (Object)nonReportingMachineIds);
            this.dynamicMonitoringModeManager.removeAll((Set<Long>)nonReportingMachineIds);
        }
    }
}

