/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.dmm;

import com.appdynamics.agent.sim.dmm.CategoryFilter;
import com.appdynamics.agent.sim.dmm.CategoryTree;
import com.appdynamics.sim.common.rest.dmm.DynamicMonitoringModeAgent;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.List;

public class CategoryFilterImpl
implements CategoryFilter {
    private final CategoryTree categoryTree;

    @Inject
    public CategoryFilterImpl(CategoryTree categoryTree) {
        this.categoryTree = categoryTree;
    }

    @Override
    public boolean isMetricValidForCurrentCategory(String metricName, DynamicMonitoringModeAgent currentMode) {
        if (currentMode == DynamicMonitoringModeAgent.ADVANCED_DIAGNOSTIC) {
            return true;
        }
        Optional<List<Integer>> categories = this.categoryTree.findCategories(metricName);
        if (categories.isPresent()) {
            List categoriesList = (List)categories.get();
            if (this.categoriesMatchExactly(categoriesList, currentMode)) {
                return true;
            }
            return this.isCategoryKpiAndModeDiagnostic(categoriesList, currentMode);
        }
        return false;
    }

    private boolean categoriesMatchExactly(List<Integer> categoriesList, DynamicMonitoringModeAgent mode) {
        int modeValue = mode.getModeValue();
        return categoriesList.contains(modeValue);
    }

    private boolean isCategoryKpiAndModeDiagnostic(List<Integer> categoriesList, DynamicMonitoringModeAgent mode) {
        if (mode == DynamicMonitoringModeAgent.DIAGNOSTIC) {
            int kpiModeValue = DynamicMonitoringModeAgent.KPI.getModeValue();
            return categoriesList.contains(kpiModeValue);
        }
        return false;
    }
}

