/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.containerd;

import com.appdynamics.agent.sim.containerd.ContainerdUtils;
import com.appdynamics.agent.sim.containerd.model.ContainerTaskPropertiesDto;
import com.appdynamics.agent.sim.containerd.model.ContainerdApiContainerMetricsRawData;
import com.appdynamics.agent.sim.containerd.model.ContainerdContainerDto;
import com.fasterxml.jackson.databind.ObjectMapper;
import containerd.services.containers.v1.ContainersGrpc;
import containerd.services.containers.v1.ContainersOuterClass;
import containerd.services.namespaces.v1.NamespaceOuterClass;
import containerd.services.namespaces.v1.NamespacesGrpc;
import containerd.services.tasks.v1.TasksGrpc;
import containerd.services.tasks.v1.TasksOuterClass;
import containerd.v1.types.Task;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerdService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerdService.class);
    ObjectMapper objectMapper;

    public ContainerdApiContainerMetricsRawData getContainerMetricsRawData(ContainerdContainerDto container) {
        ArrayList tasks = new ArrayList();
        String ctrCommand = "ctr -n " + container.getNamespace() + " tasks metrics " + container.getId() + " --format json; date -u +\"%Y-%m-%dT%H:%M:%S.%NZ\";";
        ContainerdApiContainerMetricsRawData containerdApiContainerMetricsRawData = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("bash", "-c", ctrCommand);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder output = new StringBuilder();
            String lastLine = "";
            String line = reader.readLine();
            if (line != null) {
                lastLine = line;
            }
            while ((line = reader.readLine()) != null) {
                output.append(lastLine).append("\n");
                lastLine = line;
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                String jsonString = output.toString();
                JSONObject jsonObject = new JSONObject(jsonString);
                containerdApiContainerMetricsRawData = ContainerdService.getContainerdApiContainerMetricsRawData(lastLine, jsonObject);
            } else {
                log.debug("Process for collecting container metrics data exited with exit code: " + exitCode);
                log.debug("Error while collecting container metrics data!");
            }
        }
        catch (IOException | InterruptedException e) {
            log.error("Error while collecting metrics for container with container Id: " + container.getId() + "\n Error: " + String.valueOf(e));
        }
        log.debug("Metrics raw data for container \"" + container.getId() + "\": " + String.valueOf(containerdApiContainerMetricsRawData));
        return containerdApiContainerMetricsRawData;
    }

    @NotNull
    private static ContainerdApiContainerMetricsRawData getContainerdApiContainerMetricsRawData(String timeStamp, JSONObject jsonObject) {
        long cpuUsage = 0L;
        long pageMaFault = 0L;
        long memUsage = 0L;
        try {
            if (jsonObject.has("cpu") && jsonObject.get("cpu") instanceof JSONObject) {
                JSONObject cpuUsageObj;
                JSONObject cpuObject = jsonObject.getJSONObject("cpu");
                if (cpuObject.has("usage_usec")) {
                    log.debug("Machine agent is possibly running on containerd, cpu = {}", (Object)cpuObject);
                    cpuUsage = cpuObject.get("usage_usec") instanceof JSONObject ? ((cpuUsageObj = cpuObject.getJSONObject("usage_usec")).has("total") ? cpuUsageObj.getLong("total") : 0L) : cpuObject.getLong("usage_usec");
                } else if (cpuObject.has("usage")) {
                    log.debug("Machine agent is possibly running on EKS as Infraviz, cpu = {}", (Object)cpuObject);
                    cpuUsage = cpuObject.get("usage") instanceof JSONObject ? ((cpuUsageObj = cpuObject.getJSONObject("usage")).has("total") ? cpuUsageObj.getLong("total") : 0L) : cpuObject.getLong("usage");
                } else {
                    cpuUsage = 0L;
                    log.debug("Machine agent is possibly running on some other platform, neither on EKS as Infraviz nor containerd,CPU Usage for container will be shown 0. cpu = {}", (Object)cpuObject);
                }
            }
        }
        catch (NullPointerException | JSONException e) {
            log.debug("Error occurred while reading JSON object of CPU Metrics raw data for container with error message " + e.getMessage());
            cpuUsage = 0L;
        }
        try {
            if (jsonObject.has("memory") && jsonObject.get("memory") instanceof JSONObject) {
                JSONObject memoryObject = jsonObject.getJSONObject("memory");
                long l = memoryObject.has("pgmajfault") ? memoryObject.getLong("pgmajfault") : (pageMaFault = memoryObject.has("pg_fault") ? memoryObject.getLong("pg_fault") : 0L);
                if (memoryObject.has("usage")) {
                    if (memoryObject.get("usage") instanceof JSONObject) {
                        log.debug("Machine agent is possibly running on EKS as Infraviz, memory = {}", (Object)memoryObject);
                        JSONObject memoryUsageObj = memoryObject.getJSONObject("usage");
                        memUsage = memoryUsageObj.has("usage") ? memoryUsageObj.getLong("usage") : 0L;
                    } else {
                        log.debug("Machine agent is possibly running on containerd, memory = {}", (Object)memoryObject);
                        memUsage = memoryObject.getLong("usage");
                    }
                } else {
                    memUsage = 0L;
                    log.debug("Machine agent is possibly running on some other platform, neither on EKS as Infraviz nor containerd,Memory Usage for container will be shown 0. memory = {}", (Object)memoryObject);
                }
            }
        }
        catch (NullPointerException | JSONException e) {
            log.debug("Error occurred while reading JSON object of Memory Metrics raw data for container with error message " + e.getMessage());
            pageMaFault = 0L;
            memUsage = 0L;
        }
        long memLimit = ContainerdUtils.getTotalMemoryBytes();
        ContainerdApiContainerMetricsRawData.Memory memory = ContainerdApiContainerMetricsRawData.Memory.builder().memUsage(memUsage).memLimit(memLimit).statsObject(new ContainerdApiContainerMetricsRawData.StatsObject(0L, 0L, pageMaFault)).build();
        ContainerdApiContainerMetricsRawData.Cpus cpus = ContainerdApiContainerMetricsRawData.Cpus.builder().cpuUsageStats(new ContainerdApiContainerMetricsRawData.CpuUsageStats(cpuUsage, new ArrayList<Long>())).build();
        ContainerdApiContainerMetricsRawData containerdApiContainerMetricsRawData2 = ContainerdApiContainerMetricsRawData.builder().timeStamp(timeStamp).networksInfoMap(new HashMap<String, ContainerdApiContainerMetricsRawData.NetworkInfo>()).blkIOObject(new ContainerdApiContainerMetricsRawData.BlkIOObject()).memory(memory).cpus(cpus).preCpus(new ContainerdApiContainerMetricsRawData.Cpus()).build();
        return containerdApiContainerMetricsRawData2;
    }

    public List<ContainerdContainerDto> getContainers() throws Exception {
        List<String> namespaces = this.getNamespaces();
        ArrayList<ContainerdContainerDto> containers = new ArrayList<ContainerdContainerDto>();
        for (String namespace : namespaces) {
            List<ContainerdContainerDto> tasks = this.getTasks(namespace);
            containers.addAll(tasks);
        }
        log.debug("Currently monitored containers: " + String.valueOf(containers));
        return containers;
    }

    public List<ContainerdContainerDto> getTasks(final String namespace) throws Exception {
        final Map<String, ContainerTaskPropertiesDto> taskProperties = this.getTaskProperties(namespace);
        CompletableFuture future = new CompletableFuture();
        final ArrayList tasks = new ArrayList();
        EpollEventLoopGroup elg = new EpollEventLoopGroup();
        final ManagedChannel channel = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress("/run/containerd/containerd.sock")).eventLoopGroup((EventLoopGroup)elg).channelType(EpollDomainSocketChannel.class).usePlaintext().build();
        Metadata header = new Metadata();
        Metadata.Key key = Metadata.Key.of((String)"containerd-namespace", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        header.put(key, (Object)namespace);
        TasksGrpc.TasksStub stub = TasksGrpc.newStub((Channel)channel);
        stub = (TasksGrpc.TasksStub)stub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)header)});
        TasksOuterClass.ListTasksRequest request = TasksOuterClass.ListTasksRequest.newBuilder().build();
        stub.list(request, new StreamObserver<TasksOuterClass.ListTasksResponse>(){
            final /* synthetic */ EventLoopGroup val$elg;
            final /* synthetic */ CompletableFuture val$future;
            {
                this.val$elg = eventLoopGroup;
                this.val$future = completableFuture;
            }

            public void onNext(TasksOuterClass.ListTasksResponse response) {
                List<Task.Process> containers = response.getTasksList();
                for (int i = 0; i < response.getTasksCount(); ++i) {
                    try {
                        Task.Process curr_task = response.getTasks(i);
                        String id = curr_task.getId();
                        String status = curr_task.getStatus().toString();
                        if (!taskProperties.containsKey(id)) {
                            log.debug("Properties not found for container id: " + id);
                            continue;
                        }
                        ContainerdContainerDto task = ContainerdContainerDto.builder().names(Arrays.asList(id, id)).image(((ContainerTaskPropertiesDto)taskProperties.get(id)).getImage()).id(id).status(status).namespace(namespace).build();
                        if (!Objects.equals(status, "RUNNING")) continue;
                        tasks.add(task);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Error reading the response after making the gRPC call to collect the task: " + String.valueOf(response.getTasks(i)));
                        log.error("Error: " + String.valueOf(e));
                    }
                }
            }

            public void onError(Throwable t) {
                log.error("Error occurred while making the gPRC call to get tasksfor namespace: " + namespace + "; " + String.valueOf(t));
            }

            public void onCompleted() {
                channel.shutdownNow();
                this.val$elg.shutdownGracefully(50L, 50L, TimeUnit.MILLISECONDS);
                this.val$future.complete(tasks);
                log.debug("Completed collection of tasks for namespace: " + namespace);
            }
        });
        log.debug("Tasks collected for namespace " + namespace + ": " + String.valueOf(future.get()));
        return (List)future.get();
    }

    public List<String> getNamespaces() throws ExecutionException, InterruptedException {
        CompletableFuture future = new CompletableFuture();
        final ArrayList namespaceList = new ArrayList();
        EpollEventLoopGroup elg = new EpollEventLoopGroup();
        final ManagedChannel channel = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress("/run/containerd/containerd.sock")).eventLoopGroup((EventLoopGroup)elg).channelType(EpollDomainSocketChannel.class).usePlaintext().build();
        Metadata header = new Metadata();
        Metadata.Key key = Metadata.Key.of((String)"containerd-namespace", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        header.put(key, (Object)"default");
        NamespacesGrpc.NamespacesStub stub = NamespacesGrpc.newStub((Channel)channel);
        stub = (NamespacesGrpc.NamespacesStub)stub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)header)});
        NamespaceOuterClass.ListNamespacesRequest request = NamespaceOuterClass.ListNamespacesRequest.newBuilder().build();
        stub.list(request, new StreamObserver<NamespaceOuterClass.ListNamespacesResponse>(){
            final /* synthetic */ EventLoopGroup val$elg;
            final /* synthetic */ CompletableFuture val$future;
            {
                this.val$elg = eventLoopGroup;
                this.val$future = completableFuture;
            }

            public void onNext(NamespaceOuterClass.ListNamespacesResponse response) {
                List<NamespaceOuterClass.Namespace> namespaces = response.getNamespacesList();
                for (int i = 0; i < response.getNamespacesCount(); ++i) {
                    try {
                        NamespaceOuterClass.Namespace namespace = namespaces.get(i);
                        String name = namespace.getName();
                        namespaceList.add(name);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Error reading the response after making the gRPC call to collect the namespace: " + String.valueOf(namespaces.get(i)));
                    }
                }
            }

            public void onError(Throwable t) {
                log.debug("Error occurred while making the gPRC call to get namespaces; " + String.valueOf(t));
            }

            public void onCompleted() {
                channel.shutdownNow();
                this.val$elg.shutdownGracefully(50L, 50L, TimeUnit.MILLISECONDS);
                this.val$future.complete(namespaceList);
            }
        });
        log.debug("Collected Namespaces: " + String.valueOf(future.get()));
        return (List)future.get();
    }

    public Map<String, ContainerTaskPropertiesDto> getTaskProperties(final String namespace) throws ExecutionException, InterruptedException {
        CompletableFuture future = new CompletableFuture();
        final HashMap taskProperties = new HashMap();
        EpollEventLoopGroup elg = new EpollEventLoopGroup();
        final ManagedChannel channel = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress("/run/containerd/containerd.sock")).eventLoopGroup((EventLoopGroup)elg).channelType(EpollDomainSocketChannel.class).usePlaintext().build();
        Metadata header = new Metadata();
        Metadata.Key key = Metadata.Key.of((String)"containerd-namespace", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        header.put(key, (Object)namespace);
        ContainersGrpc.ContainersStub stub = ContainersGrpc.newStub((Channel)channel);
        stub = (ContainersGrpc.ContainersStub)stub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)header)});
        ContainersOuterClass.ListContainersRequest request = ContainersOuterClass.ListContainersRequest.newBuilder().build();
        stub.list(request, new StreamObserver<ContainersOuterClass.ListContainersResponse>(){
            final /* synthetic */ EventLoopGroup val$elg;
            final /* synthetic */ CompletableFuture val$future;
            {
                this.val$elg = eventLoopGroup;
                this.val$future = completableFuture;
            }

            public void onNext(ContainersOuterClass.ListContainersResponse response) {
                List<ContainersOuterClass.Container> containers = response.getContainersList();
                ArrayList idList = new ArrayList();
                for (int i = 0; i < response.getContainersCount(); ++i) {
                    try {
                        ContainersOuterClass.Container container = containers.get(i);
                        if (container == null || StringUtils.isEmpty((CharSequence)container.getImage())) {
                            log.debug("Missing properties in gRPC response for container: " + container.getId() + " namespace: " + namespace + "; Possibly a docker container!");
                        }
                        taskProperties.put(container.getId(), ContainerdService.this.getContainerTaskPropertiesDto(container, namespace));
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Error reading the response after making the gRPC call to collect the task properties with namespace: " + namespace + "; container response: " + String.valueOf(containers.get(i)));
                    }
                }
            }

            public void onError(Throwable t) {
                log.error("Error occurred while making the gPRC call to to collect task properties with namespace: " + namespace + "; " + String.valueOf(t));
            }

            public void onCompleted() {
                channel.shutdownNow();
                this.val$elg.shutdownGracefully(50L, 50L, TimeUnit.MILLISECONDS);
                this.val$future.complete(taskProperties);
            }
        });
        log.debug("Collected task properties for namespace " + namespace + ": " + String.valueOf(future.get()));
        return (Map)future.get();
    }

    private ContainerTaskPropertiesDto getContainerTaskPropertiesDto(ContainersOuterClass.Container container, String namespace) {
        String id = container.getId();
        String image = container.getImage();
        String createdAt = Instant.ofEpochSecond(container.getCreatedAt().getSeconds(), container.getCreatedAt().getNanos()).toString();
        String updatedAt = Instant.ofEpochSecond(container.getUpdatedAt().getSeconds(), container.getUpdatedAt().getNanos()).toString();
        Map<String, String> labels = container.getLabels();
        HashMap<String, String> labelsMap = new HashMap<String, String>();
        for (String key : labels.keySet()) {
            labelsMap.put(key, labels.get(key));
        }
        ContainerTaskPropertiesDto containerTaskPropertiesDto = ContainerTaskPropertiesDto.builder().id(id).labels(labelsMap).image(image).createdAt(createdAt).updatedAt(updatedAt).namespace(namespace).build();
        return containerTaskPropertiesDto;
    }
}

