/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.configuration.bootstrap;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.docker.DockerService;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.singularity.ee.agent.resolver.DefaultHostIdentifierResolver;
import com.singularity.ee.agent.systemagent.logger.Slf4jLogger;
import com.singularity.ee.util.logging.ILogger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HostIdProvider
implements Provider<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HostIdProvider.class);
    private final BootstrapConfiguration configuration;
    private final Supplier<DockerService> dockerServiceSupplier;

    @Inject
    HostIdProvider(BootstrapConfiguration configuration, Supplier<DockerService> dockerService) {
        this.configuration = configuration;
        this.dockerServiceSupplier = dockerService;
    }

    public String get() {
        String hostId = this.configuration.getHostId();
        if (hostId == null || hostId.isEmpty()) {
            DockerService dockerService = (DockerService)this.dockerServiceSupplier.get();
            if (this.configuration.getDockerEnabled().booleanValue()) {
                hostId = dockerService.getServerInfo().getName();
                log.debug("Retrieving Server Info {}", (Object)dockerService.getServerInfo());
                if (hostId == null) {
                    throw new ProvisionException("Could not get the physical server host from Docker Engine");
                }
            } else {
                System.setProperty("appdynamics.agent.use.simple.hostname", this.configuration.getUseSimpleHostname().toString());
                DefaultHostIdentifierResolver hostIdentifierResolver = new DefaultHostIdentifierResolver((ILogger)new Slf4jLogger(log), null);
                hostIdentifierResolver.run();
                if (hostIdentifierResolver.resolutionSucceeded()) {
                    hostId = hostIdentifierResolver.getUniqueHostIdentifier();
                } else {
                    throw new ProvisionException("Could not get the host identifier.");
                }
            }
        }
        return hostId;
    }
}

