/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.configuration.bootstrap;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.docker.DockerUtils;
import com.appdynamics.voltron.utils.overrides.OverrideByEnvironmentVariable;
import com.appdynamics.voltron.utils.overrides.OverrideBySystemProperty;
import com.appdynamics.voltron.utils.overrides.OverrideIfBlank;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JacksonXmlRootElement(localName="controller-info")
public class DefaultBootstrapConfiguration
implements BootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultBootstrapConfiguration.class);
    private static final long DEFAULT_INITIAL_RETRY_PERIOD = 100L;
    private static final long DEFAULT_MAX_RETRY_PERIOD = 1000L;
    protected static final int DEFAULT_MAX_RETRIES = 5;
    private static final int DEFAULT_EXTENSIONS_SCHEDULER_CORE_POOL_SIZE = 12;
    private static final long DEFAULT_EXTENSIONS_SCHEDULER_SHUTDOWN_TIMEOUT = 10000L;
    private static final long DEFAULT_METRIC_AGGREGATOR_CACHE_EXPIRATION_TIME_SECONDS = 120L;
    private static final String DEFAULT_EXTENSIONS_DIRECTORY = "extensions";
    private static final long DEFAULT_EXTENSIONS_UPDATE_INTERVAL_MILLIS = 30000L;
    private static final long DEFAULT_EXTENSIONS_MAX_START_TIME_MILLIS = 10000L;
    private static final long DEFAULT_EXTENSIONS_MAX_STOP_TIME_MILLIS = 10000L;
    private static final boolean DEFAULT_SIM_USER_ENABLED = false;
    private static final long DEFAULT_SAM_CONFIG_UPDATE_INTERVAL_MILLIS = 120000L;
    private static final long DEFAULT_MAIN_CONFIG_UPDATE_INTERVAL_MILLIS = 30000L;
    private static final long DEFAULT_MAIN_CONFIG_TIMEOUT_MILLIS = 30000L;
    private static final long DEFAULT_SAM_STATE_UPDATE_INTERVAL_MILLIS = 240000L;
    private static final long DEFAULT_SAM_EVENT_UPDATE_INTERVAL_MILLIS = 300000L;
    private static final String DEFAULT_MONITORING_MODE = "ADVANCED_DIAGNOSTIC";
    private static final long DEFAULT_AGENT_CONFIG_UPDATE_INTERVAL = 60L;
    private static final boolean DEFAULT_AGENT_CONFIG_UPDATE_ENABLED = true;
    private static final boolean DEFAULT_DOCKER_ENABLED = false;
    private static final boolean DEFAULT_DYNAMIC_MONITORING_ENABLED = true;
    private static final String DEFAULT_DOCKER_ENGINE_URL = "unix:///var/run/docker.sock";
    private static final boolean DEFAULT_COLLECT_MEMORY_METRICS_FROM_FREE_COMMAND_ENABLED = false;
    private static final boolean DEFAULT_COLLECT_MEMORY_METRICS_FROM_VMSTAT_COMMAND_ENABLED = false;
    private static final boolean DEFAULT_MACHINE_AGENT_WINDOWS_ADJUST_CPU_STEAL_IN_CPU_USED_PCT = true;
    private static final boolean DEFAULT_CONTAINERD_ENABLED = false;
    private static final String DEFAULT_CLUSTER_NAME = "";
    private static final boolean DEFAULT_REGISTRATION_RESILIENCE_ENABLED = false;
    private static final boolean DEFAULT_CONTAINER_OLD_CPU_METRIC_KEY_ENABLED = false;
    private static final boolean DEFAULT_PROCESS_LEVEL_METRICS_ENABLED = false;
    private static final String DEFAULT_DCGM_EXPORTER_SERVICE_NAMESPACE = "gpu-operator";
    private static final String DEFAULT_DCGM_EXPORTER_SERVICE_NAME = "nvidia-dcgm-exporter";
    private static final int DEFAULT_DCGM_EXPORTER_SERVICE_PORT = 9400;
    private static final String DEFAULT_DCGM_EXPORTER_SERVICE_HOST = "";
    private static final boolean DEFAULT_GPU_ENABLED = false;
    private static final String DEFAULT_HOSTROOT = "/hostroot";
    private static final long DEFAULT_REGISTRATION_PERIOD_SECONDS = 60L;
    private static final char HIERARCHY_SEPARATOR = '|';
    @NotEmpty(message="The controller host must be specified in the 'controller-host' element.")
    @JacksonXmlProperty(localName="controller-host")
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_CONTROLLER_HOST_NAME"})
    @OverrideBySystemProperty(value={"appdynamics.controller.hostName"})
    private @NotEmpty(message="The controller host must be specified in the 'controller-host' element.") String controllerHost;
    @Min(value=1L, message="The controller port must be >= 1 in the 'controller-port' element.")
    @NotNull
    @JacksonXmlProperty(localName="controller-port")
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_CONTROLLER_PORT"})
    @OverrideBySystemProperty(value={"appdynamics.controller.port"})
    private @Min(value=1L, message="The controller port must be >= 1 in the 'controller-port' element.") @NotNull Integer controllerPort;
    @NotNull
    @JacksonXmlProperty(localName="controller-ssl-enabled")
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_CONTROLLER_SSL_ENABLED"})
    @OverrideBySystemProperty(value={"appdynamics.controller.ssl.enabled"})
    @OverrideIfBlank(value="false")
    private Boolean controllerSslEnabled = false;
    @NotNull
    @JacksonXmlProperty(localName="force-default-certificate-validation")
    @OverrideBySystemProperty(value={"appdynamics.force.default.ssl.certificate.validation"})
    @OverrideIfBlank(value="false")
    private Boolean fullSslValidationEnforced = false;
    @JacksonXmlProperty(localName="ssl-protocol")
    @OverrideBySystemProperty(value={"appdynamics.agent.ssl.protocol"})
    private String sslProtocol;
    @NotNull
    @JacksonXmlProperty(localName="enable-orchestration")
    @OverrideBySystemProperty(value={"appdynamics.agent.enableOrchestration"})
    @OverrideIfBlank(value="false")
    private Boolean orchestrationEnabled = false;
    @NotNull
    @JacksonXmlProperty(localName="force-agent-registration")
    @OverrideIfBlank(value="false")
    private Boolean agentRegistrationForced = false;
    @NotEmpty
    @JacksonXmlProperty(localName="account-name")
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_AGENT_ACCOUNT_NAME"})
    @OverrideBySystemProperty(value={"appdynamics.agent.accountName"})
    @OverrideIfBlank(value="customer1")
    private String accountName = "customer1";
    @JacksonXmlProperty(localName="account-access-key")
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_AGENT_ACCOUNT_ACCESS_KEY"})
    @OverrideBySystemProperty(value={"appdynamics.agent.accountAccessKey"})
    @NotEmpty
    private String accountAccessKey;
    @JacksonXmlProperty(localName="machine-path")
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_HIERARCHY_PATH"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.hierarchyPath"})
    @Pattern(regexp="^(.{0,95}\\|)?[^\\|]*$", message="The machine path exceeded the maximum length.")
    private @Pattern(regexp="^(.{0,95}\\|)?[^\\|]*$", message="The machine path exceeded the maximum length.") String machinePath;
    @JacksonXmlProperty(localName="unique-host-id")
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_AGENT_UNIQUE_HOST_ID"})
    @OverrideBySystemProperty(value={"appdynamics.agent.uniqueHostId"})
    private String hostId;
    @JacksonXmlProperty(localName="use-simple-hostname")
    @OverrideBySystemProperty(value={"appdynamics.agent.use.simple.hostname"})
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean useSimpleHostname = false;
    @JacksonXmlProperty(localName="agent-registration-interval")
    @Min(value=1L, message="The registration interval must be at least 1 second in the 'agent-reregistration-interval' element.")
    @NotNull
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_REGISTRATION_INTERVAL"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.registration.interval"})
    @OverrideIfBlank(value="60")
    private @Min(value=1L, message="The registration interval must be at least 1 second in the 'agent-reregistration-interval' element.") @NotNull Long registrationPeriodSeconds = 60L;
    @JacksonXmlProperty(localName="application-name")
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_AGENT_APPLICATION_NAME"})
    @OverrideBySystemProperty(value={"appdynamics.agent.applicationName"})
    private String applicationName;
    @JacksonXmlProperty(localName="tier-name")
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_AGENT_TIER_NAME"})
    @OverrideBySystemProperty(value={"appdynamics.agent.tierName"})
    private String tierName;
    @JacksonXmlProperty(localName="node-name")
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_AGENT_NODE_NAME"})
    @OverrideBySystemProperty(value={"appdynamics.agent.nodeName"})
    private String nodeName;
    @JacksonXmlProperty(localName="agent-runtime-dir")
    @OverrideBySystemProperty(value={"appdynamics.agent.runtime.dir"})
    private String agentRuntimeDir;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_CONTROLLER_KEYSTORE_FILENAME"})
    @JacksonXmlProperty(localName="controller-keystore-filename")
    private String trustStorePath;
    @JacksonXmlProperty(localName="asymmetric-keystore-filename")
    private String keyStorePath;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_CONTROLLER_KEYSTORE_PASSWORD"})
    @JacksonXmlProperty(localName="controller-keystore-password")
    private String trustStorePassword;
    @JacksonXmlProperty(localName="asymmetric-keystore-password")
    private String keyStorePassword;
    @JacksonXmlProperty(localName="asymmetric-key-password")
    private String keyStorePrivateKeyPassword;
    @JacksonXmlProperty(localName="asymmetric-key-alias")
    private String asymmetricKeyAlias;
    @JacksonXmlProperty(localName="use-ssl-client-auth")
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean sslClientAuthenticationEnabled = false;
    @OverrideBySystemProperty(value={"com.singularity.httpclientwrapper.proxyHost", "appdynamics.http.proxyHost"})
    private String proxyHost;
    @OverrideBySystemProperty(value={"com.singularity.httpclientwrapper.proxyPort", "appdynamics.http.proxyPort"})
    private Integer proxyPort;
    @OverrideBySystemProperty(value={"appdynamics.http.proxyUser"})
    private String proxyUsername;
    @OverrideBySystemProperty(value={"appdynamics.http.proxyPasswordFile"})
    private String proxyPasswordFile;
    @OverrideBySystemProperty(value={"appdynamics.http.preemptiveProxyAuth"})
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean proxyUsePreemptiveAuth = Boolean.FALSE;
    @NotNull
    @JacksonXmlProperty(localName="client-gzip-enabled")
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.clientGzipEnabled"})
    @OverrideIfBlank(value="true")
    private Boolean clientGzipEnabled = true;
    @NotNull
    @JacksonXmlProperty(localName="use-encrypted-credentials")
    @OverrideIfBlank(value="false")
    private Boolean useEncryptedCredentials = false;
    @JacksonXmlProperty(localName="credential-store-filename")
    private String credentialStoreFilename;
    @JacksonXmlProperty(localName="credential-store-password")
    private String obfuscatedCredentialStorePassword;
    @JacksonXmlProperty(localName="credential-store-format")
    private String credentialStoreFormat;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.request.initialRetryPeriod"})
    @JacksonXmlProperty(localName="agent-request-initial-retry-period")
    @OverrideIfBlank(value="100")
    @Min(value=0L)
    @NotNull
    private @Min(value=0L) @NotNull Long requestInitialRetryPeriod = 100L;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.request.maxRetryPeriod"})
    @JacksonXmlProperty(localName="agent-request-max-retry-period")
    @OverrideIfBlank(value="1000")
    @Min(value=0L)
    @NotNull
    private @Min(value=0L) @NotNull Long requestMaxRetryPeriod = 1000L;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.request.maxRetries"})
    @JacksonXmlProperty(localName="agent-request-max-retries")
    @OverrideIfBlank(value="5")
    @Min(value=0L)
    @NotNull
    private @Min(value=0L) @NotNull Integer requestMaxRetries = 5;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.extensions.scheduler.corePoolSize"})
    @JacksonXmlProperty(localName="extensions-scheduler-core-pool-size")
    @Min(value=0L)
    @NotNull
    @OverrideIfBlank(value="12")
    private @Min(value=0L) @NotNull Integer extensionsSchedulerCorePoolSize = 12;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.extensions.scheduler.shutdownTimeoutMillis"})
    @JacksonXmlProperty(localName="extensions-scheduler-shutdown-timeout")
    @Min(value=0L)
    @NotNull
    @OverrideIfBlank(value="10000")
    private @Min(value=0L) @NotNull Long extensionsSchedulerShutdownTimeoutMillis = 10000L;
    @JacksonXmlProperty(localName="extensions-directory")
    @NotEmpty
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.extensions.directory"})
    @OverrideIfBlank(value="extensions")
    private String extensionsDirectory = "extensions";
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.extensions.updateIntervalMillis"})
    @JacksonXmlProperty(localName="extensions-update-interval")
    @Min(value=1000L)
    @NotNull
    @OverrideIfBlank(value="30000")
    private @Min(value=1000L) @NotNull Long extensionsUpdateIntervalMillis = 30000L;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.extensions.maxStartTimeMillis"})
    @JacksonXmlProperty(localName="extensions-max-start-time")
    @Min(value=200L)
    @NotNull
    @OverrideIfBlank(value="10000")
    private @Min(value=200L) @NotNull Long extensionsMaxStartTimeMillis = 10000L;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.extensions.maxStopTimeMillis"})
    @JacksonXmlProperty(localName="extensions-max-stop-time")
    @Min(value=200L)
    @NotNull
    @OverrideIfBlank(value="10000")
    private @Min(value=200L) @NotNull Long extensionsMaxStopTimeMillis = 10000L;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.aggregatorExpiration.interval"})
    @JacksonXmlProperty(localName="metric-aggregator-cache-expiration-seconds")
    @Min(value=0L)
    @NotNull
    @OverrideIfBlank(value="120")
    private @Min(value=0L) @NotNull Long metricAggregatorCacheExpirationTimeSeconds = 120L;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_SIM_ENABLED"})
    @OverrideBySystemProperty(value={"appdynamics.sim.enabled"})
    @JacksonXmlProperty(localName="sim-enabled")
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean simUserEnabled = false;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.sam.config.updateIntervalMillis"})
    @JacksonXmlProperty(localName="sam-config-update-interval-millis")
    @Min(value=1L)
    @OverrideIfBlank(value="120000")
    private @Min(value=1L) Long samConfigUpdateIntervalMillis = 120000L;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.config.updateIntervalMillis"})
    @JacksonXmlProperty(localName="main-config-update-interval-millis")
    @Min(value=1L)
    @OverrideIfBlank(value="30000")
    private @Min(value=1L) Long mainConfigUpdateIntervalMillis = 30000L;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.config.timeoutMillis"})
    @JacksonXmlProperty(localName="main-config-timeout-millis")
    @Min(value=1L)
    @OverrideIfBlank(value="30000")
    private @Min(value=1L) Long mainConfigTimeoutMillis = 30000L;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.sam.state.updateIntervalMillis"})
    @JacksonXmlProperty(localName="sam-state-update-interval-millis")
    @Min(value=1L)
    @OverrideIfBlank(value="240000")
    private @Min(value=1L) Long samStateUpdateIntervalMillis = 240000L;
    @NotNull
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.registration.createNodeIfAbsent"})
    @JacksonXmlProperty(localName="create-node-if-absent")
    @OverrideIfBlank(value="true")
    private Boolean createNodeIfAbsent = true;
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.sam.event.updateIntervalMillis"})
    @JacksonXmlProperty(localName="sam-event-update-interval-millis")
    @Min(value=1L)
    @OverrideIfBlank(value="300000")
    private @Min(value=1L) Long samEventUpdateIntervalMillis = 300000L;
    @NotNull
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.dotnetCompatibilityMode"})
    @JacksonXmlProperty(localName="dotnet-compatibility-mode")
    @OverrideIfBlank(value="false")
    @Deprecated
    @VisibleForTesting
    private Boolean dotnetCompatibilityMode = false;
    @NotNull
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.compatibilityMode"})
    @JacksonXmlProperty(localName="compatibility-mode")
    @OverrideIfBlank(value="false")
    private Boolean compatibilityMode = false;
    @JacksonXmlProperty(localName="agent-config-update-interval")
    @Min(value=15L, message="The agent config update interval must be at least {value} second in order to work.")
    @NotNull
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.config.updateInterval"})
    @OverrideIfBlank(value="60")
    private @Min(value=15L, message="The agent config update interval must be at least {value} second in order to work.") @NotNull Long agentConfigUpdateIntervalSeconds = 60L;
    @NotNull
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.config.updateEnabled"})
    @JacksonXmlProperty(localName="agent-config-update-enabled")
    @OverrideIfBlank(value="true")
    private Boolean agentConfigUpdateEnabled = true;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_DOCKER_ENABLED"})
    @OverrideBySystemProperty(value={"appdynamics.docker.enabled"})
    @JacksonXmlProperty(localName="docker-enabled")
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean dockerEnabled = false;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_DOCKER_ENGINE_URL"})
    @OverrideBySystemProperty(value={"appdynamics.docker.engine.url"})
    @JacksonXmlProperty(localName="docker-engine-url")
    @NotNull
    @OverrideIfBlank(value="unix:///var/run/docker.sock")
    private String dockerEngineUrl = "unix:///var/run/docker.sock";
    @OverrideByEnvironmentVariable(value={"SAPSYSTEMNAME"})
    @OverrideBySystemProperty(value={"is-sap-machine"})
    @JacksonXmlProperty(localName="is-sap-machine")
    @NotNull
    @OverrideIfBlank(value="false")
    private String sapMachine = "false";
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_DYNAMIC_MONITORING_ENABLED"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.dynamicMonitoring.enabled"})
    @JacksonXmlProperty(localName="dynamic-monitoring-enabled")
    @NotNull
    @OverrideIfBlank(value="true")
    private Boolean dmmUserEnabled = true;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_CONTAINERD_ENABLED"})
    @OverrideBySystemProperty(value={"appdynamics.containerd.enabled"})
    @JacksonXmlProperty(localName="containerd-enabled")
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean containerdEnabled = false;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_CLUSTER_NAME"})
    @OverrideIfBlank(value="")
    @NotNull
    private String clusterName = "";
    @JsonIgnore
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_AGENT_WINDOWS_ADJUST_CPU_STEAL_IN_CPU_USED_PCT"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.windows.adjust.cpu.steal.in.cpu.used.pct"})
    @NotNull
    @OverrideIfBlank(value="true")
    private Boolean machineAgentWindowsAdjustCpuStealInCpuUsedPct = true;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_DOCKER_MOUNTED_HOST_ROOT"})
    @NotNull
    @OverrideIfBlank(value="/hostroot")
    private String bindMountOfHostRoot = "/hostroot";
    @JsonIgnore
    @VisibleForTesting
    private volatile boolean osLinux = DockerUtils.isDockerMonitoringSupportedOnCurrentOS();
    @JsonIgnore
    private volatile String machineName = "";
    @JsonIgnore
    private volatile List<String> machineHierarchy = Collections.emptyList();
    private transient boolean machinePathParsed = false;
    @JsonIgnore
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_COLLECT_MEMORY_METRICS_USING_FREE_COMMAND"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.collect.memoryMetrics.using.free.command"})
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean collectMemoryMetricsUsingFreeCommandEnabled = false;
    @JsonIgnore
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_COLLECT_MEMORY_METRICS_USING_VMSTAT_COMMAND"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.collect.memoryMetrics.using.vmstat.command"})
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean collectMemoryMetricsUsingVmstatCommandEnabled = false;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_AGENT_REGISTRATION_RESILIENCE_ENABLED"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.registration.resilience.enabled"})
    @JacksonXmlProperty(localName="registration-resilience-enabled")
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean registrationResilienceEnabled = false;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_AGENT_CONTAINER_OLD_CPU_METRIC_KEY_ENABLED"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.container.old.cpu.metric.key.enabled"})
    @JacksonXmlProperty(localName="container-old-cpu-metric-key-enabled")
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean containerOldCpuMetricKeyEnabled = false;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_AGENT_PROCESS_METRICS_ENABLED"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.process.metrics.enabled"})
    @JacksonXmlProperty(localName="process-metrics-enabled")
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean processLevelMetricsEnabled = false;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_AGENT_DCGM_EXPORTER_SERVICE_NAMESPACE"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.dcgm.exporter.service.namespace"})
    @JacksonXmlProperty(localName="dcgm-exporter-service-namespace")
    @NotNull
    @OverrideIfBlank(value="gpu-operator")
    private String dcgmExporterServiceNamespace = "gpu-operator";
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_AGENT_DCGM_EXPORTER_SERVICE_NAME"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.dcgm.exporter.service.name"})
    @JacksonXmlProperty(localName="dcgm-exporter-service-name")
    @NotNull
    @OverrideIfBlank(value="nvidia-dcgm-exporter")
    private String dcgmExporterServiceName = "nvidia-dcgm-exporter";
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_AGENT_DCGM_EXPORTER_SERVICE_PORT"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.dcgm.exporter.service.port"})
    @JacksonXmlProperty(localName="dcgm-exporter-service-port")
    @NotNull
    @OverrideIfBlank(value="9400")
    private Integer dcgmExporterServicePort = 9400;
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_AGENT_DCGM_EXPORTER_SERVICE_HOST"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.dcgm.exporter.service.host"})
    @JacksonXmlProperty(localName="dcgm-exporter-service-host")
    @NotNull
    @OverrideIfBlank(value="")
    private String dcgmExporterServiceHost = "";
    @OverrideByEnvironmentVariable(value={"APPDYNAMICS_MACHINE_AGENT_GPU_ENABLED"})
    @OverrideBySystemProperty(value={"appdynamics.machine.agent.gpu.enabled"})
    @JacksonXmlProperty(localName="gpu-enabled")
    @NotNull
    @OverrideIfBlank(value="false")
    private Boolean gpuEnabled = false;

    @Override
    public List<String> getMachineHierarchy() {
        this.parsePath();
        return this.machineHierarchy;
    }

    @Override
    public String getMachineName() {
        this.parsePath();
        return this.machineName;
    }

    @Override
    public String getClusterName() {
        if (this.clusterName == null) {
            this.clusterName = "";
        }
        return this.clusterName;
    }

    @Override
    public Boolean getCompatibilityMode() {
        return this.dotnetCompatibilityMode != false || this.compatibilityMode != false;
    }

    @Override
    public String getBindMountOfHostRoot() {
        return this.bindMountOfHostRoot;
    }

    void parsePath() {
        if (!this.machinePathParsed && this.machinePath != null) {
            ArrayList path = new ArrayList(Splitter.on((char)'|').splitToList((CharSequence)this.machinePath));
            if (path.size() > 0) {
                this.machineName = (String)path.remove(path.size() - 1);
                this.machineHierarchy = Collections.unmodifiableList(path);
            }
            this.machinePathParsed = true;
        }
        if (this.machineName == null) {
            this.machineName = "";
        }
        if (this.machineHierarchy == null) {
            this.machineHierarchy = Collections.emptyList();
        }
    }

    @Override
    public Boolean getSapMachine() {
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.sapMachine, (CharSequence)"false")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean getDockerEnabled() {
        return this.dockerEnabled != false && this.osLinux;
    }

    @Override
    public Boolean getCollectMemoryMetricsUsingFreeCommandEnabled() {
        return this.collectMemoryMetricsUsingFreeCommandEnabled;
    }

    @Override
    public Boolean getCollectMemoryMetricsUsingVmstatCommandEnabled() {
        return this.collectMemoryMetricsUsingVmstatCommandEnabled;
    }

    @Override
    public Boolean getContainerdEnabled() {
        return this.containerdEnabled != false && this.osLinux;
    }

    @Override
    public Boolean getRegistrationResilienceEnabled() {
        return this.registrationResilienceEnabled;
    }

    @Override
    public Boolean getContainerOldCpuMetricKeyEnabled() {
        return this.containerOldCpuMetricKeyEnabled;
    }

    @Override
    public Boolean getProcessLevelMetricsEnabled() {
        return this.processLevelMetricsEnabled;
    }

    @Override
    public String getDcgmExporterServiceName() {
        return this.dcgmExporterServiceName;
    }

    @Override
    public String getDcgmExporterServiceNamespace() {
        return this.dcgmExporterServiceNamespace;
    }

    @Override
    public Integer getDcgmExporterServicePort() {
        return this.dcgmExporterServicePort;
    }

    @Override
    public String getDcgmExporterServiceHost() {
        if (this.dcgmExporterServiceHost == null) {
            return "";
        }
        return this.dcgmExporterServiceHost;
    }

    @Override
    public Boolean getGpuEnabled() {
        return this.gpuEnabled;
    }

    @Generated
    public DefaultBootstrapConfiguration() {
    }

    @Override
    @Generated
    public String getControllerHost() {
        return this.controllerHost;
    }

    @Override
    @Generated
    public Integer getControllerPort() {
        return this.controllerPort;
    }

    @Override
    @Generated
    public Boolean getControllerSslEnabled() {
        return this.controllerSslEnabled;
    }

    @Override
    @Generated
    public Boolean getFullSslValidationEnforced() {
        return this.fullSslValidationEnforced;
    }

    @Override
    @Generated
    public String getSslProtocol() {
        return this.sslProtocol;
    }

    @Override
    @Generated
    public Boolean getOrchestrationEnabled() {
        return this.orchestrationEnabled;
    }

    @Override
    @Generated
    public Boolean getAgentRegistrationForced() {
        return this.agentRegistrationForced;
    }

    @Override
    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Override
    @Generated
    public String getAccountAccessKey() {
        return this.accountAccessKey;
    }

    @Generated
    public String getMachinePath() {
        return this.machinePath;
    }

    @Override
    @Generated
    public String getHostId() {
        return this.hostId;
    }

    @Override
    @Generated
    public Boolean getUseSimpleHostname() {
        return this.useSimpleHostname;
    }

    @Override
    @Generated
    public Long getRegistrationPeriodSeconds() {
        return this.registrationPeriodSeconds;
    }

    @Override
    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    @Generated
    public String getTierName() {
        return this.tierName;
    }

    @Override
    @Generated
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    @Generated
    public String getAgentRuntimeDir() {
        return this.agentRuntimeDir;
    }

    @Override
    @Generated
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    @Generated
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Override
    @Generated
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    @Generated
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    @Generated
    public String getKeyStorePrivateKeyPassword() {
        return this.keyStorePrivateKeyPassword;
    }

    @Override
    @Generated
    public String getAsymmetricKeyAlias() {
        return this.asymmetricKeyAlias;
    }

    @Override
    @Generated
    public Boolean getSslClientAuthenticationEnabled() {
        return this.sslClientAuthenticationEnabled;
    }

    @Override
    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    @Generated
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Override
    @Generated
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    @Generated
    public String getProxyPasswordFile() {
        return this.proxyPasswordFile;
    }

    @Override
    @Generated
    public Boolean getProxyUsePreemptiveAuth() {
        return this.proxyUsePreemptiveAuth;
    }

    @Override
    @Generated
    public Boolean getClientGzipEnabled() {
        return this.clientGzipEnabled;
    }

    @Override
    @Generated
    public Boolean getUseEncryptedCredentials() {
        return this.useEncryptedCredentials;
    }

    @Override
    @Generated
    public String getCredentialStoreFilename() {
        return this.credentialStoreFilename;
    }

    @Override
    @Generated
    public String getObfuscatedCredentialStorePassword() {
        return this.obfuscatedCredentialStorePassword;
    }

    @Override
    @Generated
    public String getCredentialStoreFormat() {
        return this.credentialStoreFormat;
    }

    @Override
    @Generated
    public Long getRequestInitialRetryPeriod() {
        return this.requestInitialRetryPeriod;
    }

    @Override
    @Generated
    public Long getRequestMaxRetryPeriod() {
        return this.requestMaxRetryPeriod;
    }

    @Override
    @Generated
    public Integer getRequestMaxRetries() {
        return this.requestMaxRetries;
    }

    @Override
    @Generated
    public Integer getExtensionsSchedulerCorePoolSize() {
        return this.extensionsSchedulerCorePoolSize;
    }

    @Override
    @Generated
    public Long getExtensionsSchedulerShutdownTimeoutMillis() {
        return this.extensionsSchedulerShutdownTimeoutMillis;
    }

    @Override
    @Generated
    public String getExtensionsDirectory() {
        return this.extensionsDirectory;
    }

    @Override
    @Generated
    public Long getExtensionsUpdateIntervalMillis() {
        return this.extensionsUpdateIntervalMillis;
    }

    @Override
    @Generated
    public Long getExtensionsMaxStartTimeMillis() {
        return this.extensionsMaxStartTimeMillis;
    }

    @Override
    @Generated
    public Long getExtensionsMaxStopTimeMillis() {
        return this.extensionsMaxStopTimeMillis;
    }

    @Override
    @Generated
    public Long getMetricAggregatorCacheExpirationTimeSeconds() {
        return this.metricAggregatorCacheExpirationTimeSeconds;
    }

    @Override
    @Generated
    public Boolean getSimUserEnabled() {
        return this.simUserEnabled;
    }

    @Override
    @Generated
    public Long getSamConfigUpdateIntervalMillis() {
        return this.samConfigUpdateIntervalMillis;
    }

    @Override
    @Generated
    public Long getMainConfigUpdateIntervalMillis() {
        return this.mainConfigUpdateIntervalMillis;
    }

    @Override
    @Generated
    public Long getMainConfigTimeoutMillis() {
        return this.mainConfigTimeoutMillis;
    }

    @Override
    @Generated
    public Long getSamStateUpdateIntervalMillis() {
        return this.samStateUpdateIntervalMillis;
    }

    @Override
    @Generated
    public Boolean getCreateNodeIfAbsent() {
        return this.createNodeIfAbsent;
    }

    @Override
    @Generated
    public Long getSamEventUpdateIntervalMillis() {
        return this.samEventUpdateIntervalMillis;
    }

    @Override
    @Generated
    public Long getAgentConfigUpdateIntervalSeconds() {
        return this.agentConfigUpdateIntervalSeconds;
    }

    @Override
    @Generated
    public Boolean getAgentConfigUpdateEnabled() {
        return this.agentConfigUpdateEnabled;
    }

    @Override
    @Generated
    public String getDockerEngineUrl() {
        return this.dockerEngineUrl;
    }

    @Override
    @Generated
    public Boolean getDmmUserEnabled() {
        return this.dmmUserEnabled;
    }

    @Override
    @Generated
    public Boolean getMachineAgentWindowsAdjustCpuStealInCpuUsedPct() {
        return this.machineAgentWindowsAdjustCpuStealInCpuUsedPct;
    }

    @JacksonXmlProperty(localName="controller-host")
    @Generated
    public void setControllerHost(String controllerHost) {
        this.controllerHost = controllerHost;
    }

    @JacksonXmlProperty(localName="controller-port")
    @Generated
    public void setControllerPort(Integer controllerPort) {
        this.controllerPort = controllerPort;
    }

    @JacksonXmlProperty(localName="controller-ssl-enabled")
    @Generated
    public void setControllerSslEnabled(Boolean controllerSslEnabled) {
        this.controllerSslEnabled = controllerSslEnabled;
    }

    @JacksonXmlProperty(localName="force-default-certificate-validation")
    @Generated
    public void setFullSslValidationEnforced(Boolean fullSslValidationEnforced) {
        this.fullSslValidationEnforced = fullSslValidationEnforced;
    }

    @JacksonXmlProperty(localName="ssl-protocol")
    @Generated
    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    @JacksonXmlProperty(localName="enable-orchestration")
    @Generated
    public void setOrchestrationEnabled(Boolean orchestrationEnabled) {
        this.orchestrationEnabled = orchestrationEnabled;
    }

    @JacksonXmlProperty(localName="force-agent-registration")
    @Generated
    public void setAgentRegistrationForced(Boolean agentRegistrationForced) {
        this.agentRegistrationForced = agentRegistrationForced;
    }

    @JacksonXmlProperty(localName="account-name")
    @Generated
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    @JacksonXmlProperty(localName="account-access-key")
    @Generated
    public void setAccountAccessKey(String accountAccessKey) {
        this.accountAccessKey = accountAccessKey;
    }

    @JacksonXmlProperty(localName="machine-path")
    @Generated
    public void setMachinePath(String machinePath) {
        this.machinePath = machinePath;
    }

    @JacksonXmlProperty(localName="unique-host-id")
    @Generated
    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    @JacksonXmlProperty(localName="use-simple-hostname")
    @Generated
    public void setUseSimpleHostname(Boolean useSimpleHostname) {
        this.useSimpleHostname = useSimpleHostname;
    }

    @JacksonXmlProperty(localName="agent-registration-interval")
    @Generated
    public void setRegistrationPeriodSeconds(Long registrationPeriodSeconds) {
        this.registrationPeriodSeconds = registrationPeriodSeconds;
    }

    @JacksonXmlProperty(localName="application-name")
    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @JacksonXmlProperty(localName="tier-name")
    @Generated
    public void setTierName(String tierName) {
        this.tierName = tierName;
    }

    @JacksonXmlProperty(localName="node-name")
    @Generated
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @JacksonXmlProperty(localName="agent-runtime-dir")
    @Generated
    public void setAgentRuntimeDir(String agentRuntimeDir) {
        this.agentRuntimeDir = agentRuntimeDir;
    }

    @JacksonXmlProperty(localName="controller-keystore-filename")
    @Generated
    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @JacksonXmlProperty(localName="asymmetric-keystore-filename")
    @Generated
    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @JacksonXmlProperty(localName="controller-keystore-password")
    @Generated
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @JacksonXmlProperty(localName="asymmetric-keystore-password")
    @Generated
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @JacksonXmlProperty(localName="asymmetric-key-password")
    @Generated
    public void setKeyStorePrivateKeyPassword(String keyStorePrivateKeyPassword) {
        this.keyStorePrivateKeyPassword = keyStorePrivateKeyPassword;
    }

    @JacksonXmlProperty(localName="asymmetric-key-alias")
    @Generated
    public void setAsymmetricKeyAlias(String asymmetricKeyAlias) {
        this.asymmetricKeyAlias = asymmetricKeyAlias;
    }

    @JacksonXmlProperty(localName="use-ssl-client-auth")
    @Generated
    public void setSslClientAuthenticationEnabled(Boolean sslClientAuthenticationEnabled) {
        this.sslClientAuthenticationEnabled = sslClientAuthenticationEnabled;
    }

    @Generated
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Generated
    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Generated
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Generated
    public void setProxyPasswordFile(String proxyPasswordFile) {
        this.proxyPasswordFile = proxyPasswordFile;
    }

    @Generated
    public void setProxyUsePreemptiveAuth(Boolean proxyUsePreemptiveAuth) {
        this.proxyUsePreemptiveAuth = proxyUsePreemptiveAuth;
    }

    @JacksonXmlProperty(localName="client-gzip-enabled")
    @Generated
    public void setClientGzipEnabled(Boolean clientGzipEnabled) {
        this.clientGzipEnabled = clientGzipEnabled;
    }

    @JacksonXmlProperty(localName="use-encrypted-credentials")
    @Generated
    public void setUseEncryptedCredentials(Boolean useEncryptedCredentials) {
        this.useEncryptedCredentials = useEncryptedCredentials;
    }

    @JacksonXmlProperty(localName="credential-store-filename")
    @Generated
    public void setCredentialStoreFilename(String credentialStoreFilename) {
        this.credentialStoreFilename = credentialStoreFilename;
    }

    @JacksonXmlProperty(localName="credential-store-password")
    @Generated
    public void setObfuscatedCredentialStorePassword(String obfuscatedCredentialStorePassword) {
        this.obfuscatedCredentialStorePassword = obfuscatedCredentialStorePassword;
    }

    @JacksonXmlProperty(localName="credential-store-format")
    @Generated
    public void setCredentialStoreFormat(String credentialStoreFormat) {
        this.credentialStoreFormat = credentialStoreFormat;
    }

    @JacksonXmlProperty(localName="agent-request-initial-retry-period")
    @Generated
    public void setRequestInitialRetryPeriod(Long requestInitialRetryPeriod) {
        this.requestInitialRetryPeriod = requestInitialRetryPeriod;
    }

    @JacksonXmlProperty(localName="agent-request-max-retry-period")
    @Generated
    public void setRequestMaxRetryPeriod(Long requestMaxRetryPeriod) {
        this.requestMaxRetryPeriod = requestMaxRetryPeriod;
    }

    @JacksonXmlProperty(localName="agent-request-max-retries")
    @Generated
    public void setRequestMaxRetries(Integer requestMaxRetries) {
        this.requestMaxRetries = requestMaxRetries;
    }

    @JacksonXmlProperty(localName="extensions-scheduler-core-pool-size")
    @Generated
    public void setExtensionsSchedulerCorePoolSize(Integer extensionsSchedulerCorePoolSize) {
        this.extensionsSchedulerCorePoolSize = extensionsSchedulerCorePoolSize;
    }

    @JacksonXmlProperty(localName="extensions-scheduler-shutdown-timeout")
    @Generated
    public void setExtensionsSchedulerShutdownTimeoutMillis(Long extensionsSchedulerShutdownTimeoutMillis) {
        this.extensionsSchedulerShutdownTimeoutMillis = extensionsSchedulerShutdownTimeoutMillis;
    }

    @JacksonXmlProperty(localName="extensions-directory")
    @Generated
    public void setExtensionsDirectory(String extensionsDirectory) {
        this.extensionsDirectory = extensionsDirectory;
    }

    @JacksonXmlProperty(localName="extensions-update-interval")
    @Generated
    public void setExtensionsUpdateIntervalMillis(Long extensionsUpdateIntervalMillis) {
        this.extensionsUpdateIntervalMillis = extensionsUpdateIntervalMillis;
    }

    @JacksonXmlProperty(localName="extensions-max-start-time")
    @Generated
    public void setExtensionsMaxStartTimeMillis(Long extensionsMaxStartTimeMillis) {
        this.extensionsMaxStartTimeMillis = extensionsMaxStartTimeMillis;
    }

    @JacksonXmlProperty(localName="extensions-max-stop-time")
    @Generated
    public void setExtensionsMaxStopTimeMillis(Long extensionsMaxStopTimeMillis) {
        this.extensionsMaxStopTimeMillis = extensionsMaxStopTimeMillis;
    }

    @JacksonXmlProperty(localName="metric-aggregator-cache-expiration-seconds")
    @Generated
    public void setMetricAggregatorCacheExpirationTimeSeconds(Long metricAggregatorCacheExpirationTimeSeconds) {
        this.metricAggregatorCacheExpirationTimeSeconds = metricAggregatorCacheExpirationTimeSeconds;
    }

    @JacksonXmlProperty(localName="sim-enabled")
    @Generated
    public void setSimUserEnabled(Boolean simUserEnabled) {
        this.simUserEnabled = simUserEnabled;
    }

    @JacksonXmlProperty(localName="sam-config-update-interval-millis")
    @Generated
    public void setSamConfigUpdateIntervalMillis(Long samConfigUpdateIntervalMillis) {
        this.samConfigUpdateIntervalMillis = samConfigUpdateIntervalMillis;
    }

    @JacksonXmlProperty(localName="main-config-update-interval-millis")
    @Generated
    public void setMainConfigUpdateIntervalMillis(Long mainConfigUpdateIntervalMillis) {
        this.mainConfigUpdateIntervalMillis = mainConfigUpdateIntervalMillis;
    }

    @JacksonXmlProperty(localName="main-config-timeout-millis")
    @Generated
    public void setMainConfigTimeoutMillis(Long mainConfigTimeoutMillis) {
        this.mainConfigTimeoutMillis = mainConfigTimeoutMillis;
    }

    @JacksonXmlProperty(localName="sam-state-update-interval-millis")
    @Generated
    public void setSamStateUpdateIntervalMillis(Long samStateUpdateIntervalMillis) {
        this.samStateUpdateIntervalMillis = samStateUpdateIntervalMillis;
    }

    @JacksonXmlProperty(localName="create-node-if-absent")
    @Generated
    public void setCreateNodeIfAbsent(Boolean createNodeIfAbsent) {
        this.createNodeIfAbsent = createNodeIfAbsent;
    }

    @JacksonXmlProperty(localName="sam-event-update-interval-millis")
    @Generated
    public void setSamEventUpdateIntervalMillis(Long samEventUpdateIntervalMillis) {
        this.samEventUpdateIntervalMillis = samEventUpdateIntervalMillis;
    }

    @Deprecated
    @JacksonXmlProperty(localName="dotnet-compatibility-mode")
    @Generated
    public void setDotnetCompatibilityMode(Boolean dotnetCompatibilityMode) {
        this.dotnetCompatibilityMode = dotnetCompatibilityMode;
    }

    @JacksonXmlProperty(localName="compatibility-mode")
    @Generated
    public void setCompatibilityMode(Boolean compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    @JacksonXmlProperty(localName="agent-config-update-interval")
    @Generated
    public void setAgentConfigUpdateIntervalSeconds(Long agentConfigUpdateIntervalSeconds) {
        this.agentConfigUpdateIntervalSeconds = agentConfigUpdateIntervalSeconds;
    }

    @JacksonXmlProperty(localName="agent-config-update-enabled")
    @Generated
    public void setAgentConfigUpdateEnabled(Boolean agentConfigUpdateEnabled) {
        this.agentConfigUpdateEnabled = agentConfigUpdateEnabled;
    }

    @JacksonXmlProperty(localName="docker-enabled")
    @Generated
    public void setDockerEnabled(Boolean dockerEnabled) {
        this.dockerEnabled = dockerEnabled;
    }

    @JacksonXmlProperty(localName="docker-engine-url")
    @Generated
    public void setDockerEngineUrl(String dockerEngineUrl) {
        this.dockerEngineUrl = dockerEngineUrl;
    }

    @JacksonXmlProperty(localName="is-sap-machine")
    @Generated
    public void setSapMachine(String sapMachine) {
        this.sapMachine = sapMachine;
    }

    @JacksonXmlProperty(localName="dynamic-monitoring-enabled")
    @Generated
    public void setDmmUserEnabled(Boolean dmmUserEnabled) {
        this.dmmUserEnabled = dmmUserEnabled;
    }

    @JacksonXmlProperty(localName="containerd-enabled")
    @Generated
    public void setContainerdEnabled(Boolean containerdEnabled) {
        this.containerdEnabled = containerdEnabled;
    }

    @Generated
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @JsonIgnore
    @Generated
    public void setMachineAgentWindowsAdjustCpuStealInCpuUsedPct(Boolean machineAgentWindowsAdjustCpuStealInCpuUsedPct) {
        this.machineAgentWindowsAdjustCpuStealInCpuUsedPct = machineAgentWindowsAdjustCpuStealInCpuUsedPct;
    }

    @Generated
    public void setBindMountOfHostRoot(String bindMountOfHostRoot) {
        this.bindMountOfHostRoot = bindMountOfHostRoot;
    }

    @JsonIgnore
    @Generated
    public void setCollectMemoryMetricsUsingFreeCommandEnabled(Boolean collectMemoryMetricsUsingFreeCommandEnabled) {
        this.collectMemoryMetricsUsingFreeCommandEnabled = collectMemoryMetricsUsingFreeCommandEnabled;
    }

    @JsonIgnore
    @Generated
    public void setCollectMemoryMetricsUsingVmstatCommandEnabled(Boolean collectMemoryMetricsUsingVmstatCommandEnabled) {
        this.collectMemoryMetricsUsingVmstatCommandEnabled = collectMemoryMetricsUsingVmstatCommandEnabled;
    }

    @JacksonXmlProperty(localName="registration-resilience-enabled")
    @Generated
    public void setRegistrationResilienceEnabled(Boolean registrationResilienceEnabled) {
        this.registrationResilienceEnabled = registrationResilienceEnabled;
    }

    @JacksonXmlProperty(localName="container-old-cpu-metric-key-enabled")
    @Generated
    public void setContainerOldCpuMetricKeyEnabled(Boolean containerOldCpuMetricKeyEnabled) {
        this.containerOldCpuMetricKeyEnabled = containerOldCpuMetricKeyEnabled;
    }

    @JacksonXmlProperty(localName="process-metrics-enabled")
    @Generated
    public void setProcessLevelMetricsEnabled(Boolean processLevelMetricsEnabled) {
        this.processLevelMetricsEnabled = processLevelMetricsEnabled;
    }

    @JacksonXmlProperty(localName="dcgm-exporter-service-namespace")
    @Generated
    public void setDcgmExporterServiceNamespace(String dcgmExporterServiceNamespace) {
        this.dcgmExporterServiceNamespace = dcgmExporterServiceNamespace;
    }

    @JacksonXmlProperty(localName="dcgm-exporter-service-name")
    @Generated
    public void setDcgmExporterServiceName(String dcgmExporterServiceName) {
        this.dcgmExporterServiceName = dcgmExporterServiceName;
    }

    @JacksonXmlProperty(localName="dcgm-exporter-service-port")
    @Generated
    public void setDcgmExporterServicePort(Integer dcgmExporterServicePort) {
        this.dcgmExporterServicePort = dcgmExporterServicePort;
    }

    @JacksonXmlProperty(localName="dcgm-exporter-service-host")
    @Generated
    public void setDcgmExporterServiceHost(String dcgmExporterServiceHost) {
        this.dcgmExporterServiceHost = dcgmExporterServiceHost;
    }

    @JacksonXmlProperty(localName="gpu-enabled")
    @Generated
    public void setGpuEnabled(Boolean gpuEnabled) {
        this.gpuEnabled = gpuEnabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultBootstrapConfiguration)) {
            return false;
        }
        DefaultBootstrapConfiguration other = (DefaultBootstrapConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.osLinux != other.osLinux) {
            return false;
        }
        Integer this$controllerPort = this.getControllerPort();
        Integer other$controllerPort = other.getControllerPort();
        if (this$controllerPort == null ? other$controllerPort != null : !((Object)this$controllerPort).equals(other$controllerPort)) {
            return false;
        }
        Boolean this$controllerSslEnabled = this.getControllerSslEnabled();
        Boolean other$controllerSslEnabled = other.getControllerSslEnabled();
        if (this$controllerSslEnabled == null ? other$controllerSslEnabled != null : !((Object)this$controllerSslEnabled).equals(other$controllerSslEnabled)) {
            return false;
        }
        Boolean this$fullSslValidationEnforced = this.getFullSslValidationEnforced();
        Boolean other$fullSslValidationEnforced = other.getFullSslValidationEnforced();
        if (this$fullSslValidationEnforced == null ? other$fullSslValidationEnforced != null : !((Object)this$fullSslValidationEnforced).equals(other$fullSslValidationEnforced)) {
            return false;
        }
        Boolean this$orchestrationEnabled = this.getOrchestrationEnabled();
        Boolean other$orchestrationEnabled = other.getOrchestrationEnabled();
        if (this$orchestrationEnabled == null ? other$orchestrationEnabled != null : !((Object)this$orchestrationEnabled).equals(other$orchestrationEnabled)) {
            return false;
        }
        Boolean this$agentRegistrationForced = this.getAgentRegistrationForced();
        Boolean other$agentRegistrationForced = other.getAgentRegistrationForced();
        if (this$agentRegistrationForced == null ? other$agentRegistrationForced != null : !((Object)this$agentRegistrationForced).equals(other$agentRegistrationForced)) {
            return false;
        }
        Boolean this$useSimpleHostname = this.getUseSimpleHostname();
        Boolean other$useSimpleHostname = other.getUseSimpleHostname();
        if (this$useSimpleHostname == null ? other$useSimpleHostname != null : !((Object)this$useSimpleHostname).equals(other$useSimpleHostname)) {
            return false;
        }
        Long this$registrationPeriodSeconds = this.getRegistrationPeriodSeconds();
        Long other$registrationPeriodSeconds = other.getRegistrationPeriodSeconds();
        if (this$registrationPeriodSeconds == null ? other$registrationPeriodSeconds != null : !((Object)this$registrationPeriodSeconds).equals(other$registrationPeriodSeconds)) {
            return false;
        }
        Boolean this$sslClientAuthenticationEnabled = this.getSslClientAuthenticationEnabled();
        Boolean other$sslClientAuthenticationEnabled = other.getSslClientAuthenticationEnabled();
        if (this$sslClientAuthenticationEnabled == null ? other$sslClientAuthenticationEnabled != null : !((Object)this$sslClientAuthenticationEnabled).equals(other$sslClientAuthenticationEnabled)) {
            return false;
        }
        Integer this$proxyPort = this.getProxyPort();
        Integer other$proxyPort = other.getProxyPort();
        if (this$proxyPort == null ? other$proxyPort != null : !((Object)this$proxyPort).equals(other$proxyPort)) {
            return false;
        }
        Boolean this$proxyUsePreemptiveAuth = this.getProxyUsePreemptiveAuth();
        Boolean other$proxyUsePreemptiveAuth = other.getProxyUsePreemptiveAuth();
        if (this$proxyUsePreemptiveAuth == null ? other$proxyUsePreemptiveAuth != null : !((Object)this$proxyUsePreemptiveAuth).equals(other$proxyUsePreemptiveAuth)) {
            return false;
        }
        Boolean this$clientGzipEnabled = this.getClientGzipEnabled();
        Boolean other$clientGzipEnabled = other.getClientGzipEnabled();
        if (this$clientGzipEnabled == null ? other$clientGzipEnabled != null : !((Object)this$clientGzipEnabled).equals(other$clientGzipEnabled)) {
            return false;
        }
        Boolean this$useEncryptedCredentials = this.getUseEncryptedCredentials();
        Boolean other$useEncryptedCredentials = other.getUseEncryptedCredentials();
        if (this$useEncryptedCredentials == null ? other$useEncryptedCredentials != null : !((Object)this$useEncryptedCredentials).equals(other$useEncryptedCredentials)) {
            return false;
        }
        Long this$requestInitialRetryPeriod = this.getRequestInitialRetryPeriod();
        Long other$requestInitialRetryPeriod = other.getRequestInitialRetryPeriod();
        if (this$requestInitialRetryPeriod == null ? other$requestInitialRetryPeriod != null : !((Object)this$requestInitialRetryPeriod).equals(other$requestInitialRetryPeriod)) {
            return false;
        }
        Long this$requestMaxRetryPeriod = this.getRequestMaxRetryPeriod();
        Long other$requestMaxRetryPeriod = other.getRequestMaxRetryPeriod();
        if (this$requestMaxRetryPeriod == null ? other$requestMaxRetryPeriod != null : !((Object)this$requestMaxRetryPeriod).equals(other$requestMaxRetryPeriod)) {
            return false;
        }
        Integer this$requestMaxRetries = this.getRequestMaxRetries();
        Integer other$requestMaxRetries = other.getRequestMaxRetries();
        if (this$requestMaxRetries == null ? other$requestMaxRetries != null : !((Object)this$requestMaxRetries).equals(other$requestMaxRetries)) {
            return false;
        }
        Integer this$extensionsSchedulerCorePoolSize = this.getExtensionsSchedulerCorePoolSize();
        Integer other$extensionsSchedulerCorePoolSize = other.getExtensionsSchedulerCorePoolSize();
        if (this$extensionsSchedulerCorePoolSize == null ? other$extensionsSchedulerCorePoolSize != null : !((Object)this$extensionsSchedulerCorePoolSize).equals(other$extensionsSchedulerCorePoolSize)) {
            return false;
        }
        Long this$extensionsSchedulerShutdownTimeoutMillis = this.getExtensionsSchedulerShutdownTimeoutMillis();
        Long other$extensionsSchedulerShutdownTimeoutMillis = other.getExtensionsSchedulerShutdownTimeoutMillis();
        if (this$extensionsSchedulerShutdownTimeoutMillis == null ? other$extensionsSchedulerShutdownTimeoutMillis != null : !((Object)this$extensionsSchedulerShutdownTimeoutMillis).equals(other$extensionsSchedulerShutdownTimeoutMillis)) {
            return false;
        }
        Long this$extensionsUpdateIntervalMillis = this.getExtensionsUpdateIntervalMillis();
        Long other$extensionsUpdateIntervalMillis = other.getExtensionsUpdateIntervalMillis();
        if (this$extensionsUpdateIntervalMillis == null ? other$extensionsUpdateIntervalMillis != null : !((Object)this$extensionsUpdateIntervalMillis).equals(other$extensionsUpdateIntervalMillis)) {
            return false;
        }
        Long this$extensionsMaxStartTimeMillis = this.getExtensionsMaxStartTimeMillis();
        Long other$extensionsMaxStartTimeMillis = other.getExtensionsMaxStartTimeMillis();
        if (this$extensionsMaxStartTimeMillis == null ? other$extensionsMaxStartTimeMillis != null : !((Object)this$extensionsMaxStartTimeMillis).equals(other$extensionsMaxStartTimeMillis)) {
            return false;
        }
        Long this$extensionsMaxStopTimeMillis = this.getExtensionsMaxStopTimeMillis();
        Long other$extensionsMaxStopTimeMillis = other.getExtensionsMaxStopTimeMillis();
        if (this$extensionsMaxStopTimeMillis == null ? other$extensionsMaxStopTimeMillis != null : !((Object)this$extensionsMaxStopTimeMillis).equals(other$extensionsMaxStopTimeMillis)) {
            return false;
        }
        Long this$metricAggregatorCacheExpirationTimeSeconds = this.getMetricAggregatorCacheExpirationTimeSeconds();
        Long other$metricAggregatorCacheExpirationTimeSeconds = other.getMetricAggregatorCacheExpirationTimeSeconds();
        if (this$metricAggregatorCacheExpirationTimeSeconds == null ? other$metricAggregatorCacheExpirationTimeSeconds != null : !((Object)this$metricAggregatorCacheExpirationTimeSeconds).equals(other$metricAggregatorCacheExpirationTimeSeconds)) {
            return false;
        }
        Boolean this$simUserEnabled = this.getSimUserEnabled();
        Boolean other$simUserEnabled = other.getSimUserEnabled();
        if (this$simUserEnabled == null ? other$simUserEnabled != null : !((Object)this$simUserEnabled).equals(other$simUserEnabled)) {
            return false;
        }
        Long this$samConfigUpdateIntervalMillis = this.getSamConfigUpdateIntervalMillis();
        Long other$samConfigUpdateIntervalMillis = other.getSamConfigUpdateIntervalMillis();
        if (this$samConfigUpdateIntervalMillis == null ? other$samConfigUpdateIntervalMillis != null : !((Object)this$samConfigUpdateIntervalMillis).equals(other$samConfigUpdateIntervalMillis)) {
            return false;
        }
        Long this$mainConfigUpdateIntervalMillis = this.getMainConfigUpdateIntervalMillis();
        Long other$mainConfigUpdateIntervalMillis = other.getMainConfigUpdateIntervalMillis();
        if (this$mainConfigUpdateIntervalMillis == null ? other$mainConfigUpdateIntervalMillis != null : !((Object)this$mainConfigUpdateIntervalMillis).equals(other$mainConfigUpdateIntervalMillis)) {
            return false;
        }
        Long this$mainConfigTimeoutMillis = this.getMainConfigTimeoutMillis();
        Long other$mainConfigTimeoutMillis = other.getMainConfigTimeoutMillis();
        if (this$mainConfigTimeoutMillis == null ? other$mainConfigTimeoutMillis != null : !((Object)this$mainConfigTimeoutMillis).equals(other$mainConfigTimeoutMillis)) {
            return false;
        }
        Long this$samStateUpdateIntervalMillis = this.getSamStateUpdateIntervalMillis();
        Long other$samStateUpdateIntervalMillis = other.getSamStateUpdateIntervalMillis();
        if (this$samStateUpdateIntervalMillis == null ? other$samStateUpdateIntervalMillis != null : !((Object)this$samStateUpdateIntervalMillis).equals(other$samStateUpdateIntervalMillis)) {
            return false;
        }
        Boolean this$createNodeIfAbsent = this.getCreateNodeIfAbsent();
        Boolean other$createNodeIfAbsent = other.getCreateNodeIfAbsent();
        if (this$createNodeIfAbsent == null ? other$createNodeIfAbsent != null : !((Object)this$createNodeIfAbsent).equals(other$createNodeIfAbsent)) {
            return false;
        }
        Long this$samEventUpdateIntervalMillis = this.getSamEventUpdateIntervalMillis();
        Long other$samEventUpdateIntervalMillis = other.getSamEventUpdateIntervalMillis();
        if (this$samEventUpdateIntervalMillis == null ? other$samEventUpdateIntervalMillis != null : !((Object)this$samEventUpdateIntervalMillis).equals(other$samEventUpdateIntervalMillis)) {
            return false;
        }
        Boolean this$dotnetCompatibilityMode = this.getDotnetCompatibilityMode();
        Boolean other$dotnetCompatibilityMode = other.getDotnetCompatibilityMode();
        if (this$dotnetCompatibilityMode == null ? other$dotnetCompatibilityMode != null : !((Object)this$dotnetCompatibilityMode).equals(other$dotnetCompatibilityMode)) {
            return false;
        }
        Boolean this$compatibilityMode = this.getCompatibilityMode();
        Boolean other$compatibilityMode = other.getCompatibilityMode();
        if (this$compatibilityMode == null ? other$compatibilityMode != null : !((Object)this$compatibilityMode).equals(other$compatibilityMode)) {
            return false;
        }
        Long this$agentConfigUpdateIntervalSeconds = this.getAgentConfigUpdateIntervalSeconds();
        Long other$agentConfigUpdateIntervalSeconds = other.getAgentConfigUpdateIntervalSeconds();
        if (this$agentConfigUpdateIntervalSeconds == null ? other$agentConfigUpdateIntervalSeconds != null : !((Object)this$agentConfigUpdateIntervalSeconds).equals(other$agentConfigUpdateIntervalSeconds)) {
            return false;
        }
        Boolean this$agentConfigUpdateEnabled = this.getAgentConfigUpdateEnabled();
        Boolean other$agentConfigUpdateEnabled = other.getAgentConfigUpdateEnabled();
        if (this$agentConfigUpdateEnabled == null ? other$agentConfigUpdateEnabled != null : !((Object)this$agentConfigUpdateEnabled).equals(other$agentConfigUpdateEnabled)) {
            return false;
        }
        Boolean this$dockerEnabled = this.getDockerEnabled();
        Boolean other$dockerEnabled = other.getDockerEnabled();
        if (this$dockerEnabled == null ? other$dockerEnabled != null : !((Object)this$dockerEnabled).equals(other$dockerEnabled)) {
            return false;
        }
        Boolean this$dmmUserEnabled = this.getDmmUserEnabled();
        Boolean other$dmmUserEnabled = other.getDmmUserEnabled();
        if (this$dmmUserEnabled == null ? other$dmmUserEnabled != null : !((Object)this$dmmUserEnabled).equals(other$dmmUserEnabled)) {
            return false;
        }
        Boolean this$containerdEnabled = this.getContainerdEnabled();
        Boolean other$containerdEnabled = other.getContainerdEnabled();
        if (this$containerdEnabled == null ? other$containerdEnabled != null : !((Object)this$containerdEnabled).equals(other$containerdEnabled)) {
            return false;
        }
        Boolean this$machineAgentWindowsAdjustCpuStealInCpuUsedPct = this.getMachineAgentWindowsAdjustCpuStealInCpuUsedPct();
        Boolean other$machineAgentWindowsAdjustCpuStealInCpuUsedPct = other.getMachineAgentWindowsAdjustCpuStealInCpuUsedPct();
        if (this$machineAgentWindowsAdjustCpuStealInCpuUsedPct == null ? other$machineAgentWindowsAdjustCpuStealInCpuUsedPct != null : !((Object)this$machineAgentWindowsAdjustCpuStealInCpuUsedPct).equals(other$machineAgentWindowsAdjustCpuStealInCpuUsedPct)) {
            return false;
        }
        Boolean this$collectMemoryMetricsUsingFreeCommandEnabled = this.getCollectMemoryMetricsUsingFreeCommandEnabled();
        Boolean other$collectMemoryMetricsUsingFreeCommandEnabled = other.getCollectMemoryMetricsUsingFreeCommandEnabled();
        if (this$collectMemoryMetricsUsingFreeCommandEnabled == null ? other$collectMemoryMetricsUsingFreeCommandEnabled != null : !((Object)this$collectMemoryMetricsUsingFreeCommandEnabled).equals(other$collectMemoryMetricsUsingFreeCommandEnabled)) {
            return false;
        }
        Boolean this$collectMemoryMetricsUsingVmstatCommandEnabled = this.getCollectMemoryMetricsUsingVmstatCommandEnabled();
        Boolean other$collectMemoryMetricsUsingVmstatCommandEnabled = other.getCollectMemoryMetricsUsingVmstatCommandEnabled();
        if (this$collectMemoryMetricsUsingVmstatCommandEnabled == null ? other$collectMemoryMetricsUsingVmstatCommandEnabled != null : !((Object)this$collectMemoryMetricsUsingVmstatCommandEnabled).equals(other$collectMemoryMetricsUsingVmstatCommandEnabled)) {
            return false;
        }
        Boolean this$registrationResilienceEnabled = this.getRegistrationResilienceEnabled();
        Boolean other$registrationResilienceEnabled = other.getRegistrationResilienceEnabled();
        if (this$registrationResilienceEnabled == null ? other$registrationResilienceEnabled != null : !((Object)this$registrationResilienceEnabled).equals(other$registrationResilienceEnabled)) {
            return false;
        }
        Boolean this$containerOldCpuMetricKeyEnabled = this.getContainerOldCpuMetricKeyEnabled();
        Boolean other$containerOldCpuMetricKeyEnabled = other.getContainerOldCpuMetricKeyEnabled();
        if (this$containerOldCpuMetricKeyEnabled == null ? other$containerOldCpuMetricKeyEnabled != null : !((Object)this$containerOldCpuMetricKeyEnabled).equals(other$containerOldCpuMetricKeyEnabled)) {
            return false;
        }
        Boolean this$processLevelMetricsEnabled = this.getProcessLevelMetricsEnabled();
        Boolean other$processLevelMetricsEnabled = other.getProcessLevelMetricsEnabled();
        if (this$processLevelMetricsEnabled == null ? other$processLevelMetricsEnabled != null : !((Object)this$processLevelMetricsEnabled).equals(other$processLevelMetricsEnabled)) {
            return false;
        }
        Integer this$dcgmExporterServicePort = this.getDcgmExporterServicePort();
        Integer other$dcgmExporterServicePort = other.getDcgmExporterServicePort();
        if (this$dcgmExporterServicePort == null ? other$dcgmExporterServicePort != null : !((Object)this$dcgmExporterServicePort).equals(other$dcgmExporterServicePort)) {
            return false;
        }
        Boolean this$gpuEnabled = this.getGpuEnabled();
        Boolean other$gpuEnabled = other.getGpuEnabled();
        if (this$gpuEnabled == null ? other$gpuEnabled != null : !((Object)this$gpuEnabled).equals(other$gpuEnabled)) {
            return false;
        }
        String this$controllerHost = this.getControllerHost();
        String other$controllerHost = other.getControllerHost();
        if (this$controllerHost == null ? other$controllerHost != null : !this$controllerHost.equals(other$controllerHost)) {
            return false;
        }
        String this$sslProtocol = this.getSslProtocol();
        String other$sslProtocol = other.getSslProtocol();
        if (this$sslProtocol == null ? other$sslProtocol != null : !this$sslProtocol.equals(other$sslProtocol)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        String this$accountAccessKey = this.getAccountAccessKey();
        String other$accountAccessKey = other.getAccountAccessKey();
        if (this$accountAccessKey == null ? other$accountAccessKey != null : !this$accountAccessKey.equals(other$accountAccessKey)) {
            return false;
        }
        String this$machinePath = this.getMachinePath();
        String other$machinePath = other.getMachinePath();
        if (this$machinePath == null ? other$machinePath != null : !this$machinePath.equals(other$machinePath)) {
            return false;
        }
        String this$hostId = this.getHostId();
        String other$hostId = other.getHostId();
        if (this$hostId == null ? other$hostId != null : !this$hostId.equals(other$hostId)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$tierName = this.getTierName();
        String other$tierName = other.getTierName();
        if (this$tierName == null ? other$tierName != null : !this$tierName.equals(other$tierName)) {
            return false;
        }
        String this$nodeName = this.getNodeName();
        String other$nodeName = other.getNodeName();
        if (this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName)) {
            return false;
        }
        String this$agentRuntimeDir = this.getAgentRuntimeDir();
        String other$agentRuntimeDir = other.getAgentRuntimeDir();
        if (this$agentRuntimeDir == null ? other$agentRuntimeDir != null : !this$agentRuntimeDir.equals(other$agentRuntimeDir)) {
            return false;
        }
        String this$trustStorePath = this.getTrustStorePath();
        String other$trustStorePath = other.getTrustStorePath();
        if (this$trustStorePath == null ? other$trustStorePath != null : !this$trustStorePath.equals(other$trustStorePath)) {
            return false;
        }
        String this$keyStorePath = this.getKeyStorePath();
        String other$keyStorePath = other.getKeyStorePath();
        if (this$keyStorePath == null ? other$keyStorePath != null : !this$keyStorePath.equals(other$keyStorePath)) {
            return false;
        }
        String this$trustStorePassword = this.getTrustStorePassword();
        String other$trustStorePassword = other.getTrustStorePassword();
        if (this$trustStorePassword == null ? other$trustStorePassword != null : !this$trustStorePassword.equals(other$trustStorePassword)) {
            return false;
        }
        String this$keyStorePassword = this.getKeyStorePassword();
        String other$keyStorePassword = other.getKeyStorePassword();
        if (this$keyStorePassword == null ? other$keyStorePassword != null : !this$keyStorePassword.equals(other$keyStorePassword)) {
            return false;
        }
        String this$keyStorePrivateKeyPassword = this.getKeyStorePrivateKeyPassword();
        String other$keyStorePrivateKeyPassword = other.getKeyStorePrivateKeyPassword();
        if (this$keyStorePrivateKeyPassword == null ? other$keyStorePrivateKeyPassword != null : !this$keyStorePrivateKeyPassword.equals(other$keyStorePrivateKeyPassword)) {
            return false;
        }
        String this$asymmetricKeyAlias = this.getAsymmetricKeyAlias();
        String other$asymmetricKeyAlias = other.getAsymmetricKeyAlias();
        if (this$asymmetricKeyAlias == null ? other$asymmetricKeyAlias != null : !this$asymmetricKeyAlias.equals(other$asymmetricKeyAlias)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
            return false;
        }
        String this$proxyUsername = this.getProxyUsername();
        String other$proxyUsername = other.getProxyUsername();
        if (this$proxyUsername == null ? other$proxyUsername != null : !this$proxyUsername.equals(other$proxyUsername)) {
            return false;
        }
        String this$proxyPasswordFile = this.getProxyPasswordFile();
        String other$proxyPasswordFile = other.getProxyPasswordFile();
        if (this$proxyPasswordFile == null ? other$proxyPasswordFile != null : !this$proxyPasswordFile.equals(other$proxyPasswordFile)) {
            return false;
        }
        String this$credentialStoreFilename = this.getCredentialStoreFilename();
        String other$credentialStoreFilename = other.getCredentialStoreFilename();
        if (this$credentialStoreFilename == null ? other$credentialStoreFilename != null : !this$credentialStoreFilename.equals(other$credentialStoreFilename)) {
            return false;
        }
        String this$obfuscatedCredentialStorePassword = this.getObfuscatedCredentialStorePassword();
        String other$obfuscatedCredentialStorePassword = other.getObfuscatedCredentialStorePassword();
        if (this$obfuscatedCredentialStorePassword == null ? other$obfuscatedCredentialStorePassword != null : !this$obfuscatedCredentialStorePassword.equals(other$obfuscatedCredentialStorePassword)) {
            return false;
        }
        String this$credentialStoreFormat = this.getCredentialStoreFormat();
        String other$credentialStoreFormat = other.getCredentialStoreFormat();
        if (this$credentialStoreFormat == null ? other$credentialStoreFormat != null : !this$credentialStoreFormat.equals(other$credentialStoreFormat)) {
            return false;
        }
        String this$extensionsDirectory = this.getExtensionsDirectory();
        String other$extensionsDirectory = other.getExtensionsDirectory();
        if (this$extensionsDirectory == null ? other$extensionsDirectory != null : !this$extensionsDirectory.equals(other$extensionsDirectory)) {
            return false;
        }
        String this$dockerEngineUrl = this.getDockerEngineUrl();
        String other$dockerEngineUrl = other.getDockerEngineUrl();
        if (this$dockerEngineUrl == null ? other$dockerEngineUrl != null : !this$dockerEngineUrl.equals(other$dockerEngineUrl)) {
            return false;
        }
        Boolean this$sapMachine = this.getSapMachine();
        Boolean other$sapMachine = other.getSapMachine();
        if (this$sapMachine == null ? other$sapMachine != null : !((Object)this$sapMachine).equals(other$sapMachine)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$bindMountOfHostRoot = this.getBindMountOfHostRoot();
        String other$bindMountOfHostRoot = other.getBindMountOfHostRoot();
        if (this$bindMountOfHostRoot == null ? other$bindMountOfHostRoot != null : !this$bindMountOfHostRoot.equals(other$bindMountOfHostRoot)) {
            return false;
        }
        String this$machineName = this.getMachineName();
        String other$machineName = other.getMachineName();
        if (this$machineName == null ? other$machineName != null : !this$machineName.equals(other$machineName)) {
            return false;
        }
        List<String> this$machineHierarchy = this.getMachineHierarchy();
        List<String> other$machineHierarchy = other.getMachineHierarchy();
        if (this$machineHierarchy == null ? other$machineHierarchy != null : !((Object)this$machineHierarchy).equals(other$machineHierarchy)) {
            return false;
        }
        String this$dcgmExporterServiceNamespace = this.getDcgmExporterServiceNamespace();
        String other$dcgmExporterServiceNamespace = other.getDcgmExporterServiceNamespace();
        if (this$dcgmExporterServiceNamespace == null ? other$dcgmExporterServiceNamespace != null : !this$dcgmExporterServiceNamespace.equals(other$dcgmExporterServiceNamespace)) {
            return false;
        }
        String this$dcgmExporterServiceName = this.getDcgmExporterServiceName();
        String other$dcgmExporterServiceName = other.getDcgmExporterServiceName();
        if (this$dcgmExporterServiceName == null ? other$dcgmExporterServiceName != null : !this$dcgmExporterServiceName.equals(other$dcgmExporterServiceName)) {
            return false;
        }
        String this$dcgmExporterServiceHost = this.getDcgmExporterServiceHost();
        String other$dcgmExporterServiceHost = other.getDcgmExporterServiceHost();
        return !(this$dcgmExporterServiceHost == null ? other$dcgmExporterServiceHost != null : !this$dcgmExporterServiceHost.equals(other$dcgmExporterServiceHost));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultBootstrapConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.osLinux ? 79 : 97);
        Integer $controllerPort = this.getControllerPort();
        result = result * 59 + ($controllerPort == null ? 43 : ((Object)$controllerPort).hashCode());
        Boolean $controllerSslEnabled = this.getControllerSslEnabled();
        result = result * 59 + ($controllerSslEnabled == null ? 43 : ((Object)$controllerSslEnabled).hashCode());
        Boolean $fullSslValidationEnforced = this.getFullSslValidationEnforced();
        result = result * 59 + ($fullSslValidationEnforced == null ? 43 : ((Object)$fullSslValidationEnforced).hashCode());
        Boolean $orchestrationEnabled = this.getOrchestrationEnabled();
        result = result * 59 + ($orchestrationEnabled == null ? 43 : ((Object)$orchestrationEnabled).hashCode());
        Boolean $agentRegistrationForced = this.getAgentRegistrationForced();
        result = result * 59 + ($agentRegistrationForced == null ? 43 : ((Object)$agentRegistrationForced).hashCode());
        Boolean $useSimpleHostname = this.getUseSimpleHostname();
        result = result * 59 + ($useSimpleHostname == null ? 43 : ((Object)$useSimpleHostname).hashCode());
        Long $registrationPeriodSeconds = this.getRegistrationPeriodSeconds();
        result = result * 59 + ($registrationPeriodSeconds == null ? 43 : ((Object)$registrationPeriodSeconds).hashCode());
        Boolean $sslClientAuthenticationEnabled = this.getSslClientAuthenticationEnabled();
        result = result * 59 + ($sslClientAuthenticationEnabled == null ? 43 : ((Object)$sslClientAuthenticationEnabled).hashCode());
        Integer $proxyPort = this.getProxyPort();
        result = result * 59 + ($proxyPort == null ? 43 : ((Object)$proxyPort).hashCode());
        Boolean $proxyUsePreemptiveAuth = this.getProxyUsePreemptiveAuth();
        result = result * 59 + ($proxyUsePreemptiveAuth == null ? 43 : ((Object)$proxyUsePreemptiveAuth).hashCode());
        Boolean $clientGzipEnabled = this.getClientGzipEnabled();
        result = result * 59 + ($clientGzipEnabled == null ? 43 : ((Object)$clientGzipEnabled).hashCode());
        Boolean $useEncryptedCredentials = this.getUseEncryptedCredentials();
        result = result * 59 + ($useEncryptedCredentials == null ? 43 : ((Object)$useEncryptedCredentials).hashCode());
        Long $requestInitialRetryPeriod = this.getRequestInitialRetryPeriod();
        result = result * 59 + ($requestInitialRetryPeriod == null ? 43 : ((Object)$requestInitialRetryPeriod).hashCode());
        Long $requestMaxRetryPeriod = this.getRequestMaxRetryPeriod();
        result = result * 59 + ($requestMaxRetryPeriod == null ? 43 : ((Object)$requestMaxRetryPeriod).hashCode());
        Integer $requestMaxRetries = this.getRequestMaxRetries();
        result = result * 59 + ($requestMaxRetries == null ? 43 : ((Object)$requestMaxRetries).hashCode());
        Integer $extensionsSchedulerCorePoolSize = this.getExtensionsSchedulerCorePoolSize();
        result = result * 59 + ($extensionsSchedulerCorePoolSize == null ? 43 : ((Object)$extensionsSchedulerCorePoolSize).hashCode());
        Long $extensionsSchedulerShutdownTimeoutMillis = this.getExtensionsSchedulerShutdownTimeoutMillis();
        result = result * 59 + ($extensionsSchedulerShutdownTimeoutMillis == null ? 43 : ((Object)$extensionsSchedulerShutdownTimeoutMillis).hashCode());
        Long $extensionsUpdateIntervalMillis = this.getExtensionsUpdateIntervalMillis();
        result = result * 59 + ($extensionsUpdateIntervalMillis == null ? 43 : ((Object)$extensionsUpdateIntervalMillis).hashCode());
        Long $extensionsMaxStartTimeMillis = this.getExtensionsMaxStartTimeMillis();
        result = result * 59 + ($extensionsMaxStartTimeMillis == null ? 43 : ((Object)$extensionsMaxStartTimeMillis).hashCode());
        Long $extensionsMaxStopTimeMillis = this.getExtensionsMaxStopTimeMillis();
        result = result * 59 + ($extensionsMaxStopTimeMillis == null ? 43 : ((Object)$extensionsMaxStopTimeMillis).hashCode());
        Long $metricAggregatorCacheExpirationTimeSeconds = this.getMetricAggregatorCacheExpirationTimeSeconds();
        result = result * 59 + ($metricAggregatorCacheExpirationTimeSeconds == null ? 43 : ((Object)$metricAggregatorCacheExpirationTimeSeconds).hashCode());
        Boolean $simUserEnabled = this.getSimUserEnabled();
        result = result * 59 + ($simUserEnabled == null ? 43 : ((Object)$simUserEnabled).hashCode());
        Long $samConfigUpdateIntervalMillis = this.getSamConfigUpdateIntervalMillis();
        result = result * 59 + ($samConfigUpdateIntervalMillis == null ? 43 : ((Object)$samConfigUpdateIntervalMillis).hashCode());
        Long $mainConfigUpdateIntervalMillis = this.getMainConfigUpdateIntervalMillis();
        result = result * 59 + ($mainConfigUpdateIntervalMillis == null ? 43 : ((Object)$mainConfigUpdateIntervalMillis).hashCode());
        Long $mainConfigTimeoutMillis = this.getMainConfigTimeoutMillis();
        result = result * 59 + ($mainConfigTimeoutMillis == null ? 43 : ((Object)$mainConfigTimeoutMillis).hashCode());
        Long $samStateUpdateIntervalMillis = this.getSamStateUpdateIntervalMillis();
        result = result * 59 + ($samStateUpdateIntervalMillis == null ? 43 : ((Object)$samStateUpdateIntervalMillis).hashCode());
        Boolean $createNodeIfAbsent = this.getCreateNodeIfAbsent();
        result = result * 59 + ($createNodeIfAbsent == null ? 43 : ((Object)$createNodeIfAbsent).hashCode());
        Long $samEventUpdateIntervalMillis = this.getSamEventUpdateIntervalMillis();
        result = result * 59 + ($samEventUpdateIntervalMillis == null ? 43 : ((Object)$samEventUpdateIntervalMillis).hashCode());
        Boolean $dotnetCompatibilityMode = this.getDotnetCompatibilityMode();
        result = result * 59 + ($dotnetCompatibilityMode == null ? 43 : ((Object)$dotnetCompatibilityMode).hashCode());
        Boolean $compatibilityMode = this.getCompatibilityMode();
        result = result * 59 + ($compatibilityMode == null ? 43 : ((Object)$compatibilityMode).hashCode());
        Long $agentConfigUpdateIntervalSeconds = this.getAgentConfigUpdateIntervalSeconds();
        result = result * 59 + ($agentConfigUpdateIntervalSeconds == null ? 43 : ((Object)$agentConfigUpdateIntervalSeconds).hashCode());
        Boolean $agentConfigUpdateEnabled = this.getAgentConfigUpdateEnabled();
        result = result * 59 + ($agentConfigUpdateEnabled == null ? 43 : ((Object)$agentConfigUpdateEnabled).hashCode());
        Boolean $dockerEnabled = this.getDockerEnabled();
        result = result * 59 + ($dockerEnabled == null ? 43 : ((Object)$dockerEnabled).hashCode());
        Boolean $dmmUserEnabled = this.getDmmUserEnabled();
        result = result * 59 + ($dmmUserEnabled == null ? 43 : ((Object)$dmmUserEnabled).hashCode());
        Boolean $containerdEnabled = this.getContainerdEnabled();
        result = result * 59 + ($containerdEnabled == null ? 43 : ((Object)$containerdEnabled).hashCode());
        Boolean $machineAgentWindowsAdjustCpuStealInCpuUsedPct = this.getMachineAgentWindowsAdjustCpuStealInCpuUsedPct();
        result = result * 59 + ($machineAgentWindowsAdjustCpuStealInCpuUsedPct == null ? 43 : ((Object)$machineAgentWindowsAdjustCpuStealInCpuUsedPct).hashCode());
        Boolean $collectMemoryMetricsUsingFreeCommandEnabled = this.getCollectMemoryMetricsUsingFreeCommandEnabled();
        result = result * 59 + ($collectMemoryMetricsUsingFreeCommandEnabled == null ? 43 : ((Object)$collectMemoryMetricsUsingFreeCommandEnabled).hashCode());
        Boolean $collectMemoryMetricsUsingVmstatCommandEnabled = this.getCollectMemoryMetricsUsingVmstatCommandEnabled();
        result = result * 59 + ($collectMemoryMetricsUsingVmstatCommandEnabled == null ? 43 : ((Object)$collectMemoryMetricsUsingVmstatCommandEnabled).hashCode());
        Boolean $registrationResilienceEnabled = this.getRegistrationResilienceEnabled();
        result = result * 59 + ($registrationResilienceEnabled == null ? 43 : ((Object)$registrationResilienceEnabled).hashCode());
        Boolean $containerOldCpuMetricKeyEnabled = this.getContainerOldCpuMetricKeyEnabled();
        result = result * 59 + ($containerOldCpuMetricKeyEnabled == null ? 43 : ((Object)$containerOldCpuMetricKeyEnabled).hashCode());
        Boolean $processLevelMetricsEnabled = this.getProcessLevelMetricsEnabled();
        result = result * 59 + ($processLevelMetricsEnabled == null ? 43 : ((Object)$processLevelMetricsEnabled).hashCode());
        Integer $dcgmExporterServicePort = this.getDcgmExporterServicePort();
        result = result * 59 + ($dcgmExporterServicePort == null ? 43 : ((Object)$dcgmExporterServicePort).hashCode());
        Boolean $gpuEnabled = this.getGpuEnabled();
        result = result * 59 + ($gpuEnabled == null ? 43 : ((Object)$gpuEnabled).hashCode());
        String $controllerHost = this.getControllerHost();
        result = result * 59 + ($controllerHost == null ? 43 : $controllerHost.hashCode());
        String $sslProtocol = this.getSslProtocol();
        result = result * 59 + ($sslProtocol == null ? 43 : $sslProtocol.hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        String $accountAccessKey = this.getAccountAccessKey();
        result = result * 59 + ($accountAccessKey == null ? 43 : $accountAccessKey.hashCode());
        String $machinePath = this.getMachinePath();
        result = result * 59 + ($machinePath == null ? 43 : $machinePath.hashCode());
        String $hostId = this.getHostId();
        result = result * 59 + ($hostId == null ? 43 : $hostId.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $tierName = this.getTierName();
        result = result * 59 + ($tierName == null ? 43 : $tierName.hashCode());
        String $nodeName = this.getNodeName();
        result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
        String $agentRuntimeDir = this.getAgentRuntimeDir();
        result = result * 59 + ($agentRuntimeDir == null ? 43 : $agentRuntimeDir.hashCode());
        String $trustStorePath = this.getTrustStorePath();
        result = result * 59 + ($trustStorePath == null ? 43 : $trustStorePath.hashCode());
        String $keyStorePath = this.getKeyStorePath();
        result = result * 59 + ($keyStorePath == null ? 43 : $keyStorePath.hashCode());
        String $trustStorePassword = this.getTrustStorePassword();
        result = result * 59 + ($trustStorePassword == null ? 43 : $trustStorePassword.hashCode());
        String $keyStorePassword = this.getKeyStorePassword();
        result = result * 59 + ($keyStorePassword == null ? 43 : $keyStorePassword.hashCode());
        String $keyStorePrivateKeyPassword = this.getKeyStorePrivateKeyPassword();
        result = result * 59 + ($keyStorePrivateKeyPassword == null ? 43 : $keyStorePrivateKeyPassword.hashCode());
        String $asymmetricKeyAlias = this.getAsymmetricKeyAlias();
        result = result * 59 + ($asymmetricKeyAlias == null ? 43 : $asymmetricKeyAlias.hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
        String $proxyUsername = this.getProxyUsername();
        result = result * 59 + ($proxyUsername == null ? 43 : $proxyUsername.hashCode());
        String $proxyPasswordFile = this.getProxyPasswordFile();
        result = result * 59 + ($proxyPasswordFile == null ? 43 : $proxyPasswordFile.hashCode());
        String $credentialStoreFilename = this.getCredentialStoreFilename();
        result = result * 59 + ($credentialStoreFilename == null ? 43 : $credentialStoreFilename.hashCode());
        String $obfuscatedCredentialStorePassword = this.getObfuscatedCredentialStorePassword();
        result = result * 59 + ($obfuscatedCredentialStorePassword == null ? 43 : $obfuscatedCredentialStorePassword.hashCode());
        String $credentialStoreFormat = this.getCredentialStoreFormat();
        result = result * 59 + ($credentialStoreFormat == null ? 43 : $credentialStoreFormat.hashCode());
        String $extensionsDirectory = this.getExtensionsDirectory();
        result = result * 59 + ($extensionsDirectory == null ? 43 : $extensionsDirectory.hashCode());
        String $dockerEngineUrl = this.getDockerEngineUrl();
        result = result * 59 + ($dockerEngineUrl == null ? 43 : $dockerEngineUrl.hashCode());
        Boolean $sapMachine = this.getSapMachine();
        result = result * 59 + ($sapMachine == null ? 43 : ((Object)$sapMachine).hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $bindMountOfHostRoot = this.getBindMountOfHostRoot();
        result = result * 59 + ($bindMountOfHostRoot == null ? 43 : $bindMountOfHostRoot.hashCode());
        String $machineName = this.getMachineName();
        result = result * 59 + ($machineName == null ? 43 : $machineName.hashCode());
        List<String> $machineHierarchy = this.getMachineHierarchy();
        result = result * 59 + ($machineHierarchy == null ? 43 : ((Object)$machineHierarchy).hashCode());
        String $dcgmExporterServiceNamespace = this.getDcgmExporterServiceNamespace();
        result = result * 59 + ($dcgmExporterServiceNamespace == null ? 43 : $dcgmExporterServiceNamespace.hashCode());
        String $dcgmExporterServiceName = this.getDcgmExporterServiceName();
        result = result * 59 + ($dcgmExporterServiceName == null ? 43 : $dcgmExporterServiceName.hashCode());
        String $dcgmExporterServiceHost = this.getDcgmExporterServiceHost();
        result = result * 59 + ($dcgmExporterServiceHost == null ? 43 : $dcgmExporterServiceHost.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultBootstrapConfiguration(controllerHost=" + this.getControllerHost() + ", controllerPort=" + this.getControllerPort() + ", controllerSslEnabled=" + this.getControllerSslEnabled() + ", fullSslValidationEnforced=" + this.getFullSslValidationEnforced() + ", sslProtocol=" + this.getSslProtocol() + ", orchestrationEnabled=" + this.getOrchestrationEnabled() + ", agentRegistrationForced=" + this.getAgentRegistrationForced() + ", accountName=" + this.getAccountName() + ", accountAccessKey=" + this.getAccountAccessKey() + ", machinePath=" + this.getMachinePath() + ", hostId=" + this.getHostId() + ", useSimpleHostname=" + this.getUseSimpleHostname() + ", registrationPeriodSeconds=" + this.getRegistrationPeriodSeconds() + ", applicationName=" + this.getApplicationName() + ", tierName=" + this.getTierName() + ", nodeName=" + this.getNodeName() + ", agentRuntimeDir=" + this.getAgentRuntimeDir() + ", trustStorePath=" + this.getTrustStorePath() + ", keyStorePath=" + this.getKeyStorePath() + ", trustStorePassword=" + this.getTrustStorePassword() + ", keyStorePassword=" + this.getKeyStorePassword() + ", keyStorePrivateKeyPassword=" + this.getKeyStorePrivateKeyPassword() + ", asymmetricKeyAlias=" + this.getAsymmetricKeyAlias() + ", sslClientAuthenticationEnabled=" + this.getSslClientAuthenticationEnabled() + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", proxyUsername=" + this.getProxyUsername() + ", proxyPasswordFile=" + this.getProxyPasswordFile() + ", proxyUsePreemptiveAuth=" + this.getProxyUsePreemptiveAuth() + ", clientGzipEnabled=" + this.getClientGzipEnabled() + ", useEncryptedCredentials=" + this.getUseEncryptedCredentials() + ", credentialStoreFilename=" + this.getCredentialStoreFilename() + ", obfuscatedCredentialStorePassword=" + this.getObfuscatedCredentialStorePassword() + ", credentialStoreFormat=" + this.getCredentialStoreFormat() + ", requestInitialRetryPeriod=" + this.getRequestInitialRetryPeriod() + ", requestMaxRetryPeriod=" + this.getRequestMaxRetryPeriod() + ", requestMaxRetries=" + this.getRequestMaxRetries() + ", extensionsSchedulerCorePoolSize=" + this.getExtensionsSchedulerCorePoolSize() + ", extensionsSchedulerShutdownTimeoutMillis=" + this.getExtensionsSchedulerShutdownTimeoutMillis() + ", extensionsDirectory=" + this.getExtensionsDirectory() + ", extensionsUpdateIntervalMillis=" + this.getExtensionsUpdateIntervalMillis() + ", extensionsMaxStartTimeMillis=" + this.getExtensionsMaxStartTimeMillis() + ", extensionsMaxStopTimeMillis=" + this.getExtensionsMaxStopTimeMillis() + ", metricAggregatorCacheExpirationTimeSeconds=" + this.getMetricAggregatorCacheExpirationTimeSeconds() + ", simUserEnabled=" + this.getSimUserEnabled() + ", samConfigUpdateIntervalMillis=" + this.getSamConfigUpdateIntervalMillis() + ", mainConfigUpdateIntervalMillis=" + this.getMainConfigUpdateIntervalMillis() + ", mainConfigTimeoutMillis=" + this.getMainConfigTimeoutMillis() + ", samStateUpdateIntervalMillis=" + this.getSamStateUpdateIntervalMillis() + ", createNodeIfAbsent=" + this.getCreateNodeIfAbsent() + ", samEventUpdateIntervalMillis=" + this.getSamEventUpdateIntervalMillis() + ", dotnetCompatibilityMode=" + this.getDotnetCompatibilityMode() + ", compatibilityMode=" + this.getCompatibilityMode() + ", agentConfigUpdateIntervalSeconds=" + this.getAgentConfigUpdateIntervalSeconds() + ", agentConfigUpdateEnabled=" + this.getAgentConfigUpdateEnabled() + ", dockerEnabled=" + this.getDockerEnabled() + ", dockerEngineUrl=" + this.getDockerEngineUrl() + ", sapMachine=" + this.getSapMachine() + ", dmmUserEnabled=" + this.getDmmUserEnabled() + ", containerdEnabled=" + this.getContainerdEnabled() + ", clusterName=" + this.getClusterName() + ", machineAgentWindowsAdjustCpuStealInCpuUsedPct=" + this.getMachineAgentWindowsAdjustCpuStealInCpuUsedPct() + ", bindMountOfHostRoot=" + this.getBindMountOfHostRoot() + ", osLinux=" + this.osLinux + ", machineName=" + this.getMachineName() + ", machineHierarchy=" + String.valueOf(this.getMachineHierarchy()) + ", machinePathParsed=" + this.machinePathParsed + ", collectMemoryMetricsUsingFreeCommandEnabled=" + this.getCollectMemoryMetricsUsingFreeCommandEnabled() + ", collectMemoryMetricsUsingVmstatCommandEnabled=" + this.getCollectMemoryMetricsUsingVmstatCommandEnabled() + ", registrationResilienceEnabled=" + this.getRegistrationResilienceEnabled() + ", containerOldCpuMetricKeyEnabled=" + this.getContainerOldCpuMetricKeyEnabled() + ", processLevelMetricsEnabled=" + this.getProcessLevelMetricsEnabled() + ", dcgmExporterServiceNamespace=" + this.getDcgmExporterServiceNamespace() + ", dcgmExporterServiceName=" + this.getDcgmExporterServiceName() + ", dcgmExporterServicePort=" + this.getDcgmExporterServicePort() + ", dcgmExporterServiceHost=" + this.getDcgmExporterServiceHost() + ", gpuEnabled=" + this.getGpuEnabled() + ")";
    }

    @Deprecated
    @Generated
    Boolean getDotnetCompatibilityMode() {
        return this.dotnetCompatibilityMode;
    }

    @JsonIgnore
    @Generated
    void setOsLinux(boolean osLinux) {
        this.osLinux = osLinux;
    }
}

