/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.configuration.bootstrap;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.voltron.utils.annotations.Raw;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapper;
import com.singularity.ee.util.security.credentialstore.exception.CryptoOperationFailureException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClearTextBootstrapConfiguration
implements BootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClearTextBootstrapConfiguration.class);
    private final BootstrapConfiguration delegate;
    private final Optional<KeyStoreBasedEncryptionWrapper> encryptionWrapper;
    private final String clearTextTrustStorePassword;
    private final String clearTextKeyStorePassword;
    private final String clearTextKeyStorePrivateKeyPassword;
    private final String clearTextAccountAccessKey;

    @Inject
    ClearTextBootstrapConfiguration(@Raw BootstrapConfiguration delegate, Optional<KeyStoreBasedEncryptionWrapper> encryptionWrapper) throws ProvisionException {
        this.delegate = delegate;
        this.encryptionWrapper = encryptionWrapper;
        this.clearTextTrustStorePassword = this.toClearText(delegate.getTrustStorePassword(), "controller-keystore-password");
        this.clearTextKeyStorePassword = this.toClearText(delegate.getKeyStorePassword(), "asymmetric-keystore-password");
        this.clearTextKeyStorePrivateKeyPassword = this.toClearText(delegate.getKeyStorePrivateKeyPassword(), "asymmetric-key-password");
        this.clearTextAccountAccessKey = this.toClearText(delegate.getAccountAccessKey(), "account-access-key");
    }

    @Override
    public String getTrustStorePassword() {
        return this.clearTextTrustStorePassword;
    }

    @Override
    public String getKeyStorePassword() {
        return this.clearTextKeyStorePassword;
    }

    @Override
    public String getKeyStorePrivateKeyPassword() {
        return this.clearTextKeyStorePrivateKeyPassword;
    }

    @Override
    public String getAccountAccessKey() {
        return this.clearTextAccountAccessKey;
    }

    private String toClearText(String property, String propertyName) {
        try {
            if (this.encryptionWrapper.isPresent()) {
                return ((KeyStoreBasedEncryptionWrapper)this.encryptionWrapper.get()).decryptCipherTextString(property);
            }
            return property;
        }
        catch (CryptoOperationFailureException e) {
            throw new ProvisionException(String.format("Failed to decrypt property %s = %s", propertyName, property), (Throwable)e);
        }
    }

    @VisibleForTesting
    BootstrapConfiguration getDelegate() {
        return this.delegate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClearTextBootstrapConfiguration)) {
            return false;
        }
        ClearTextBootstrapConfiguration other = (ClearTextBootstrapConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BootstrapConfiguration this$delegate = this.getDelegate();
        BootstrapConfiguration other$delegate = other.getDelegate();
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        Optional<KeyStoreBasedEncryptionWrapper> this$encryptionWrapper = this.encryptionWrapper;
        Optional<KeyStoreBasedEncryptionWrapper> other$encryptionWrapper = other.encryptionWrapper;
        if (this$encryptionWrapper == null ? other$encryptionWrapper != null : !this$encryptionWrapper.equals(other$encryptionWrapper)) {
            return false;
        }
        String this$clearTextTrustStorePassword = this.clearTextTrustStorePassword;
        String other$clearTextTrustStorePassword = other.clearTextTrustStorePassword;
        if (this$clearTextTrustStorePassword == null ? other$clearTextTrustStorePassword != null : !this$clearTextTrustStorePassword.equals(other$clearTextTrustStorePassword)) {
            return false;
        }
        String this$clearTextKeyStorePassword = this.clearTextKeyStorePassword;
        String other$clearTextKeyStorePassword = other.clearTextKeyStorePassword;
        if (this$clearTextKeyStorePassword == null ? other$clearTextKeyStorePassword != null : !this$clearTextKeyStorePassword.equals(other$clearTextKeyStorePassword)) {
            return false;
        }
        String this$clearTextKeyStorePrivateKeyPassword = this.clearTextKeyStorePrivateKeyPassword;
        String other$clearTextKeyStorePrivateKeyPassword = other.clearTextKeyStorePrivateKeyPassword;
        if (this$clearTextKeyStorePrivateKeyPassword == null ? other$clearTextKeyStorePrivateKeyPassword != null : !this$clearTextKeyStorePrivateKeyPassword.equals(other$clearTextKeyStorePrivateKeyPassword)) {
            return false;
        }
        String this$clearTextAccountAccessKey = this.clearTextAccountAccessKey;
        String other$clearTextAccountAccessKey = other.clearTextAccountAccessKey;
        return !(this$clearTextAccountAccessKey == null ? other$clearTextAccountAccessKey != null : !this$clearTextAccountAccessKey.equals(other$clearTextAccountAccessKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClearTextBootstrapConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BootstrapConfiguration $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        Optional<KeyStoreBasedEncryptionWrapper> $encryptionWrapper = this.encryptionWrapper;
        result = result * 59 + ($encryptionWrapper == null ? 43 : $encryptionWrapper.hashCode());
        String $clearTextTrustStorePassword = this.clearTextTrustStorePassword;
        result = result * 59 + ($clearTextTrustStorePassword == null ? 43 : $clearTextTrustStorePassword.hashCode());
        String $clearTextKeyStorePassword = this.clearTextKeyStorePassword;
        result = result * 59 + ($clearTextKeyStorePassword == null ? 43 : $clearTextKeyStorePassword.hashCode());
        String $clearTextKeyStorePrivateKeyPassword = this.clearTextKeyStorePrivateKeyPassword;
        result = result * 59 + ($clearTextKeyStorePrivateKeyPassword == null ? 43 : $clearTextKeyStorePrivateKeyPassword.hashCode());
        String $clearTextAccountAccessKey = this.clearTextAccountAccessKey;
        result = result * 59 + ($clearTextAccountAccessKey == null ? 43 : $clearTextAccountAccessKey.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getControllerHost() {
        return this.delegate.getControllerHost();
    }

    @Override
    @Generated
    public Integer getControllerPort() {
        return this.delegate.getControllerPort();
    }

    @Override
    @Generated
    public Boolean getControllerSslEnabled() {
        return this.delegate.getControllerSslEnabled();
    }

    @Override
    @Generated
    public String getTrustStorePath() {
        return this.delegate.getTrustStorePath();
    }

    @Override
    @Generated
    public String getKeyStorePath() {
        return this.delegate.getKeyStorePath();
    }

    @Override
    @Generated
    public String getAsymmetricKeyAlias() {
        return this.delegate.getAsymmetricKeyAlias();
    }

    @Override
    @Generated
    public Boolean getSslClientAuthenticationEnabled() {
        return this.delegate.getSslClientAuthenticationEnabled();
    }

    @Override
    @Generated
    public Boolean getFullSslValidationEnforced() {
        return this.delegate.getFullSslValidationEnforced();
    }

    @Override
    @Generated
    public String getSslProtocol() {
        return this.delegate.getSslProtocol();
    }

    @Override
    @Generated
    public Boolean getOrchestrationEnabled() {
        return this.delegate.getOrchestrationEnabled();
    }

    @Override
    @Generated
    public String getAccountName() {
        return this.delegate.getAccountName();
    }

    @Override
    @Generated
    public List<String> getMachineHierarchy() {
        return this.delegate.getMachineHierarchy();
    }

    @Override
    @Generated
    public String getHostId() {
        return this.delegate.getHostId();
    }

    @Override
    @Generated
    public String getMachineName() {
        return this.delegate.getMachineName();
    }

    @Override
    @Generated
    public Long getRegistrationPeriodSeconds() {
        return this.delegate.getRegistrationPeriodSeconds();
    }

    @Override
    @Generated
    public String getApplicationName() {
        return this.delegate.getApplicationName();
    }

    @Override
    @Generated
    public String getTierName() {
        return this.delegate.getTierName();
    }

    @Override
    @Generated
    public String getNodeName() {
        return this.delegate.getNodeName();
    }

    @Override
    @Generated
    public String getAgentRuntimeDir() {
        return this.delegate.getAgentRuntimeDir();
    }

    @Override
    @Deprecated
    @Generated
    public Boolean getAgentRegistrationForced() {
        return this.delegate.getAgentRegistrationForced();
    }

    @Override
    @Generated
    public String getProxyHost() {
        return this.delegate.getProxyHost();
    }

    @Override
    @Generated
    public Integer getProxyPort() {
        return this.delegate.getProxyPort();
    }

    @Override
    @Generated
    public String getProxyUsername() {
        return this.delegate.getProxyUsername();
    }

    @Override
    @Generated
    public String getProxyPasswordFile() {
        return this.delegate.getProxyPasswordFile();
    }

    @Override
    @Generated
    public Boolean getProxyUsePreemptiveAuth() {
        return this.delegate.getProxyUsePreemptiveAuth();
    }

    @Override
    @Generated
    public Boolean getClientGzipEnabled() {
        return this.delegate.getClientGzipEnabled();
    }

    @Override
    @Generated
    public Boolean getUseEncryptedCredentials() {
        return this.delegate.getUseEncryptedCredentials();
    }

    @Override
    @Generated
    public String getCredentialStoreFilename() {
        return this.delegate.getCredentialStoreFilename();
    }

    @Override
    @Generated
    public String getObfuscatedCredentialStorePassword() {
        return this.delegate.getObfuscatedCredentialStorePassword();
    }

    @Override
    @Generated
    public String getCredentialStoreFormat() {
        return this.delegate.getCredentialStoreFormat();
    }

    @Override
    @Generated
    public Long getRequestInitialRetryPeriod() {
        return this.delegate.getRequestInitialRetryPeriod();
    }

    @Override
    @Generated
    public Long getRequestMaxRetryPeriod() {
        return this.delegate.getRequestMaxRetryPeriod();
    }

    @Override
    @Generated
    public Integer getRequestMaxRetries() {
        return this.delegate.getRequestMaxRetries();
    }

    @Override
    @Generated
    public Integer getExtensionsSchedulerCorePoolSize() {
        return this.delegate.getExtensionsSchedulerCorePoolSize();
    }

    @Override
    @Generated
    public Long getExtensionsSchedulerShutdownTimeoutMillis() {
        return this.delegate.getExtensionsSchedulerShutdownTimeoutMillis();
    }

    @Override
    @Generated
    public String getExtensionsDirectory() {
        return this.delegate.getExtensionsDirectory();
    }

    @Override
    @Generated
    public Long getExtensionsUpdateIntervalMillis() {
        return this.delegate.getExtensionsUpdateIntervalMillis();
    }

    @Override
    @Generated
    public Long getExtensionsMaxStartTimeMillis() {
        return this.delegate.getExtensionsMaxStartTimeMillis();
    }

    @Override
    @Generated
    public Long getExtensionsMaxStopTimeMillis() {
        return this.delegate.getExtensionsMaxStopTimeMillis();
    }

    @Override
    @Generated
    public Long getMetricAggregatorCacheExpirationTimeSeconds() {
        return this.delegate.getMetricAggregatorCacheExpirationTimeSeconds();
    }

    @Override
    @Generated
    public Boolean getSimUserEnabled() {
        return this.delegate.getSimUserEnabled();
    }

    @Override
    @Generated
    public Long getSamConfigUpdateIntervalMillis() {
        return this.delegate.getSamConfigUpdateIntervalMillis();
    }

    @Override
    @Generated
    public Long getSamStateUpdateIntervalMillis() {
        return this.delegate.getSamStateUpdateIntervalMillis();
    }

    @Override
    @Generated
    public Long getMainConfigUpdateIntervalMillis() {
        return this.delegate.getMainConfigUpdateIntervalMillis();
    }

    @Override
    @Generated
    public Long getMainConfigTimeoutMillis() {
        return this.delegate.getMainConfigTimeoutMillis();
    }

    @Override
    @Generated
    public Boolean getCreateNodeIfAbsent() {
        return this.delegate.getCreateNodeIfAbsent();
    }

    @Override
    @Generated
    public Boolean getSapMachine() {
        return this.delegate.getSapMachine();
    }

    @Override
    @Generated
    public Long getSamEventUpdateIntervalMillis() {
        return this.delegate.getSamEventUpdateIntervalMillis();
    }

    @Override
    @Generated
    public Boolean getCompatibilityMode() {
        return this.delegate.getCompatibilityMode();
    }

    @Override
    @Generated
    public Long getAgentConfigUpdateIntervalSeconds() {
        return this.delegate.getAgentConfigUpdateIntervalSeconds();
    }

    @Override
    @Generated
    public Boolean getAgentConfigUpdateEnabled() {
        return this.delegate.getAgentConfigUpdateEnabled();
    }

    @Override
    @Generated
    public Boolean getDockerEnabled() {
        return this.delegate.getDockerEnabled();
    }

    @Override
    @Generated
    public String getDockerEngineUrl() {
        return this.delegate.getDockerEngineUrl();
    }

    @Override
    @Generated
    public Boolean getDmmUserEnabled() {
        return this.delegate.getDmmUserEnabled();
    }

    @Override
    @Generated
    public Boolean getUseSimpleHostname() {
        return this.delegate.getUseSimpleHostname();
    }

    @Override
    @Generated
    public String getBindMountOfHostRoot() {
        return this.delegate.getBindMountOfHostRoot();
    }

    @Override
    @Generated
    public Boolean getCollectMemoryMetricsUsingFreeCommandEnabled() {
        return this.delegate.getCollectMemoryMetricsUsingFreeCommandEnabled();
    }

    @Override
    @Generated
    public Boolean getCollectMemoryMetricsUsingVmstatCommandEnabled() {
        return this.delegate.getCollectMemoryMetricsUsingVmstatCommandEnabled();
    }

    @Override
    @Generated
    public Boolean getMachineAgentWindowsAdjustCpuStealInCpuUsedPct() {
        return this.delegate.getMachineAgentWindowsAdjustCpuStealInCpuUsedPct();
    }

    @Override
    @Generated
    public Boolean getContainerdEnabled() {
        return this.delegate.getContainerdEnabled();
    }

    @Override
    @Generated
    public String getClusterName() {
        return this.delegate.getClusterName();
    }

    @Override
    @Generated
    public Boolean getRegistrationResilienceEnabled() {
        return this.delegate.getRegistrationResilienceEnabled();
    }

    @Override
    @Generated
    public Boolean getContainerOldCpuMetricKeyEnabled() {
        return this.delegate.getContainerOldCpuMetricKeyEnabled();
    }

    @Override
    @Generated
    public Boolean getProcessLevelMetricsEnabled() {
        return this.delegate.getProcessLevelMetricsEnabled();
    }

    @Override
    @Generated
    public String getDcgmExporterServiceName() {
        return this.delegate.getDcgmExporterServiceName();
    }

    @Override
    @Generated
    public String getDcgmExporterServiceNamespace() {
        return this.delegate.getDcgmExporterServiceNamespace();
    }

    @Override
    @Generated
    public Integer getDcgmExporterServicePort() {
        return this.delegate.getDcgmExporterServicePort();
    }

    @Override
    @Generated
    public String getDcgmExporterServiceHost() {
        return this.delegate.getDcgmExporterServiceHost();
    }

    @Override
    @Generated
    public Boolean getGpuEnabled() {
        return this.delegate.getGpuEnabled();
    }
}

