/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.configuration.bootstrap;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfigurationInvocationHandler;
import com.appdynamics.agent.sim.configuration.bootstrap.DefaultBootstrapConfiguration;
import com.appdynamics.voltron.utils.overrides.Overrider;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.name.Named;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;

class BootstrapConfigurationProvider
implements Provider<BootstrapConfiguration> {
    private final Validator validator;
    private final Overrider overrider;
    private final XmlMapper mapper;
    private final String defaultXmlConfig;
    private final String globalXmlConfig;

    @Inject
    BootstrapConfigurationProvider(Validator validator, Overrider overrider, XmlMapper mapper, @Named(value="defaultXmlConfigFile") String defaultXmlConfig, @Named(value="defaultGlobalXmlConfigFile") String globalXmlConfig) {
        this.validator = validator;
        this.overrider = overrider;
        this.mapper = mapper;
        this.defaultXmlConfig = defaultXmlConfig;
        this.globalXmlConfig = globalXmlConfig;
    }

    public BootstrapConfiguration get() {
        File configFile = this.getConfigFile(this.defaultXmlConfig);
        String configData = this.readConfigData(configFile);
        BootstrapConfiguration config = this.parseConfigData(configData, configFile);
        if (StringUtils.isNotBlank((CharSequence)this.globalXmlConfig)) {
            config = this.readAndMergeGlobalConfigFile(this.globalXmlConfig, config);
        }
        this.overrider.override((Object)config);
        Set violations = this.validator.validate((Object)config, new Class[0]);
        if (violations.size() > 0) {
            String msg = BootstrapConfigurationProvider.buildValidationExceptionMessage(configData, violations);
            throw new ProvisionException("Bootstrap configuration failed to validate.", (Throwable)new ConstraintViolationException(msg, violations));
        }
        return config;
    }

    private String readConfigData(File configFile) throws ProvisionException {
        try {
            byte[] data = Files.readAllBytes(configFile.toPath());
            String configData = new String(data);
            return configData;
        }
        catch (IOException e) {
            throw new ProvisionException("Could not read bootstrap configuration file.", (Throwable)e);
        }
    }

    private BootstrapConfiguration parseConfigData(String configData, File configFile) throws ProvisionException {
        BootstrapConfiguration config;
        try {
            config = this.parseXmlBootstrapConfig(configData);
        }
        catch (IOException e) {
            throw new ProvisionException("Could not read configuration file " + String.valueOf(configFile), (Throwable)e);
        }
        return config;
    }

    private BootstrapConfiguration readAndMergeGlobalConfigFile(String globalConfigFile, BootstrapConfiguration baseConfig) {
        File configFile = this.getGlobalConfigFile(globalConfigFile);
        if (configFile != null) {
            String configData = this.readConfigData(configFile);
            BootstrapConfiguration globalConfig = this.parseConfigData(configData, configFile);
            return this.merge(baseConfig, globalConfig);
        }
        return baseConfig;
    }

    private static String buildValidationExceptionMessage(String rawData, Set<ConstraintViolation<BootstrapConfiguration>> violations) {
        StringBuilder sb = new StringBuilder("Error occurred while validating bootstrap configuration data:\n").append(rawData).append("\n");
        for (ConstraintViolation<BootstrapConfiguration> violation : violations) {
            sb.append("    property '").append(violation.getPropertyPath()).append("': ").append(violation.getMessage()).append(" Found value '").append(violation.getInvalidValue()).append("'.").append("\n");
        }
        return sb.toString();
    }

    private BootstrapConfiguration parseXmlBootstrapConfig(String configData) throws IOException {
        return (BootstrapConfiguration)this.mapper.readValue(configData, DefaultBootstrapConfiguration.class);
    }

    private File getConfigFile(String fileName) {
        String configPath = System.getProperty("appdynamics.machine.agent.configFile");
        if (configPath != null && !configPath.isEmpty()) {
            File configFile = new File(configPath);
            if (!configFile.canRead()) {
                throw new ProvisionException("Could not read configuration file", (Throwable)new FileNotFoundException("The bootstrap configuration file specified via system property appdynamics.machine.agent.configFile to '" + configPath + "' cannot be read. Please unset the system property to use the default path or fix the path or permission."));
            }
            return configFile;
        }
        File configFile = new File(fileName);
        if (configFile.canRead()) {
            return configFile;
        }
        throw new ProvisionException("Could not find configuration file", (Throwable)new FileNotFoundException("Could not find a bootstrap configuration file at the default location " + configFile.getAbsolutePath() + ". Please either create the file, or specify one via the appdynamics.machine.agent.configFile system property. You also may not have permission to read this file."));
    }

    private File getGlobalConfigFile(String fileName) {
        File configFile = new File(fileName);
        if (configFile.canRead()) {
            return configFile;
        }
        return null;
    }

    private BootstrapConfiguration merge(BootstrapConfiguration ... configsToMerge) throws ProvisionException {
        BootstrapConfigurationInvocationHandler invocationHandler = new BootstrapConfigurationInvocationHandler();
        invocationHandler.add(configsToMerge);
        return (BootstrapConfiguration)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{BootstrapConfiguration.class}, (InvocationHandler)invocationHandler);
    }
}

