/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.configuration.bootstrap;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.google.inject.ProvisionException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BootstrapConfigurationInvocationHandler
implements InvocationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BootstrapConfigurationInvocationHandler.class);
    private final List<BootstrapConfiguration> configurationList = new ArrayList<BootstrapConfiguration>();

    BootstrapConfigurationInvocationHandler() {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args == null || args.length == 0) {
            String methodName = method.getName();
            return this.invokeMethodsForEachConfiguration(methodName);
        }
        log.info("Method \"{}\" called with more than 1 argument", (Object)method.getName());
        return null;
    }

    private Object invokeMethodsForEachConfiguration(String methodName) {
        for (BootstrapConfiguration bootstrapConfiguration : this.configurationList) {
            try {
                Method methodToCall = bootstrapConfiguration.getClass().getDeclaredMethod(methodName, new Class[0]);
                Object returnValue = this.invokeMethod(bootstrapConfiguration, methodToCall);
                if (returnValue == null || returnValue instanceof String && returnValue.toString().isEmpty()) continue;
                return returnValue;
            }
            catch (Exception e) {
                throw new ProvisionException("Exception \"" + e.toString() + "\" caught in invocation of " + methodName + " method", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethod(BootstrapConfiguration bootstrapConfiguration, Method methodToCall) throws IllegalAccessException, InvocationTargetException {
        boolean accessible = methodToCall.isAccessible();
        methodToCall.setAccessible(true);
        try {
            Object object = methodToCall.invoke((Object)bootstrapConfiguration, new Object[0]);
            return object;
        }
        finally {
            methodToCall.setAccessible(accessible);
        }
    }

    void add(BootstrapConfiguration ... bootstrapConfiguration) {
        this.configurationList.addAll(Arrays.asList(bootstrapConfiguration));
    }
}

