/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.bootstrap;

import com.appdynamics.agent.sim.Main;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Bootstrap {
    public static boolean checkJVMCompatibility() {
        String javaVersion = System.getProperty("java.version");
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (javaVersion.compareTo("1.8") < 0) {
            System.err.println(" " + format.format(date) + " Agent only supports Java 1.8 and higher. Provided: " + javaVersion + ".\nPlease update Java or download and use a version bundled with the JRE to start machine agent.");
            return false;
        }
        System.out.println(" " + format.format(date) + " Using Java Version [" + javaVersion + "] for Agent");
        String version = Bootstrap.class.getPackage().getImplementationVersion();
        System.out.println(" " + format.format(date) + " Using Agent Version [" + version + "]");
        return true;
    }

    public static void main(String[] args) {
        if (!Bootstrap.checkJVMCompatibility()) {
            System.exit(-1);
        }
        try {
            new Main().startSafe();
        }
        catch (Throwable t) {
            System.exit(-1);
        }
    }
}

