/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.assembler;

import com.appdynamics.sim.common.biz.shared.machines.AssemblyDescriptors;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class GlobalAssembly {
    private AssemblyDescriptors agentAssembly = AssemblyDescriptors.builder().build();
    private volatile AssemblyDescriptors controllerAssembly = AssemblyDescriptors.builder().emptyDescriptors().build();
    private volatile AssemblyDescriptors finalAssembly = AssemblyDescriptors.builder().emptyDescriptors().build();

    public void setControllerAssembly(AssemblyDescriptors newControllerAssembly) {
        if (newControllerAssembly == null && this.controllerAssembly.getDescriptors().isEmpty()) {
            return;
        }
        if (!this.controllerAssembly.equals((Object)newControllerAssembly)) {
            this.controllerAssembly = newControllerAssembly;
            if (this.controllerAssembly == null) {
                this.controllerAssembly = AssemblyDescriptors.builder().emptyDescriptors().build();
            }
            this.finalAssembly = this.computeFinalAssembly(this.agentAssembly, this.controllerAssembly);
        }
    }

    public AssemblyDescriptors getFinalAssembly() {
        return this.finalAssembly;
    }

    AssemblyDescriptors computeFinalAssembly(AssemblyDescriptors agentAssembly, AssemblyDescriptors controllerAssembly) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : controllerAssembly.getDescriptors().entrySet()) {
            Optional<AssemblyDescriptors.Revision> latestRevision;
            AssemblyDescriptors.Revision agentRevision = (AssemblyDescriptors.Revision)agentAssembly.getDescriptors().get(entry.getKey());
            if (agentRevision == null || !(latestRevision = this.latestMatchingRevision(agentRevision, (AssemblyDescriptors.Revision)entry.getValue())).isPresent()) continue;
            builder.put((Object)((String)entry.getKey()), (Object)((AssemblyDescriptors.Revision)latestRevision.get()));
        }
        return AssemblyDescriptors.builder().descriptors(builder.build()).build();
    }

    private Optional<AssemblyDescriptors.Revision> latestMatchingRevision(AssemblyDescriptors.Revision r1, AssemblyDescriptors.Revision r2) {
        Sets.SetView intersect = Sets.intersection((Set)r1.getMajorRevision(), (Set)r2.getMajorRevision());
        if (intersect.isEmpty()) {
            return Optional.absent();
        }
        Integer maxRevision = (Integer)Collections.max(intersect);
        return Optional.of((Object)new AssemblyDescriptors.Revision(ImmutableSet.of((Object)maxRevision)));
    }

    @Generated
    public AssemblyDescriptors getAgentAssembly() {
        return this.agentAssembly;
    }

    @Generated
    public AssemblyDescriptors getControllerAssembly() {
        return this.controllerAssembly;
    }

    @Generated
    public void setAgentAssembly(AssemblyDescriptors agentAssembly) {
        this.agentAssembly = agentAssembly;
    }

    @Generated
    public void setFinalAssembly(AssemblyDescriptors finalAssembly) {
        this.finalAssembly = finalAssembly;
    }
}

