/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.utils.validators;

import com.appdynamics.voltron.utils.validators.Enum;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumValueValidator
implements ConstraintValidator<Enum, String> {
    private static final Logger log = LoggerFactory.getLogger(EnumValueValidator.class);
    @VisibleForTesting
    private Enum annotation;

    public void initialize(Enum constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        Object[] enumValues = this.annotation.enumClass().getEnumConstants();
        if (enumValues != null) {
            for (Object enumValue : enumValues) {
                if (!enumValue.toString().equals(value) && (!this.annotation.ignoreCase() || !value.equalsIgnoreCase(enumValue.toString()))) continue;
                return true;
            }
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate("Supported values are " + Arrays.toString(enumValues)).addConstraintViolation();
        return false;
    }

    Enum getAnnotation() {
        return this.annotation;
    }
}

