/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.utils.overrides;

import com.appdynamics.voltron.utils.overrides.FieldOverrider;
import com.appdynamics.voltron.utils.overrides.RegexValidation;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexFieldValidator
implements FieldOverrider {
    @Override
    public String getDataFor(Field field, Object originalValue, String prevOverride, Object target) {
        RegexValidation annotation = field.getAnnotation(RegexValidation.class);
        if (annotation != null) {
            if (originalValue instanceof String) {
                this.validateSyntax(originalValue.toString(), field);
            } else if (originalValue instanceof Map) {
                Map regexMap = (Map)originalValue;
                this.validateMapSyntax(regexMap, field);
            }
        }
        return prevOverride;
    }

    @VisibleForTesting
    void validateSyntax(String regex, Field field) throws IllegalArgumentException {
        if (regex == null || regex.length() == 0) {
            return;
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("The regular expression for the field: " + field.getName() + ", contains errors: " + regex);
        }
    }

    @VisibleForTesting
    void validateMapSyntax(Map<String, String> map, Field field) throws IllegalArgumentException {
        if (map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                try {
                    if (entry.getValue() == null || entry.getValue().length() == 0) continue;
                    Pattern.compile(entry.getValue());
                }
                catch (PatternSyntaxException e) {
                    throw new IllegalArgumentException("The regular expression for field: " + field.getName() + " and entry: " + entry.getKey() + ", contains errors: " + entry.getValue());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid class given to RegexValidation! Class is: " + map.getClass().getName());
                }
            }
        }
    }
}

