/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.utils.overrides;

import com.appdynamics.voltron.utils.StringUtil;
import com.appdynamics.voltron.utils.overrides.FieldOverrider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public abstract class ByKeyFieldOverrider<T extends Annotation>
implements FieldOverrider {
    private final Class<T> annotationType;

    protected ByKeyFieldOverrider(Class<T> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public final String getDataFor(Field field, Object originalValue, String prevOverride, Object target) {
        T annotation = field.getAnnotation(this.annotationType);
        if (annotation != null) {
            String[] keys = this.getKeysFromAnnotation(annotation);
            if (keys == null || keys.length == 0) {
                throw new IllegalArgumentException("The " + this.annotationType.getSimpleName() + "value should not be blank. Found " + String.valueOf(keys));
            }
            for (String key : keys) {
                if (StringUtil.isBlank(key)) {
                    throw new IllegalArgumentException("The " + this.annotationType.getSimpleName() + "value should not be blank. Found " + key);
                }
                String overrideVal = this.readOverrideVal(key);
                if (StringUtil.isBlank(overrideVal)) continue;
                return overrideVal;
            }
        }
        return prevOverride;
    }

    protected abstract String readOverrideVal(String var1);

    protected abstract String[] getKeysFromAnnotation(T var1);
}

