/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;

public class ParameterizedTypeUtils {
    @VisibleForTesting
    <CONCRETE> Type getParametrizedTypeOf(Type inputType, Class<CONCRETE> concreteTypeClass) {
        Type resultType;
        if (inputType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)inputType;
            Type[] fieldArgTypes = parameterizedType.getActualTypeArguments();
            if (fieldArgTypes.length != 1) {
                throw new UnsupportedOperationException("Only parameterized types with exactly one wildcard supported");
            }
            Type firstType = fieldArgTypes[0];
            resultType = Types.newParameterizedType((Type)parameterizedType.getRawType(), (Type[])new Type[]{this.getParametrizedTypeOf(firstType, concreteTypeClass)});
        } else if (inputType instanceof WildcardType) {
            resultType = concreteTypeClass;
        } else if (inputType instanceof TypeVariable) {
            resultType = concreteTypeClass;
        } else {
            return inputType;
        }
        return resultType;
    }

    public <RAW, CONCRETE> TypeLiteral<RAW> buildConcreteTypeLiteral(TypeLiteral<RAW> wildcardTypeLiteral, Class<CONCRETE> concreteTypeClass) {
        Type type = wildcardTypeLiteral.getType();
        Type resultType = this.getParametrizedTypeOf(type, concreteTypeClass);
        TypeLiteral resultTypeLiteral = TypeLiteral.get((Type)resultType);
        return resultTypeLiteral;
    }

    public <RAW, CONCRETE> TypeLiteral<Set<RAW>> buildConcreteSetTypeLiteral(TypeLiteral<RAW> wildcardTypeLiteral, Class<CONCRETE> concreteTypeClass) {
        ParameterizedType setType = Types.newParameterizedType(Set.class, (Type[])new Type[]{wildcardTypeLiteral.getType()});
        TypeLiteral<RAW> resultTypeLiteral = this.buildConcreteTypeLiteral(TypeLiteral.get((Type)setType), concreteTypeClass);
        return resultTypeLiteral;
    }
}

