/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.testutils.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;

@Path(value="/myresource")
public class TestResource {
    public static final String PATH = "/myresource";
    public static final String TIMEOUT_PATH = "/timeout";
    public static final String BIN_PATH = "/bin";
    public static final String LARGE_DATA_PATH = "/large";
    public static final int SOCKET_TIMEOUT = 500;
    public static final String STRING_DATA = "Hello";
    private String postData;
    private final int socketTimeout;
    private AtomicInteger count = new AtomicInteger(0);

    public TestResource() {
        this.socketTimeout = 500;
    }

    @GET
    public String doStrGet() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.count.getAndIncrement();
        return STRING_DATA;
    }

    @GET
    @Path(value="/bin")
    public StreamingOutput doBinaryGet() {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                for (int i = 0; i < 200; ++i) {
                    output.write(i);
                }
            }
        };
    }

    @POST
    public String doPost(String data) {
        this.postData = data + data;
        return this.postData;
    }

    @GET
    @Path(value="/large")
    public String doLargeGet() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 2000; ++i) {
            sb.append(i);
        }
        return sb.toString();
    }

    @GET
    @Path(value="/timeout")
    public String timeout() {
        try {
            Thread.sleep(2 * this.socketTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return "done";
    }

    public String getPostData() {
        return this.postData;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public AtomicInteger getCount() {
        return this.count;
    }
}

