/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.testutils.rest;

import com.appdynamics.voltron.serialization.SimDtoSerializationModule;
import com.appdynamics.voltron.test.utils.HttpUtils;
import com.appdynamics.voltron.testutils.rest.BasicAuthServletFilter;
import com.appdynamics.voltron.testutils.rest.KeyStores;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.ee8.servlet.FilterHolder;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.servlet.ServletHolder;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWithJerseyRule
extends ExternalResource {
    private static final Logger log = LoggerFactory.getLogger(JettyWithJerseyRule.class);
    public static final String USERNAME = "myUser";
    public static final String PASSWORD = "myPassword";
    private final String contextPath;
    private final Map<String, String> credentials;
    private final int port;
    private final int securePort;
    private Server server;
    private String baseUrl;
    private String secureBaseUrl;
    private BasicAuthServletFilter auth;
    private boolean sslEnabled;

    public JettyWithJerseyRule(String contextPath, Map<String, String> credentials, int port, int securePort) {
        this.contextPath = contextPath;
        this.credentials = ImmutableMap.copyOf(credentials);
        this.port = port <= 0 ? HttpUtils.findFreePortOrFail() : port;
        this.securePort = securePort <= 0 ? HttpUtils.findFreePortOrFail() : securePort;
    }

    public JettyWithJerseyRule(String contextPath, Map<String, String> credentials) {
        this(contextPath, credentials, 0, 0);
    }

    public JettyWithJerseyRule(String contextPath, int port) {
        this(contextPath, Collections.singletonMap(USERNAME, PASSWORD), port, 0);
    }

    public JettyWithJerseyRule(String contextPath) {
        this(contextPath, 0);
    }

    public JettyWithJerseyRule() {
        this("/");
    }

    public void before() throws Throwable {
        if (this.server == null) {
            this.baseUrl = "http://localhost:" + this.port;
            this.secureBaseUrl = "https://localhost:" + this.securePort;
            this.sslEnabled = this.enableSsl();
            this.server = new Server(this.port);
            this.auth = new BasicAuthServletFilter("Authorization", "WWW-Authenticate", 401, this.credentials);
            this.configureSsl();
            ServletContextHandler context = this.buildServletContextHandler();
            context.addFilter(new FilterHolder((Filter)this.auth), "/*", EnumSet.allOf(DispatcherType.class));
            Handler gzipHandler = JettyWithJerseyRule.configureGzipNew(context);
            this.server.setHandler(gzipHandler);
            this.server.start();
        }
    }

    private void configureSsl() throws IOException {
        if (this.sslEnabled) {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();
            sslContextFactory.setKeyStoreResource(resourceFactory.newResource(this.getKeyStore()));
            sslContextFactory.setKeyStorePassword("password");
            sslContextFactory.setKeyManagerPassword("password");
            sslContextFactory.setIncludeProtocols(new String[]{this.getSslProtocol()});
            HttpConfiguration httpsConfig = new HttpConfiguration();
            httpsConfig.setSecureScheme("https");
            httpsConfig.setSecurePort(this.securePort);
            httpsConfig.setOutputBufferSize(32768);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(this.server, null, null, null, 4, 8, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            https.setPort(this.securePort);
            https.setIdleTimeout(500000L);
            this.server.addConnector((Connector)https);
            boolean sslClientAuthEnabled = this.enableSslClientAuth();
            if (sslClientAuthEnabled) {
                sslContextFactory.setNeedClientAuth(true);
            }
        }
    }

    private ServletContextHandler buildServletContextHandler() {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(this.contextPath);
        ServletContainer servletContainer = new ServletContainer(new Application(){

            public Set<Class<?>> getClasses() {
                return JettyWithJerseyRule.this.getClasses();
            }

            public Set<Object> getSingletons() {
                return JettyWithJerseyRule.this.getSingletons();
            }
        });
        ServletHolder servletHolder = new ServletHolder((Servlet)servletContainer);
        servletHolder.setInitParameter("com.sun.jersey.api.json.POJOMappingFeature", "true");
        context.addServlet(servletHolder, this.getJerseyPathSpec());
        HashMap<String, Servlet> servlets = new HashMap<String, Servlet>();
        this.addServlets(servlets);
        for (Map.Entry servletEntry : servlets.entrySet()) {
            context.addServlet(new ServletHolder((Servlet)servletEntry.getValue()), (String)servletEntry.getKey());
        }
        return context;
    }

    private static Handler configureGzipNew(ServletContextHandler context) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setIncludedPaths(new String[]{"/*"});
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT", "PATCH", "DELETE"});
        gzipHandler.setInflateBufferSize(8192);
        gzipHandler.setHandler((Supplier)context);
        return gzipHandler;
    }

    protected String getSslProtocol() {
        return "TLSv1.2";
    }

    public void after() {
        try {
            if (this.server != null) {
                this.server.stop();
                this.server = null;
            }
        }
        catch (Exception e) {
            log.info("Failed to shutdown server");
        }
    }

    protected Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        this.addClasses(classes);
        return classes;
    }

    protected void addClasses(Set<Class<?>> classes) {
    }

    private Set<Object> getSingletons() {
        HashSet<Object> singletons = new HashSet<Object>();
        singletons.add(new JacksonJsonProvider(SimDtoSerializationModule.buildObjectMapper()));
        this.addSingletons(singletons);
        return singletons;
    }

    protected void addSingletons(Set<Object> singletons) {
    }

    protected void addServlets(Map<String, Servlet> servlets) {
    }

    protected boolean enableSsl() {
        return false;
    }

    protected boolean enableSslClientAuth() {
        return false;
    }

    protected String getJerseyPathSpec() {
        return "/*";
    }

    public void setAuthEnabled(boolean enabled) {
        this.auth.setAuthEnabled(enabled);
    }

    public void setPreemptiveAuthAllowed(boolean preemptiveAuthAllowed) {
        this.auth.setPreemptiveAuthAllowed(preemptiveAuthAllowed);
    }

    public Set<InetSocketAddress> getSeenClients() {
        return this.auth.getSeenClients();
    }

    public Set<InetSocketAddress> getChallengedClients() {
        return this.auth.getChallengedClients();
    }

    public Set<InetSocketAddress> getPreemptiveClients() {
        return this.auth.getPreemptiveClients();
    }

    public void clean() {
        this.auth.clean();
    }

    public URL getKeyStore() {
        KeyStores keyStores = new KeyStores();
        URL url = keyStores.getServerTrustStoreUrl();
        if (url == null) {
            throw new RuntimeException("Could not find the keystore");
        }
        return url;
    }

    public final JettyWithJerseyRule addCredentials(String username, String password) {
        this.auth.addCredentials(username, password);
        return this;
    }

    public final JettyWithJerseyRule clearCredentials() {
        this.auth.clearCredentials();
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public Server getServer() {
        return this.server;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getSecureBaseUrl() {
        return this.secureBaseUrl;
    }

    public BasicAuthServletFilter getAuth() {
        return this.auth;
    }
}

