/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.testutils.rest;

import com.appdynamics.voltron.testutils.rest.BasicAuthServletFilter;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.ee8.proxy.ProxyServlet;
import org.eclipse.jetty.ee8.servlet.FilterHolder;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.servlet.ServletHolder;
import org.eclipse.jetty.server.Server;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyAsProxyRule
extends ExternalResource {
    private static final Logger log = LoggerFactory.getLogger(JettyAsProxyRule.class);
    public static final String HEADER_NAME = "X-ProxyAddedHeader";
    public static final String HEADER_VALUE = "Added for testing";
    public static final String USERNAME = "proxyUser";
    public static final String PASSWORD = "proxyPass";
    private final int port;
    private Server server;
    private String baseUrl;
    private static final String PROXY_REQ_AUTHORIZATION_HEADER = "Proxy-Authorization";
    private static final String PROXY_RESP_CHALLENGE_HEADER = "Proxy-Authenticate";
    private BasicAuthServletFilter authFilter;

    public JettyAsProxyRule(int port) {
        this.port = port;
    }

    public void before() throws Throwable {
        this.baseUrl = "http://localhost:" + this.port;
        this.server = new Server(this.port);
        this.authFilter = new BasicAuthServletFilter(PROXY_REQ_AUTHORIZATION_HEADER, PROXY_RESP_CHALLENGE_HEADER, 407, Collections.singletonMap(USERNAME, PASSWORD));
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addFilter(new FilterHolder((Filter)this.authFilter), "/*", EnumSet.allOf(DispatcherType.class));
        context.addServlet(new ServletHolder((Servlet)new ProxyServlet(){

            protected void sendProxyRequest(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) {
                proxyRequest.headers(headers -> headers.add(JettyAsProxyRule.HEADER_NAME, JettyAsProxyRule.HEADER_VALUE));
                super.sendProxyRequest(clientRequest, proxyResponse, proxyRequest);
            }
        }), "/*");
        this.server.setHandler((Supplier)context);
        this.server.start();
        this.reset();
    }

    protected void after() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            log.info("Failed to shutdown server");
        }
    }

    public void setAuthEnabled(boolean enabled) {
        this.authFilter.setAuthEnabled(enabled);
    }

    public void setPreemptiveAuthAllowed(boolean preemptiveAuthAllowed) {
        this.authFilter.setPreemptiveAuthAllowed(preemptiveAuthAllowed);
    }

    public void reset() {
        this.authFilter.clean();
    }

    public Set<InetSocketAddress> getSeenClients() {
        return this.authFilter.getSeenClients();
    }

    public Set<InetSocketAddress> getChallengedClients() {
        return this.authFilter.getChallengedClients();
    }

    public Set<InetSocketAddress> getPreemptiveClient() {
        return this.authFilter.getPreemptiveClients();
    }

    public int getPort() {
        return this.port;
    }

    public Server getServer() {
        return this.server;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

