/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.testutils.rest;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;

public class BasicAuthServletFilter
implements Filter {
    private static final Splitter AUTH_RAW_SPLITTER = Splitter.on((String)" ").limit(2).omitEmptyStrings().trimResults();
    private static final Splitter AUTH_DECODED_SPLITTER = Splitter.on((String)":").limit(2).omitEmptyStrings().trimResults();
    private static final int AUTH_INDEX = 1;
    private final ImmutableMap<String, String> initialCredentials;
    private volatile boolean authEnabled;
    private volatile boolean preemptiveAuthAllowed;
    private final Set<InetSocketAddress> challengedClients;
    private final Set<InetSocketAddress> preemptiveClients;
    private final Set<InetSocketAddress> seenClients;
    private final String authRequestHeader;
    private final String authRespHeader;
    private final int challengeResponseStatus;
    private final Map<String, String> credentials;

    public BasicAuthServletFilter(@NonNull String authRequestHeader, @NonNull String authRespHeader, int challengeResponseStatus, @NonNull Map<String, String> credentials) {
        if (authRequestHeader == null) {
            throw new NullPointerException("authRequestHeader is marked non-null but is null");
        }
        if (authRespHeader == null) {
            throw new NullPointerException("authRespHeader is marked non-null but is null");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        this.authRequestHeader = authRequestHeader;
        this.authRespHeader = authRespHeader;
        this.challengeResponseStatus = challengeResponseStatus;
        this.initialCredentials = ImmutableMap.copyOf(credentials);
        this.credentials = new ConcurrentHashMap<String, String>(credentials);
        this.challengedClients = Collections.synchronizedSet(new HashSet());
        this.preemptiveClients = Collections.synchronizedSet(new HashSet());
        this.seenClients = Collections.synchronizedSet(new HashSet());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            InetSocketAddress clientAddr = new InetSocketAddress(request.getRemoteAddr(), request.getRemotePort());
            this.seenClients.add(clientAddr);
            if (this.isAuthEnabled()) {
                boolean clientWasChallenged = this.challengedClients.contains(clientAddr);
                String auth = httpRequest.getHeader(this.authRequestHeader);
                if (auth != null && !clientWasChallenged) {
                    this.preemptiveClients.add(clientAddr);
                }
                if (auth != null && (clientWasChallenged || this.isPreemptiveAuthAllowed())) {
                    String password;
                    String decodedValue = new String(Base64.decode((String)this.extractAuthValue(auth)));
                    List usernamePassword = AUTH_DECODED_SPLITTER.splitToList((CharSequence)decodedValue);
                    String username = (String)usernamePassword.get(0);
                    if (this.isAuthPass(username, password = (String)usernamePassword.get(1))) {
                        chain.doFilter(request, response);
                    } else {
                        this.sendFailure(httpResponse);
                    }
                } else {
                    this.sendFailure(httpResponse);
                    this.challengedClients.add(clientAddr);
                }
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private void sendFailure(HttpServletResponse httpResponse) {
        httpResponse.setHeader(this.authRespHeader, "Basic realm=\"Test Server\"");
        httpResponse.setStatus(this.challengeResponseStatus);
    }

    public void destroy() {
    }

    private boolean isAuthPass(String username, String password) {
        return password.equals(this.credentials.get(username));
    }

    private String extractAuthValue(String fullAuth) {
        List authValues = AUTH_RAW_SPLITTER.splitToList((CharSequence)fullAuth);
        return (String)authValues.get(1);
    }

    public void clean() {
        this.authEnabled = false;
        this.preemptiveAuthAllowed = false;
        this.challengedClients.clear();
        this.seenClients.clear();
        this.preemptiveClients.clear();
        this.credentials.clear();
        this.credentials.putAll((Map<String, String>)this.initialCredentials);
    }

    public final void addCredentials(String username, String password) {
        this.credentials.put(username, password);
    }

    public final void clearCredentials() {
        this.credentials.clear();
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public void setAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
    }

    public boolean isPreemptiveAuthAllowed() {
        return this.preemptiveAuthAllowed;
    }

    public void setPreemptiveAuthAllowed(boolean preemptiveAuthAllowed) {
        this.preemptiveAuthAllowed = preemptiveAuthAllowed;
    }

    public Set<InetSocketAddress> getChallengedClients() {
        return this.challengedClients;
    }

    public Set<InetSocketAddress> getPreemptiveClients() {
        return this.preemptiveClients;
    }

    public Set<InetSocketAddress> getSeenClients() {
        return this.seenClients;
    }
}

