/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils.ssh;

import com.appdynamics.voltron.test.utils.ssh.RemoteUserInfo;
import com.appdynamics.voltron.test.utils.ssh.SSHConfig;
import com.google.inject.Provider;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSHSessionProvider
implements Provider<Session>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SSHSessionProvider.class);
    private Session session;
    @NonNull
    private final SSHConfig sshConfig;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Session get() {
        if (this.session == null || !this.session.isConnected()) {
            try {
                JSch jsch = new JSch();
                this.session = jsch.getSession(this.sshConfig.getUsername(), this.sshConfig.getHost(), this.sshConfig.getPort());
                this.addAuthenticationInformation(jsch);
                this.session.setConfig("StrictHostKeyChecking", this.sshConfig.getStrictHostKeyChecking());
                this.session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
                this.session.connect(this.sshConfig.getConnectTimeout());
                int rPort = this.sshConfig.getRemoteForwardedPort();
                if (rPort <= 0 || "localhost".equals(this.sshConfig.getHost())) return this.session;
                this.session.setPortForwardingR(rPort, "localhost", rPort);
                return this.session;
            }
            catch (JSchException e) {
                log.warn("Exception trying to connect to the server", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            log.debug("found connected session for {}", (Object)this.sshConfig);
        }
        return this.session;
    }

    @Override
    public void close() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    public String getConnectionUrlString() {
        return String.format("%s:%d", this.sshConfig.getHost(), this.sshConfig.getPort());
    }

    private void addAuthenticationInformation(JSch jsch) throws JSchException {
        if (!StringUtils.isEmpty((CharSequence)this.sshConfig.getPassword())) {
            this.session.setPassword(this.sshConfig.getPassword());
            RemoteUserInfo userInfo = new RemoteUserInfo(this.sshConfig.getPassword());
            this.session.setUserInfo((UserInfo)userInfo);
        } else {
            String privateKeyPath = this.sshConfig.getPrivateKeyFilePath();
            if (privateKeyPath.startsWith("~")) {
                privateKeyPath = privateKeyPath.replace("~", System.getProperty("user.home"));
            }
            jsch.addIdentity(new File(privateKeyPath).getAbsolutePath(), this.sshConfig.getPrivateKeyPassphrase());
        }
    }

    public String toString() {
        return "SSHSessionProvider(sshConfig=" + String.valueOf(this.sshConfig) + ")";
    }

    public SSHSessionProvider(@NonNull SSHConfig sshConfig) {
        if (sshConfig == null) {
            throw new NullPointerException("sshConfig is marked non-null but is null");
        }
        this.sshConfig = sshConfig;
    }
}

