/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils.ssh;

import com.appdynamics.voltron.test.utils.ssh.RemoteServer;
import com.google.common.base.Optional;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteProcess
extends Process {
    private static final Logger log = LoggerFactory.getLogger(RemoteProcess.class);
    private OutputStream outputStream;
    private InputStream errStream;
    private InputStream inputStream;
    private final ChannelExec channel;

    public RemoteProcess(RemoteServer remoteServer, String[] cmd, Optional<String[]> envp, Optional<String> workingDir) throws IOException {
        String compoundCommand = RemoteServer.buildCompoundCommand(StringUtils.join((Object[])cmd, (String)" ")).envp(Arrays.asList((String[])envp.or((Object)new String[0]))).workingDir((String)workingDir.orNull()).build();
        try {
            this.channel = remoteServer.getExecChannel();
            this.channel.setCommand(compoundCommand);
            this.inputStream = this.channel.getInputStream();
            this.outputStream = this.channel.getOutputStream();
            this.errStream = this.channel.getErrStream();
            this.channel.connect();
        }
        catch (JSchException | IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errStream;
    }

    @Override
    public int waitFor() throws InterruptedException {
        while (this.isRunning()) {
            Thread.sleep(500L);
        }
        return this.channel.getExitStatus();
    }

    @Override
    public int exitValue() {
        if (this.isRunning()) {
            throw new IllegalStateException("Remote process is running");
        }
        return this.channel.getExitStatus();
    }

    @Override
    public void destroy() {
        try {
            this.channel.sendSignal("2");
        }
        catch (Exception e) {
            log.warn("Failed to terminate remote process with interrupt", (Throwable)e);
            try {
                this.channel.sendSignal("9");
            }
            catch (Exception e1) {
                log.error("Failed to terminate remote process with KILL", (Throwable)e1);
            }
        }
        finally {
            this.channel.disconnect();
        }
    }

    private boolean isRunning() {
        return this.channel.getExitStatus() < 0 && this.channel.isConnected();
    }
}

