/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils.remote;

import com.appdynamics.voltron.test.utils.LogLevel;
import com.appdynamics.voltron.test.utils.remote.PlatformFile;
import com.appdynamics.voltron.test.utils.remote.ProcUtils;
import com.appdynamics.voltron.test.utils.ssh.RemoteServer;
import com.appdynamics.voltron.utils.PlatformOperatingSystem;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.apache.commons.lang3.SystemUtils;

public class PlatformUtils {
    private static final long PERIOD_MS = 60000L;

    private static boolean isLinux(String os) {
        return "Linux".equalsIgnoreCase(os);
    }

    private static boolean isMacOSX(String os) {
        return "Darwin".equalsIgnoreCase(os);
    }

    private static boolean isSunOS(String os) {
        return "SunOS".equalsIgnoreCase(os);
    }

    private static boolean isWindows(String os) {
        return os.contains("Microsoft Windows");
    }

    private static boolean isAix(String os) {
        return "AIX".equalsIgnoreCase(os);
    }

    private static boolean isCygwin(String os) {
        return os.contains("CYGWIN");
    }

    public static boolean safeCheckIs64BitPlatform(PlatformOperatingSystem operatingSystem, Optional<RemoteServer> remoteServer) throws RuntimeException {
        if (operatingSystem == PlatformOperatingSystem.WINDOWS) {
            return System.getenv("PROGRAMFILES(x86)") != null;
        }
        if (operatingSystem == PlatformOperatingSystem.LINUX || operatingSystem == PlatformOperatingSystem.CYGWIN) {
            Optional<String> archOpt = PlatformUtils.runProc(new String[]{"uname", "-m"}, remoteServer);
            return "x86_64".equalsIgnoreCase((String)archOpt.get());
        }
        if (operatingSystem == PlatformOperatingSystem.SOLARIS) {
            Optional<String> archOpt = PlatformUtils.runProc(new String[]{"/usr/bin/isainfo", "-kv"}, remoteServer);
            return ((String)archOpt.get()).contains("64-bit");
        }
        if (operatingSystem == PlatformOperatingSystem.MAC_OSX) {
            return true;
        }
        throw new RuntimeException("Unsupported OS");
    }

    public static String detectArchitecture(PlatformOperatingSystem operatingSystem, Optional<RemoteServer> remoteServer) {
        if (operatingSystem == PlatformOperatingSystem.SOLARIS) {
            Optional<String> archOpt = PlatformUtils.runProc(new String[]{"/usr/bin/isainfo", "-kv"}, remoteServer);
            if (!archOpt.isPresent()) {
                throw new RuntimeException("Architecture cannot be detected.");
            }
            String arch = (String)archOpt.get();
            if (arch.toLowerCase().contains("sparc")) {
                return "sparcv9";
            }
            return "x64";
        }
        return "";
    }

    public static PlatformOperatingSystem detectPlatformOperatingSystem(Optional<RemoteServer> remoteServer) {
        if (remoteServer.isPresent()) {
            return PlatformUtils.detectRemoteOperatingSystem((RemoteServer)remoteServer.get());
        }
        return PlatformUtils.detectLocalOperatingSystem();
    }

    public static PlatformOperatingSystem detectRemoteOperatingSystem(RemoteServer remoteServer) {
        Optional<String> operatingSystemNameOpt = PlatformUtils.runProc(new String[]{"uname"}, (Optional<RemoteServer>)Optional.of((Object)remoteServer));
        if (!operatingSystemNameOpt.isPresent()) {
            operatingSystemNameOpt = PlatformUtils.runProc(new String[]{"cmd /c ver"}, (Optional<RemoteServer>)Optional.of((Object)remoteServer));
        }
        if (!operatingSystemNameOpt.isPresent()) {
            throw new RuntimeException("Could not retrieve remote operating system");
        }
        String operatingSystemName = (String)operatingSystemNameOpt.get();
        if (PlatformUtils.isLinux(operatingSystemName)) {
            return PlatformOperatingSystem.LINUX;
        }
        if (PlatformUtils.isMacOSX(operatingSystemName)) {
            return PlatformOperatingSystem.MAC_OSX;
        }
        if (PlatformUtils.isSunOS(operatingSystemName)) {
            return PlatformOperatingSystem.SOLARIS;
        }
        if (PlatformUtils.isWindows(operatingSystemName)) {
            return PlatformOperatingSystem.WINDOWS;
        }
        if (PlatformUtils.isAix(operatingSystemName)) {
            return PlatformOperatingSystem.AIX;
        }
        if (PlatformUtils.isCygwin(operatingSystemName)) {
            return PlatformOperatingSystem.CYGWIN;
        }
        throw new RuntimeException("Remote operating system not supported - " + operatingSystemName);
    }

    public static PlatformOperatingSystem detectLocalOperatingSystem() {
        PlatformOperatingSystem operatingSystem;
        if (SystemUtils.IS_OS_LINUX) {
            operatingSystem = PlatformOperatingSystem.LINUX;
        } else if (SystemUtils.IS_OS_MAC) {
            operatingSystem = PlatformOperatingSystem.MAC_OSX;
        } else if (SystemUtils.IS_OS_SOLARIS) {
            operatingSystem = PlatformOperatingSystem.SOLARIS;
        } else if (SystemUtils.IS_OS_SUN_OS) {
            operatingSystem = PlatformOperatingSystem.SOLARIS;
        } else if (SystemUtils.IS_OS_HP_UX) {
            operatingSystem = PlatformOperatingSystem.HP_UX;
        } else if (SystemUtils.IS_OS_WINDOWS) {
            operatingSystem = PlatformOperatingSystem.WINDOWS;
        } else if (SystemUtils.IS_OS_AIX) {
            operatingSystem = PlatformOperatingSystem.AIX;
        } else {
            throw new RuntimeException(String.format("Unsupported os - %s", SystemUtils.OS_NAME));
        }
        return operatingSystem;
    }

    public static boolean safeCheckLocalDetectIs64BitPlatform() {
        PlatformOperatingSystem operatingSystem = PlatformUtils.detectLocalOperatingSystem();
        return PlatformUtils.safeCheckIs64BitPlatform(operatingSystem, (Optional<RemoteServer>)Optional.absent());
    }

    public static String getEnvironmentVariable(@NonNull String variableName, Optional<RemoteServer> remoteServer) {
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        String result = remoteServer.isPresent() ? ((RemoteServer)remoteServer.get()).getEnvironmentVariable(variableName) : System.getenv(variableName);
        return result;
    }

    public static Optional<String> getSystemJavaPath(Optional<RemoteServer> remoteServer) {
        String javaHomeEnvVar = PlatformUtils.getEnvironmentVariable("JAVA_HOME", remoteServer);
        Optional result = javaHomeEnvVar != null && !javaHomeEnvVar.isEmpty() ? Optional.of((Object)javaHomeEnvVar) : (remoteServer.isPresent() ? Optional.absent() : Optional.of((Object)System.getProperty("java.home")));
        return result;
    }

    public static boolean operatingSystemIsWindowsOrCygwin(Optional<RemoteServer> remoteServer) {
        PlatformOperatingSystem operatingSystem = PlatformUtils.detectPlatformOperatingSystem(remoteServer);
        return operatingSystem == PlatformOperatingSystem.WINDOWS || operatingSystem == PlatformOperatingSystem.CYGWIN;
    }

    private static Optional<String> runProc(String[] cmd, Optional<RemoteServer> remoteServer) {
        try {
            ProcUtils.Output output = ProcUtils.builder().logOutputStreams(LogLevel.DEBUG).setCmd(cmd).setRemoteServerConfig((RemoteServer)remoteServer.orNull()).build().runAndReturnOutput(60000L);
            if (output.getRetVal() != 0) {
                return Optional.absent();
            }
            return Optional.of((Object)output.getStdout().trim());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(e);
        }
    }

    public static String[] getKillCommand(String filename, PlatformOperatingSystem operatingSystem) {
        String[] killCmd = operatingSystem == PlatformOperatingSystem.WINDOWS || operatingSystem == PlatformOperatingSystem.CYGWIN ? new String[]{"wmic", "process", "WHERE", "\"commandline LIKE '%" + filename + "%'\"", "Call", "Terminate"} : new String[]{"ps", "-aef", "|", "grep", filename, "|", "awk", "'{print $2}'", "|", "xargs", "kill"};
        return killCmd;
    }

    public static String[] getKillCommand(String fileName, RemoteServer remoteServer) {
        return PlatformUtils.getKillCommand(fileName, PlatformUtils.detectRemoteOperatingSystem(remoteServer));
    }

    public static String getCanonicalPath(String path, PlatformOperatingSystem operatingSystem, Optional<RemoteServer> remoteServer) {
        if (operatingSystem == PlatformOperatingSystem.CYGWIN) {
            return path.replace("\\", "/");
        }
        return new PlatformFile(path, remoteServer).getCanonicalPath();
    }

    public static class CommandBuilder {
        private final List<String> cmdList = new ArrayList<String>();
        private final PlatformOperatingSystem operatingSystem;
        private final boolean operatingSystemIsWindowsOrCygwin;

        public CommandBuilder(Optional<RemoteServer> remoteServer) {
            this.operatingSystem = PlatformUtils.detectPlatformOperatingSystem(remoteServer);
            this.operatingSystemIsWindowsOrCygwin = PlatformUtils.operatingSystemIsWindowsOrCygwin(remoteServer);
        }

        public void addToCmdList(String str) {
            this.cmdList.add(str);
        }

        public void addScriptToCmdList(String scriptPath) {
            if (this.operatingSystemIsWindowsOrCygwin) {
                this.cmdList.add("cscript");
                this.cmdList.add("//nologo");
            }
            this.addPathToCmdList(scriptPath);
        }

        public void addPathToCmdList(String path) {
            if (this.operatingSystem == PlatformOperatingSystem.CYGWIN) {
                this.cmdList.add("$(cygpath -w \"" + path + "\")");
            } else {
                this.cmdList.add(path);
            }
        }

        public void addPropertiesToCommandList(String propType, Map<String, Optional<String>> systemProperties) {
            for (Map.Entry<String, Optional<String>> sysProp : systemProperties.entrySet()) {
                String propCmd = CommandBuilder.getPropCmd(sysProp);
                this.cmdList.add(propType + propCmd);
            }
        }

        private static String getPropCmd(Map.Entry<String, Optional<String>> sysProp) {
            Object propCmd = sysProp.getKey();
            Optional<String> optionalValue = sysProp.getValue();
            if (optionalValue.isPresent()) {
                propCmd = (String)propCmd + "=" + (String)optionalValue.get();
            }
            return propCmd;
        }

        public String[] buildCommand() {
            if (this.operatingSystem == PlatformOperatingSystem.CYGWIN) {
                this.cmdList.add(0, "cmd");
                this.cmdList.add(1, "/C");
                this.cmdList.add(2, "\"");
                this.cmdList.add("\"");
            }
            return this.cmdList.toArray(new String[this.cmdList.size()]);
        }
    }
}

