/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import com.appdynamics.voltron.test.utils.IProcessTerminator;
import com.appdynamics.voltron.test.utils.remote.ProcUtils;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsProcessTreeTerminator
implements IProcessTerminator {
    private static final Logger log = LoggerFactory.getLogger(WindowsProcessTreeTerminator.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void terminateProcess(Process process) throws InterruptedException, ExecutionException, TimeoutException {
        long handle;
        String procClassName = process.getClass().getName();
        if (!SystemUtils.IS_OS_WINDOWS) throw new RuntimeException("Not supported - " + SystemUtils.OS_NAME);
        if (!procClassName.equalsIgnoreCase("java.lang.Win32Process") && !procClassName.equalsIgnoreCase("java.lang.ProcessImpl")) throw new RuntimeException("Unexpected Process class implementation " + procClassName);
        try {
            Field f = process.getClass().getDeclaredField("handle");
            f.setAccessible(true);
            handle = f.getLong(process);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        Kernel32 kernel = Kernel32.INSTANCE;
        WinNT.HANDLE winHandle = new WinNT.HANDLE();
        winHandle.setPointer(Pointer.createConstant((long)handle));
        int pid = kernel.GetProcessId(winHandle);
        log.debug("Killing process tree" + pid);
        ProcUtils.builder().setCmd(new String[]{"taskkill", "/F", "/T", "/PID", Long.toString(pid)}).build().runAndReturnOutput(TimeUnit.SECONDS.toMillis(30L));
    }
}

