/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;

public class VoltronPredicates {
    private static final String WINDOWS = "Windows";
    private static final String LINUX = "Linux";
    private static final String SOLARIS = "Solaris";
    private static final String AIX = "AIX";
    private static final String PHYSICAL = "Physical";
    private static final String SWAP = "Swap";
    private static final String SCOPE_FORMAT = "[%s]";
    private static final String SCOPE_MISSING = String.format("[%s]", "");
    private static final String SCOPE_GLOBAL = String.format("[%s]", "global");
    private static final String SCOPE_HOST = String.format("[%s]", "host");
    private static final String SCOPE_LINK = String.format("[%s]", "link");
    private static final String SCOPE_SITE = String.format("[%s]", "site");
    private static final Set<String> SCOPES = ImmutableSet.of((Object)SCOPE_MISSING, (Object)SCOPE_GLOBAL, (Object)SCOPE_HOST, (Object)SCOPE_LINK, (Object)SCOPE_SITE);
    private static final long UNKNOWN_VALUE = -1L;
    public static final Predicate<Long> GT_ZERO = new Predicate<Long>(){

        public boolean apply(Long input) {
            return input > 0L;
        }

        public String toString() {
            return "greater than 0";
        }
    };
    public static final Predicate<Long> GTE_ZERO = new Predicate<Long>(){

        public boolean apply(Long input) {
            return input >= 0L;
        }

        public String toString() {
            return "greater than or equal to 0";
        }
    };
    public static final Predicate<Long> IS_PERCENTAGE = new Predicate<Long>(){

        public boolean apply(Long input) {
            return input >= 0L && input <= 100L;
        }

        public String toString() {
            return "is percentage";
        }
    };
    public static final Predicate<String> NON_BLANK_STRING = new Predicate<String>(){

        public boolean apply(String input) {
            return StringUtils.isNotBlank((CharSequence)input);
        }

        public String toString() {
            return "is not null/empty/whitespace";
        }
    };
    public static final Predicate<String> NON_ZERO_STRING = new Predicate<String>(){

        public boolean apply(String input) {
            return !"0".equals(input);
        }

        public String toString() {
            return "is not \"0\"";
        }
    };
    public static final Predicate<String> IS_IPV4_ADDRESS = new Predicate<String>(){

        public boolean apply(String input) {
            String[] splitAddress = input.split("/");
            if (splitAddress.length < 1 || splitAddress.length > 2) {
                return false;
            }
            boolean result = InetAddressValidator.getInstance().isValidInet4Address(splitAddress[0]);
            if (splitAddress.length > 1 && result) {
                try {
                    int mask = Integer.valueOf(splitAddress[1]);
                    result = mask >= 0 && mask <= 32;
                }
                catch (NumberFormatException e) {
                    result = false;
                }
            }
            return result;
        }

        public String toString() {
            return "is a valid IPv4 address";
        }
    };
    public static final Predicate<String> IS_IPV4_ADDRESS_WITH_SCOPE = new Predicate<String>(){

        public boolean apply(String input) {
            String[] tokens = input.split(" ");
            return tokens.length == 2 && IS_IPV4_ADDRESS.apply((Object)tokens[0]) && SCOPES.contains(tokens[1]);
        }

        public String toString() {
            return "is a valid IPv4 address with scope";
        }
    };
    public static final Predicate<String> IS_OPERATING_SYSTEM = new Predicate<String>(){
        private Set<String> osNamesSet = ImmutableSet.of((Object)"Windows", (Object)"Linux", (Object)"Solaris", (Object)"AIX");

        public boolean apply(String input) {
            return this.osNamesSet.contains(input);
        }

        public String toString() {
            return "is an accepted OS name";
        }
    };
    public static final Predicate<String> IS_IPV6_ADDRESS = new Predicate<String>(){

        public boolean apply(String input) {
            String[] splitAddress = input.split("/");
            if (splitAddress.length < 1 || splitAddress.length > 2) {
                return false;
            }
            boolean result = InetAddressValidator.getInstance().isValidInet6Address(splitAddress[0]);
            if (splitAddress.length > 1 && result) {
                try {
                    int mask = Integer.valueOf(splitAddress[1]);
                    result = mask >= 0 && mask <= 64;
                }
                catch (NumberFormatException e) {
                    result = false;
                }
            }
            return result;
        }

        public String toString() {
            return "is a valid IPv6 address";
        }
    };
    public static final Predicate<String> IS_IPV6_ADDRESS_WITH_SCOPE = new Predicate<String>(){

        public boolean apply(String input) {
            String[] tokens = input.split(" ");
            return tokens.length == 2 && IS_IPV6_ADDRESS.apply((Object)tokens[0]) && SCOPES.contains(tokens[1]);
        }

        public String toString() {
            return "is a valid IPv6 address with scope";
        }
    };
    public static final Predicate<String> IS_MAC_ADDRESS = new Predicate<String>(){

        public boolean apply(String input) {
            String macAddressPattern = "^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$";
            return input.matches(macAddressPattern);
        }

        public String toString() {
            return "is a valid IPv6 address";
        }
    };
    public static final Predicate<String> CAN_BE_BLANK_STRING = new Predicate<String>(){

        public boolean apply(String input) {
            return input != null;
        }

        public String toString() {
            return "can be blank string";
        }
    };
    public static final Predicate<String> UP_DOWN_OR_UNKNOWN = new Predicate<String>(){

        public boolean apply(String input) {
            return input.equals("up") || input.equals("down") || input.equals("unknown");
        }

        public String toString() {
            return "is either 'up', 'down', or 'unknown'";
        }
    };
    public static final Predicate<String> YES_NO_OR_UNKNOWN = new Predicate<String>(){

        public boolean apply(String input) {
            return input.equals("yes") || input.equals("no") || input.equals("unknown");
        }

        public String toString() {
            return "is either 'yes', 'no', or 'unknown'";
        }
    };
    public static final Predicate<String> FULL_HALF_NO_OR_UNKNOWN = new Predicate<String>(){

        public boolean apply(String input) {
            return input.equals("full") || input.equals("half") || input.equals("no") || input.equals("unknown");
        }

        public String toString() {
            return "is either 'full', 'half', 'no', or 'unknown'";
        }
    };
    public static final Predicate<String> IS_MEMORY_TYPE = new Predicate<String>(){
        private Set<String> memoryTypes = ImmutableSet.of((Object)"Physical", (Object)"Swap");

        public boolean apply(String input) {
            return this.memoryTypes.contains(input);
        }

        public String toString() {
            return "is an accepted memory type";
        }
    };

    private VoltronPredicates() {
    }
}

