/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import com.appdynamics.voltron.test.utils.LogLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;

public class LogOutputStream
extends OutputStream {
    private final Logger logger;
    private final LogLevel level;
    private final String prefix;
    private final ByteArrayOutputStream baos;

    public LogOutputStream(Logger logger, LogLevel level) {
        this(logger, level, "");
    }

    public LogOutputStream(Logger logger, LogLevel level, String prefix) {
        this.logger = logger;
        this.level = level;
        this.prefix = prefix;
        this.baos = new ByteArrayOutputStream();
    }

    @Override
    public synchronized void flush() throws IOException {
        String msg = this.baos.toString("UTF-8");
        if (msg.endsWith("\r\n")) {
            msg = msg.substring(0, msg.length() - 2);
        } else if (msg.endsWith("\n")) {
            msg = msg.substring(0, msg.length() - 1);
        }
        this.level.write(this.logger, this.prefix + msg);
        this.baos.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        if (this.level.isEnabled(this.logger)) {
            LogOutputStream logOutputStream = this;
            synchronized (logOutputStream) {
                this.baos.write(b);
                if (b == 10) {
                    this.flush();
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

