/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import com.google.common.base.Throwables;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;

public final class JarUtils {
    public static void createJarArchive(File archiveFile, List<Class<?>> classes, Map<String, List<File>> additionalFiles) {
        HashBasedTable contents = HashBasedTable.create();
        for (Map.Entry<String, List<File>> entry : additionalFiles.entrySet()) {
            for (File f : entry.getValue()) {
                try {
                    contents.put((Object)entry.getKey(), (Object)f.getName(), (Object)f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
        for (Class clazz : classes) {
            String klassName = clazz.getSimpleName();
            String filename = klassName + ".class";
            URL classUrl = clazz.getResource(filename);
            String path = clazz.getPackage().getName().replace('.', '/');
            contents.put((Object)path, (Object)filename, (Object)classUrl);
        }
        JarUtils.createJarArchive(archiveFile, (Table<String, String, URL>)contents);
    }

    public static void createJarArchive(File archiveFile, Table<String, String, URL> contents) {
        try (JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(archiveFile), new Manifest());){
            for (Table.Cell entry : contents.cellSet()) {
                String dirPath = ((String)entry.getRowKey()).trim();
                String filename = ((String)entry.getColumnKey()).trim();
                URL url = (URL)entry.getValue();
                if (dirPath.startsWith("/")) {
                    dirPath = dirPath.substring(1);
                }
                if (dirPath.endsWith("/")) {
                    dirPath = dirPath.substring(0, dirPath.length() - 1);
                }
                InputStream in = url.openStream();
                try {
                    JarEntry jarAdd = new JarEntry(dirPath + "/" + filename);
                    out.putNextEntry(jarAdd);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JarUtils() {
    }
}

