/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import com.appdynamics.voltron.test.utils.GradleUtil;
import com.google.common.base.Optional;
import java.io.File;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DependenciesUtil {
    private static final Logger log = LoggerFactory.getLogger(DependenciesUtil.class);
    private static final String[] SYSTEM_PROPERTY_ABSENT = new String[0];
    private static final String DEFAULT_DEPENDENCY_DIR = "build/dependencies";
    private static final String DEFAULT_COPY_TEST_DEPS_TASK_NAME = "copyIntTestDeps";
    private static final String GRADLE_FILE = "gradlew";
    private final String projectPath;
    private final String taskName;
    private final String dependencyDir;

    public DependenciesUtil(@NonNull String projectPath, @NonNull String taskName, @NonNull String dependencyDir) {
        if (projectPath == null) {
            throw new NullPointerException("projectPath is marked non-null but is null");
        }
        if (taskName == null) {
            throw new NullPointerException("taskName is marked non-null but is null");
        }
        if (dependencyDir == null) {
            throw new NullPointerException("dependencyDir is marked non-null but is null");
        }
        this.projectPath = projectPath;
        this.taskName = taskName;
        this.dependencyDir = dependencyDir;
    }

    public DependenciesUtil(@NonNull String projectPath) {
        this(projectPath, DEFAULT_COPY_TEST_DEPS_TASK_NAME, DEFAULT_DEPENDENCY_DIR);
        if (projectPath == null) {
            throw new NullPointerException("projectPath is marked non-null but is null");
        }
    }

    public File getDependency(String distName) {
        return this.getDependency(distName, true);
    }

    public File getDependency(String distName, boolean runGradleIfNeeded) {
        Optional<File> dependency = this.getDependencyDirect(distName);
        if (dependency.isPresent()) {
            return (File)dependency.get();
        }
        if (!runGradleIfNeeded) {
            throw new RuntimeException("Did not find the dependency" + distName + " and not running gradle to copy it.");
        }
        dependency = this.buildUsingGradle(distName);
        return (File)dependency.get();
    }

    private Optional<File> buildUsingGradle(String distName) {
        log.debug("Did not find dependency {}. Running gradle {} to build it.", (Object)distName, (Object)this.taskName);
        GradleUtil.runGradleCommandFromDirectory(this.projectPath, SYSTEM_PROPERTY_ABSENT, this.taskName, (Optional<String>)Optional.absent());
        Optional<File> dependency = this.getDependencyDirect(distName);
        if (dependency.isPresent()) {
            return dependency;
        }
        throw new RuntimeException("Did not find the dependency " + distName + " even after running gradle to copy it. Are you sure the name is correct?");
    }

    private static File getCodebaseRootDir() {
        String workingDir = System.getProperty("user.dir");
        for (File currentDir = new File(workingDir); currentDir != null && currentDir.exists(); currentDir = currentDir.getParentFile()) {
            File file = new File(currentDir, GRADLE_FILE);
            if (!file.exists()) continue;
            return currentDir;
        }
        throw new RuntimeException("Could not find the codebase root dir containing gradlew scripts.");
    }

    private Optional<File> getDependencyDirect(String distName) {
        File distFile = new File(this.dependencyDir, distName);
        if (distFile.exists()) {
            return Optional.of((Object)distFile);
        }
        log.debug("Did not find the dependency at {}. Assuming running from root project dir.", (Object)distFile);
        distFile = new File(new File(this.projectPath, this.dependencyDir), distName);
        if (distFile.exists()) {
            return Optional.of((Object)distFile);
        }
        log.debug("Did not find the dependency at {}.", (Object)distFile);
        return Optional.absent();
    }
}

