/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import com.google.common.base.Optional;
import java.io.File;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class BetterTemporaryFolder
implements TestRule {
    private static final String DEFAULT_PARENT = "build";
    private final String parentPath;
    private final Optional<String> id;
    private boolean cleanUp;
    private File root;

    public BetterTemporaryFolder() {
        this(null);
    }

    public BetterTemporaryFolder(String id) {
        this(id, DEFAULT_PARENT);
    }

    public BetterTemporaryFolder(String id, @NonNull String parentPath) {
        if (parentPath == null) {
            throw new NullPointerException("parentPath is marked non-null but is null");
        }
        this.id = Optional.fromNullable((Object)id);
        this.parentPath = parentPath;
        this.cleanUp = false;
    }

    public BetterTemporaryFolder withCleanUp() {
        this.cleanUp = true;
        return this;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                BetterTemporaryFolder.this.createRoot(description);
                try {
                    base.evaluate();
                }
                finally {
                    if (BetterTemporaryFolder.this.cleanUp) {
                        BetterTemporaryFolder.this.deleteRoot();
                    }
                }
            }
        };
    }

    public void deleteRoot() {
        if (this.root != null) {
            FileUtils.deleteQuietly((File)this.root);
        }
    }

    public void createRoot(Description description) {
        if (this.root == null) {
            String className = description.getTestClass().getSimpleName();
            String testName = description.getMethodName();
            Object idToUse = "";
            if (this.id.isPresent()) {
                idToUse = "-" + (String)this.id.get();
            }
            String folderName = className + "/" + testName + (String)idToUse + "-" + System.currentTimeMillis();
            this.root = new File(this.parentPath, folderName);
            this.root.mkdirs();
        }
    }

    public File getRoot() {
        return this.root;
    }
}

