/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.javax.xml.stream;

import com.appdynamics.javax.xml.namespace.NamespaceContext;
import com.appdynamics.javax.xml.namespace.QName;
import com.appdynamics.javax.xml.stream.FactoryConfigurationError;
import com.appdynamics.javax.xml.stream.FactoryFinder;
import com.appdynamics.javax.xml.stream.Location;
import com.appdynamics.javax.xml.stream.SecuritySupport;
import com.appdynamics.javax.xml.stream.events.Attribute;
import com.appdynamics.javax.xml.stream.events.Characters;
import com.appdynamics.javax.xml.stream.events.Comment;
import com.appdynamics.javax.xml.stream.events.DTD;
import com.appdynamics.javax.xml.stream.events.EndDocument;
import com.appdynamics.javax.xml.stream.events.EndElement;
import com.appdynamics.javax.xml.stream.events.EntityDeclaration;
import com.appdynamics.javax.xml.stream.events.EntityReference;
import com.appdynamics.javax.xml.stream.events.Namespace;
import com.appdynamics.javax.xml.stream.events.ProcessingInstruction;
import com.appdynamics.javax.xml.stream.events.StartDocument;
import com.appdynamics.javax.xml.stream.events.StartElement;
import java.util.Iterator;

public abstract class XMLEventFactory {
    private static final String PROPERTY_NAME = "com.appdynamics.javax.xml.stream.XMLEventFactory";
    private static final String DEFAULT_FACTORY = "com.appdynamics.org.apache.xerces.stax.XMLEventFactoryImpl";

    protected XMLEventFactory() {
    }

    public static XMLEventFactory newInstance() throws FactoryConfigurationError {
        try {
            return (XMLEventFactory)FactoryFinder.find(PROPERTY_NAME, DEFAULT_FACTORY);
        }
        catch (FactoryFinder.ConfigurationError configurationError) {
            throw new FactoryConfigurationError(configurationError.getException(), configurationError.getMessage());
        }
    }

    public static XMLEventFactory newInstance(String string, ClassLoader classLoader) throws FactoryConfigurationError {
        if (classLoader == null) {
            classLoader = SecuritySupport.getContextClassLoader();
        }
        try {
            return (XMLEventFactory)FactoryFinder.find(string, classLoader, DEFAULT_FACTORY);
        }
        catch (FactoryFinder.ConfigurationError configurationError) {
            throw new FactoryConfigurationError(configurationError.getException(), configurationError.getMessage());
        }
    }

    public abstract void setLocation(Location var1);

    public abstract Attribute createAttribute(QName var1, String var2);

    public abstract Attribute createAttribute(String var1, String var2);

    public abstract Attribute createAttribute(String var1, String var2, String var3, String var4);

    public abstract Namespace createNamespace(String var1);

    public abstract Namespace createNamespace(String var1, String var2);

    public abstract StartElement createStartElement(QName var1, Iterator var2, Iterator var3);

    public abstract StartElement createStartElement(String var1, String var2, String var3);

    public abstract StartElement createStartElement(String var1, String var2, String var3, Iterator var4, Iterator var5);

    public abstract StartElement createStartElement(String var1, String var2, String var3, Iterator var4, Iterator var5, NamespaceContext var6);

    public abstract EndElement createEndElement(QName var1, Iterator var2);

    public abstract EndElement createEndElement(String var1, String var2, String var3);

    public abstract EndElement createEndElement(String var1, String var2, String var3, Iterator var4);

    public abstract Characters createCharacters(String var1);

    public abstract Characters createCData(String var1);

    public abstract Characters createSpace(String var1);

    public abstract Characters createIgnorableSpace(String var1);

    public abstract StartDocument createStartDocument();

    public abstract StartDocument createStartDocument(String var1);

    public abstract StartDocument createStartDocument(String var1, String var2);

    public abstract StartDocument createStartDocument(String var1, String var2, boolean var3);

    public abstract EndDocument createEndDocument();

    public abstract EntityReference createEntityReference(String var1, EntityDeclaration var2);

    public abstract Comment createComment(String var1);

    public abstract ProcessingInstruction createProcessingInstruction(String var1, String var2);

    public abstract DTD createDTD(String var1);
}

