/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.uuid;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class UUIDPool {
    private static final String SHA1_PRNG_ALGORITHM_NAME = "SHA1PRNG";
    private static final String NATIVE_PRNG_NON_BLOCKING_ALGO_NAME = "NativePRNGNonBlocking";
    private static final int DEFAULT_UUID_POOL_SIZE = 10;
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static SecureRandomPool secureRandomPool;
    private static ThreadLocal<SecureRandom> fastSecureRandomAccess;

    public static synchronized void initialize(ILogger logger) {
        String poolSizeProperty = SystemUtils.getProperty((String)"appdynamics.uuid.pool.size");
        int poolSize = StringOperations.safeParseInteger((String)poolSizeProperty, (int)10);
        secureRandomPool = new SecureRandomPool(poolSize);
        SecureRandomPool.initialize(logger);
        initialized.set(true);
    }

    public static String getRandomUUID() {
        if (!initialized.get()) {
            throw new IllegalStateException("UUIDPool is not initialized; UUIDPool.initialize() should be called.");
        }
        UUID randomUuid = UUIDPool.generateRandomUUID();
        if (randomUuid == null) {
            return null;
        }
        return randomUuid.toString();
    }

    private static UUID generateRandomUUID() {
        byte[] randomBytes = new byte[16];
        fastSecureRandomAccess.get().nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return UUIDPool.getUUIDfromByteArray(randomBytes);
    }

    private static UUID getUUIDfromByteArray(byte[] input) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        if (input.length != 16) {
            return null;
        }
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(input[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(input[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    static {
        fastSecureRandomAccess = new ThreadLocal<SecureRandom>(){

            @Override
            protected SecureRandom initialValue() {
                return secureRandomPool.next();
            }
        };
    }

    private static class SecureRandomPool {
        private static int poolSize;
        private static SecureRandom[] secureRandoms;

        private SecureRandomPool(int poolSize) {
            SecureRandomPool.poolSize = poolSize;
            secureRandoms = new SecureRandom[SecureRandomPool.poolSize];
        }

        private static synchronized void initialize(ILogger logger) {
            String algorithmToUse = UUIDPool.SHA1_PRNG_ALGORITHM_NAME;
            String enableLowEntropyMode = SystemUtils.getProperty((String)"appdynamics.low.entropy");
            if (SecureRandomPool.isOsWindows()) {
                logger.info("Windows OS does not support non-blocking PRNG algorithm, will use SHA1PRNG algorithm");
            } else if (StringOperations.safeParseBoolean((String)enableLowEntropyMode, (boolean)false)) {
                logger.info("Low Entropy Mode: Attempting to swap to non-blocking PRNG algorithm");
                algorithmToUse = UUIDPool.NATIVE_PRNG_NON_BLOCKING_ALGO_NAME;
            }
            boolean noSuchAlgorithmLogged = false;
            for (int i = 0; i < poolSize; ++i) {
                try {
                    SecureRandomPool.secureRandoms[i] = SecureRandom.getInstance(algorithmToUse);
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    SecureRandomPool.secureRandoms[i] = new SecureRandom();
                    if (noSuchAlgorithmLogged) continue;
                    logger.info("No such algorithm: " + algorithmToUse + " for UUIDPool, switch to default.");
                    noSuchAlgorithmLogged = true;
                }
            }
            logger.info("UUIDPool size is " + poolSize);
        }

        private SecureRandom next() {
            int index = (int)(Thread.currentThread().getId() % (long)poolSize);
            return secureRandoms[index];
        }

        private static boolean isOsWindows() {
            return SystemUtils.getProperty((String)"os.name", (String)"").startsWith("Windows");
        }
    }
}

