/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.container.kubeapi;

import com.singularity.ee.agent.util.container.APIConnector;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

public class KubeAPIConnector
extends APIConnector {
    private static final String TARGET_FORMAT = "https://%s:%s/api/v1/namespaces/%s/pods/%s";
    private static String[] allowedTLSVersions = new String[]{"TLSv1.2"};

    protected KubeAPIConnector() {
    }

    public KubeAPIConnector(Map<String, String> props) {
        super(props);
    }

    @Override
    protected void setTarget() {
        String namespace = (String)this.APIProperties.get("APPDYNAMICS_POD_NAMESPACE");
        if (namespace == null && (namespace = (String)this.APIProperties.get("appdynamics.pod.namespace")) == null) {
            namespace = (String)this.APIProperties.get("namespace");
        }
        this.target = String.format(TARGET_FORMAT, this.APIProperties.get("KUBERNETES_SERVICE_HOST"), this.APIProperties.get("KUBERNETES_SERVICE_PORT"), namespace, this.APIProperties.get("HOSTNAME"));
    }

    @Override
    protected void createRequest() {
        this.request = new HttpGet(this.target);
        this.request.setConfig(RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setSocketTimeout(this.readTimeout).build());
    }

    @Override
    protected CloseableHttpClient createHttpClient() {
        return this.createTrustedCertificateClient();
    }

    private CloseableHttpClient createTrustedCertificateClient() {
        SSLContext sslContext = this.getSSLContext();
        if (sslContext == null) {
            logger.error("Could not create SSL Context for Kube API Client");
            return null;
        }
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>();
        headerList.add(new BasicHeader("Accept", "application/json"));
        headerList.add(new BasicHeader("Content-Type", "application/json"));
        headerList.add(new BasicHeader("Authorization", "Bearer " + (String)this.APIProperties.get("token")));
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, allowedTLSVersions, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultHeaders(headerList).build();
    }

    private SSLContext getSSLContext() {
        SSLContext sslContext = null;
        try {
            FileInputStream is = new FileInputStream((String)this.APIProperties.get("ca.crt"));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate caCert = (X509Certificate)cf.generateCertificate(is);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry("caCert", caCert);
            tmf.init(ks);
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        return sslContext;
    }
}

