/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.container.kubeapi;

import com.singularity.ee.agent.util.container.ContainerInfoFetchService;
import com.singularity.ee.agent.util.container.kubeapi.KubeAPIConnector;
import java.util.Arrays;
import java.util.HashMap;

public class ContainerInfoKubeApiService
extends ContainerInfoFetchService {
    private static final String[] requirementsList = new String[]{"KUBERNETES_SERVICE_HOST", "KUBERNETES_SERVICE_PORT", "HOSTNAME", "(APPDYNAMICS_CONTAINER_NAME or appdynamics.container.name)", "(APPDYNAMICS_POD_NAMESPACE or appdynamics.pod.namespace or /var/run/secrets/kubernetes.io/serviceaccount/namespace)", "/var/run/secrets/kubernetes.io/serviceaccount/token", "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt"};

    @Override
    protected boolean checkAndInitRequirements() {
        boolean requirementsPresent = false;
        propertiesMap = new HashMap();
        requirementsPresent = ContainerInfoKubeApiService.checkAndInitProp("KUBERNETES_SERVICE_HOST", null) && ContainerInfoKubeApiService.checkAndInitProp("KUBERNETES_SERVICE_PORT", null) && ContainerInfoKubeApiService.checkAndInitProp("HOSTNAME", null) && ContainerInfoKubeApiService.checkAndInitProp("APPDYNAMICS_CONTAINER_NAME", "appdynamics.container.name");
        boolean bl = requirementsPresent = requirementsPresent && (ContainerInfoKubeApiService.checkAndInitProp("APPDYNAMICS_POD_NAMESPACE", "appdynamics.pod.namespace") || ContainerInfoKubeApiService.checkFileAndInitProp("/var/run/secrets/kubernetes.io/serviceaccount", "namespace", false)) && ContainerInfoKubeApiService.checkFileAndInitProp("/var/run/secrets/kubernetes.io/serviceaccount", "token", false) && ContainerInfoKubeApiService.checkFileAndInitProp("/var/run/secrets/kubernetes.io/serviceaccount", "ca.crt", true);
        if (!requirementsPresent) {
            logger.warn("Make sure, following are configured and accessible to Agent\n" + Arrays.toString(requirementsList));
            return false;
        }
        logger.info("Kube API service Properties Successfully Initialized: " + propertiesMap.toString());
        logger.info("Creating Http Client using these props");
        apiConnector = new KubeAPIConnector(propertiesMap);
        if (apiConnector.getHttpClient() == null) {
            logger.warn("Could not create Http Client for " + apiConnector.getTarget());
            requirementsPresent = false;
        }
        return requirementsPresent;
    }

    @Override
    protected String parseResponse(String response) {
        long startTime = System.currentTimeMillis();
        String containerStatusStart = "containerStatuses\":[";
        int i = response.indexOf(containerStatusStart);
        if (i == -1) {
            logger.warn("Response body does not have 'containerStatuses'");
            return null;
        }
        response = response.substring(i);
        String ourContainerName = (String)propertiesMap.get("APPDYNAMICS_CONTAINER_NAME");
        if (ourContainerName == null) {
            ourContainerName = (String)propertiesMap.get("appdynamics.container.name");
        }
        String finalContainerId = null;
        char[] rawCharArr = response.toCharArray();
        int listStart = 1;
        int tokenPos = containerStatusStart.length();
        int containerInfoStart = 0;
        String tempContainerName = "";
        String tempContainerId = "";
        while (listStart != 0) {
            char ch = rawCharArr[tokenPos];
            if (ch == '\"' && containerInfoStart == 1 && listStart == 1) {
                ch = rawCharArr[++tokenPos];
                String key = "";
                while (ch != '\"') {
                    key = key + ch;
                    ch = rawCharArr[++tokenPos];
                }
                if (key.equals("name") || key.equals("containerID")) {
                    ch = rawCharArr[tokenPos += 3];
                    String val = "";
                    while (ch != '\"') {
                        val = val + ch;
                        ch = rawCharArr[++tokenPos];
                    }
                    if (key.equals("name")) {
                        tempContainerName = val;
                    } else if (key.equals("containerID")) {
                        tempContainerId = val;
                    }
                }
            } else if (ch == ':' && containerInfoStart == 1 && rawCharArr[tokenPos + 1] == '\"') {
                ++tokenPos;
                ch = rawCharArr[++tokenPos];
                while (ch != '\"') {
                    ch = rawCharArr[++tokenPos];
                }
            } else if (ch == '{') {
                ++containerInfoStart;
            } else if (ch == '}') {
                if (--containerInfoStart == 0 && tempContainerName.equals(ourContainerName)) {
                    finalContainerId = tempContainerId;
                    break;
                }
            } else if (ch == '[') {
                ++listStart;
            } else if (ch == ']') {
                --listStart;
            }
            ++tokenPos;
        }
        if (finalContainerId != null) {
            String parsedOutput = "For container=" + ourContainerName + " , containerID=" + finalContainerId;
            System.out.println(parsedOutput);
            logger.info(parsedOutput);
            finalContainerId = this.formatContainerId(finalContainerId);
        } else {
            logger.warn("Container Info NOT present for container=" + ourContainerName);
        }
        logger.info("Time taken in parsing response = " + (System.currentTimeMillis() - startTime) + " ms");
        return finalContainerId;
    }
}

