/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.container;

import com.singularity.ee.agent.util.container.APIConnector;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;

public abstract class ContainerInfoFetchService {
    protected static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.container.ContainerInfoFetchService");
    protected static Map<String, String> propertiesMap;
    protected static APIConnector apiConnector;

    public void setPropertiesMap(Map<String, String> propertiesMap) {
        ContainerInfoFetchService.propertiesMap = propertiesMap;
    }

    public void setApiConnector(APIConnector apiConnector) {
        ContainerInfoFetchService.apiConnector = apiConnector;
    }

    protected static boolean checkAndInitProp(String envPropName, String sysPropName) {
        String propName = envPropName;
        String value = System.getenv(envPropName);
        if (value == null && sysPropName != null) {
            propName = sysPropName;
            value = System.getProperty(sysPropName);
        }
        if (value == null || value.isEmpty()) {
            logger.warn(propName + " Not Found or empty!");
            return false;
        }
        propertiesMap.put(propName, value);
        return true;
    }

    protected static boolean checkFileAndInitProp(String dirName, String fileName, boolean isCertFile) {
        File file = new File(dirName + File.separatorChar + fileName);
        if (!ContainerInfoFetchService.isFilePresent(file)) {
            logger.warn(file.getAbsolutePath() + " Not present or readable or empty");
            return false;
        }
        try {
            if (isCertFile) {
                propertiesMap.put(fileName, file.getAbsolutePath());
            } else {
                String data = new BufferedReader(new FileReader(file)).readLine().trim();
                if (data.isEmpty()) {
                    logger.warn(file.getAbsolutePath() + " is empty");
                    return false;
                }
                propertiesMap.put(fileName, data);
            }
        }
        catch (IOException e) {
            logger.error("Cannot Read " + file.getAbsolutePath() + " : " + e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean isFilePresent(File nameFile) {
        return nameFile.exists() && nameFile.canRead() && nameFile.length() != 0L;
    }

    public String extractContainerId() {
        long startTime = System.currentTimeMillis();
        String response = this.executeApiRequest();
        logger.info("Time taken in executing request = " + (System.currentTimeMillis() - startTime) + " ms");
        if (response == null) {
            logger.warn("No response body to parse for 'containerID' or 'containerStatuses'");
            return null;
        }
        return this.parseResponse(response);
    }

    private String executeApiRequest() {
        return apiConnector.executeRequest();
    }

    protected String formatContainerId(String unFormattedId) {
        String formattedId = null;
        formattedId = unFormattedId.substring(unFormattedId.lastIndexOf("/") + 1);
        if (!formattedId.matches("^[a-fA-F0-9]+$")) {
            logger.warn("Container ID is not a valid hex string: " + formattedId);
            return null;
        }
        logger.info("Detected appropriate hex string container ID: " + formattedId);
        return formattedId;
    }

    protected abstract boolean checkAndInitRequirements();

    protected abstract String parseResponse(String var1);
}

