/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.container;

import com.singularity.ee.agent.util.container.AbstractCGroupDetector;
import com.singularity.ee.agent.util.container.CGroupV1Detector;
import com.singularity.ee.agent.util.container.CGroupV2Detector;
import com.singularity.ee.agent.util.container.ContainerInfoFetchService;
import com.singularity.ee.agent.util.container.clusteragentapi.ContainerInfoClusterAgentApiService;
import com.singularity.ee.agent.util.container.kubeapi.ContainerInfoKubeApiService;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;

public class ContainerIdExtractor {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.container.ContainerIdExtractor");
    private static final String INVALID_CONTAINER_ID = "000000000000000000000000000000000000000000000000000000000000000";
    private static final ContainerIdExtractor INSTANCE = new ContainerIdExtractor();
    private final String containerID = this.fetchContainerID();

    private ContainerIdExtractor() {
    }

    public static ContainerIdExtractor getInstance() {
        return INSTANCE;
    }

    public String getContainerID() {
        return this.containerID;
    }

    private String fetchContainerID() {
        String id = null;
        String containerInfoFetchService = System.getProperty("appdynamics.containerinfo.fetch.service");
        if (containerInfoFetchService == null || containerInfoFetchService.isEmpty()) {
            containerInfoFetchService = System.getenv("APPDYNAMICS_CONTAINERINFO_FETCH_SERVICE");
        }
        if (containerInfoFetchService != null && !containerInfoFetchService.isEmpty()) {
            return this.fetchContainerIDFromService(containerInfoFetchService);
        }
        AbstractCGroupDetector cGroup = new CGroupV1Detector(logger);
        id = cGroup.discoverContainerId();
        if (id != null) {
            return id;
        }
        cGroup = new CGroupV2Detector(logger);
        return cGroup.discoverContainerId();
    }

    private String fetchContainerIDFromService(String fetchServiceType) {
        String id = null;
        logger.info("Fetching container info from " + fetchServiceType);
        ContainerInfoFetchService containerInfoFetchService = fetchServiceType.equals("kubeapi") ? new ContainerInfoKubeApiService() : new ContainerInfoClusterAgentApiService();
        if (containerInfoFetchService != null && containerInfoFetchService.checkAndInitRequirements()) {
            id = containerInfoFetchService.extractContainerId();
        } else {
            logger.warn("Couldn't create ContainerInfoFetchService");
        }
        return id == null ? INVALID_CONTAINER_ID : id;
    }
}

