/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.container;

import com.singularity.ee.util.logging.ILogger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

abstract class AbstractCGroupDetector {
    protected static final String HEX_STRING_REGEX = "^[a-fA-F0-9]+$";
    protected static final int CONTAINER_ID_EXPECTED_LENGTH = 64;
    protected final ILogger logger;

    protected AbstractCGroupDetector(ILogger logger) {
        this.logger = logger;
    }

    protected abstract String discoverContainerId();

    protected abstract String extractContainerIdFromLine(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getContainerIdFromFile(String filePathName) {
        try {
            File nameFile = new File(filePathName);
            if (!this.isHostNameFilePresent(nameFile)) {
                this.logger.info("No Container ID found in " + filePathName + " : does not exist or is not readable");
                return null;
            }
            BufferedReader bufferedReader = null;
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(nameFile);
                bufferedReader = new BufferedReader(fileReader);
                String containerId = this.extractContainerId(bufferedReader);
                if (containerId != null) {
                    String string = containerId;
                    this.closeStream(bufferedReader);
                    this.closeStream(fileReader);
                    return string;
                }
            }
            catch (FileNotFoundException e) {
                try {
                    this.logger.warn("Unable to fetch unique host name from " + filePathName, (Throwable)e);
                    String string = null;
                    this.closeStream(bufferedReader);
                    this.closeStream(fileReader);
                    return string;
                }
                catch (Throwable throwable) {
                    this.closeStream(bufferedReader);
                    this.closeStream(fileReader);
                    throw throwable;
                }
            }
            {
                this.logger.warn("Unable to use " + filePathName + " for unique hostname, could not locate container ID");
                this.closeStream(bufferedReader);
                this.closeStream(fileReader);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get container id with exception", (Throwable)e);
            return null;
        }
    }

    private boolean isHostNameFilePresent(File nameFile) {
        return nameFile.exists() && nameFile.canRead();
    }

    private void closeStream(Closeable reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            this.logger.warn("Error closing buffered reader", (Throwable)e);
        }
    }

    protected String extractContainerId(BufferedReader bufferedReader) throws IOException {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            String containerId = this.extractContainerIdFromLine(line);
            if (containerId == null) continue;
            this.logger.info("Detected unique host name: " + containerId);
            return containerId;
        }
        return null;
    }
}

