/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.container;

import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public abstract class APIConnector {
    protected static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.container.APIConnector");
    protected static final String API_CONN_INIT = "Api-Rest-001 : Apache HTTP client connection properties = { connectTimeout=%s , readTimeout=%s } to API Service for fetching container-id";
    protected CloseableHttpClient httpClient;
    protected HttpRequestBase request;
    protected int connectionTimeout;
    protected int readTimeout;
    protected Map<String, String> APIProperties;
    protected String target;
    protected static final int MAX_ATTEMPTS = 3;
    protected static final long FIVE_SECONDS = 5000L;
    protected static final Set<Integer> ACCEPTABLE_RESPONSE_CODES = new HashSet<Integer>(Arrays.asList(200, 401, 403));

    protected APIConnector() {
    }

    public APIConnector(Map<String, String> props) {
        this.APIProperties = props;
        this.initConnectorProperties();
        this.setTarget();
        this.createRequest();
        this.httpClient = this.createHttpClient();
    }

    public void setRequest(HttpRequestBase request) {
        this.request = request;
    }

    public void initConnectorProperties() {
        this.connectionTimeout = 5000;
        this.readTimeout = 60000;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient client) {
        this.httpClient = client;
    }

    public String getTarget() {
        return this.target;
    }

    public String executeRequest() {
        String responseString = null;
        for (int currentAttempt = 1; currentAttempt <= 3 && (responseString = this.executeHttpRequest(currentAttempt)) == null; ++currentAttempt) {
            if (currentAttempt == 3) continue;
            try {
                Thread.sleep((long)currentAttempt * 5000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
            }
        }
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeHttpRequest(int currentAttempt) {
        CloseableHttpResponse response = null;
        String responseString = null;
        boolean retry = true;
        URI uri = this.request.getURI();
        logger.info("Executing request (attempt: " + currentAttempt + ") " + this.target);
        logger.info(String.format(API_CONN_INIT, this.connectionTimeout, this.readTimeout));
        try {
            response = this.httpClient.execute(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()), (HttpRequest)this.request);
            try {
                int code = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                logger.info("Response code: " + code);
                logger.info("Response from Api: " + responseString);
                retry = !ACCEPTABLE_RESPONSE_CODES.contains(code);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), e);
            }
            finally {
                response.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            try {
                if (retry) {
                    responseString = null;
                }
                if (!retry || currentAttempt == 3) {
                    this.httpClient.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
            }
        }
        return responseString;
    }

    protected abstract void setTarget();

    protected abstract void createRequest();

    protected abstract CloseableHttpClient createHttpClient();
}

