/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class AgentCollectionHelper {
    private static final AppDynamicsEmptyMap AD_EMPTY_MAP = new AppDynamicsEmptyMap();
    private static final AppDynamicsEmptyList AD_EMPTY_LIST = new AppDynamicsEmptyList();
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Iterator AD_EMPTY_ITERATOR = new AppDynamicsEmptyIterator();
    private static final AppDynamicsEmptySet AD_EMPTY_SET = new AppDynamicsEmptySet();

    public static <K, V> Map<K, V> emptyMap() {
        return AD_EMPTY_MAP;
    }

    public static <T> List<T> emptyList() {
        return AD_EMPTY_LIST;
    }

    public static <T> Set<T> emptySet() {
        return AD_EMPTY_SET;
    }

    public static <T> T getFirstItem(Collection<T> collection) {
        return collection.iterator().next();
    }

    private static class AppDynamicsEmptySet
    extends AppDynamicsEmptyCollection
    implements Set {
        private AppDynamicsEmptySet() {
        }
    }

    private static class AppDynamicsEmptyList
    extends AppDynamicsEmptyCollection
    implements List {
        private AppDynamicsEmptyList() {
        }

        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        public List subList(int fromIndex, int toIndex) {
            return this;
        }
    }

    private static class AppDynamicsEmptyCollection
    implements Collection {
        private AppDynamicsEmptyCollection() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public void clear() {
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator iterator() {
            return AD_EMPTY_ITERATOR;
        }

        @Override
        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        public Object[] toArray(Object[] a) {
            return a;
        }

        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c) {
            return false;
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }
    }

    private static class AppDynamicsEmptyIterator
    implements Iterator {
        private AppDynamicsEmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class AppDynamicsEmptyMap
    implements Map {
        private AppDynamicsEmptyMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        public Object get(Object key) {
            return null;
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            return null;
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
        }

        public Set keySet() {
            return AD_EMPTY_SET;
        }

        public Collection values() {
            return AD_EMPTY_LIST;
        }

        public Set entrySet() {
            return AD_EMPTY_SET;
        }
    }
}

