/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util;

import com.singularity.ee.agent.util.log4j.IADLogger;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public abstract class JarFileUtilities {
    public static InputStream getInputStreamFromURLCollection(String resourceName, List<URL> urlCollection, IADLogger logger) {
        URL url;
        InputStream returnInputStream = null;
        Iterator<URL> iterator = urlCollection.iterator();
        while (iterator.hasNext() && (returnInputStream = JarFileUtilities.getInputStreamFromURL(url = iterator.next(), resourceName, logger)) == null) {
        }
        return returnInputStream;
    }

    private static InputStream getInputStreamFromURL(URL url, String resourceName, IADLogger logger) {
        InputStream returnInputStream;
        block3: {
            returnInputStream = null;
            try {
                File file = new File(url.getFile());
                JarFile jarFile = new JarFile(file);
                ZipEntry entry = jarFile.getEntry(resourceName);
                if (entry != null) {
                    returnInputStream = jarFile.getInputStream(entry);
                }
            }
            catch (Exception e) {
                if (logger == null) break block3;
                logger.error(String.format("%s caught trying to obtain InputStream for %s in %s", e, resourceName, url), e);
            }
        }
        return returnInputStream;
    }
}

