/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.IAgentAccountInfoResolver;
import com.singularity.ee.agent.resolver.IAgentRegistrationInfoResolver;
import com.singularity.ee.agent.resolver.IControllerInfoResolver;
import com.singularity.ee.agent.resolver.IHostIdentifierResolver;
import com.singularity.ee.agent.resolver.IIPAddressResolver;
import com.singularity.ee.agent.resolver.IResolver;
import com.singularity.ee.agent.resolver.ResolverGroup;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

class ResolverGroupHelper {
    ResolverGroupHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void executeResolvers(ResolverGroup resolverGroup) throws InterruptedException {
        CountDownLatch controllerInfoResolverLatch = new CountDownLatch(resolverGroup.getNumberControllerInfoResolvers());
        CountDownLatch accountInfoResolverLatch = new CountDownLatch(resolverGroup.getNumberAgentAccountInfoResolvers());
        CountDownLatch agentRegistrationInfoResolverLatch = new CountDownLatch(resolverGroup.getNumberAgentRegistrationInfoResolvers());
        CountDownLatch hostIdResolverLatch = new CountDownLatch(resolverGroup.getNumberHostIdResolvers());
        CountDownLatch ipAddressResolverLatch = new CountDownLatch(resolverGroup.getNumberIPAddressResolvers());
        ArrayList<ResolverWorker> resolverWorkers = new ArrayList<ResolverWorker>();
        try {
            for (IResolver resolver : resolverGroup.resolvers) {
                if (!(resolver instanceof IControllerInfoResolver && controllerInfoResolverLatch.getCount() > 0L || resolver instanceof IAgentAccountInfoResolver || resolver instanceof IAgentRegistrationInfoResolver && agentRegistrationInfoResolverLatch.getCount() > 0L || resolver instanceof IHostIdentifierResolver && hostIdResolverLatch.getCount() > 0L) && (!(resolver instanceof IIPAddressResolver) || ipAddressResolverLatch.getCount() <= 0L)) continue;
                ResolverWorker resolverWorker = new ResolverWorker(resolver);
                if (resolver instanceof IControllerInfoResolver) {
                    resolverWorker.addControllerInfoResolverLatch(controllerInfoResolverLatch);
                }
                if (resolver instanceof IAgentAccountInfoResolver) {
                    resolverWorker.addAccountInfoResolverLatch(accountInfoResolverLatch);
                }
                if (resolver instanceof IAgentRegistrationInfoResolver) {
                    resolverWorker.addAgentRegistrationInfoResolverLatch(agentRegistrationInfoResolverLatch);
                }
                if (resolver instanceof IHostIdentifierResolver) {
                    resolverWorker.addHostIdResolverLatch(hostIdResolverLatch);
                }
                if (resolver instanceof IIPAddressResolver) {
                    resolverWorker.addIPAddressResolverLatch(ipAddressResolverLatch);
                }
                resolverWorkers.add(resolverWorker);
                if (resolver.resolveAsync()) {
                    resolverWorker.start();
                    continue;
                }
                resolverWorker.run();
            }
            controllerInfoResolverLatch.await();
            accountInfoResolverLatch.await();
            agentRegistrationInfoResolverLatch.await();
            hostIdResolverLatch.await();
            ipAddressResolverLatch.await();
        }
        finally {
            for (ResolverWorker resolverWorker : resolverWorkers) {
                if (!resolverWorker.isAlive()) continue;
                resolverWorker.cancelResolution();
            }
            for (ResolverWorker resolverWorker : resolverWorkers) {
                resolverWorker.cleanUpAfterRun();
            }
        }
        for (ResolverWorker resolverWorker : resolverWorkers) {
            resolverGroup.gatherResolutionOutcomeFrom(resolverWorker.getWrappedResolver());
        }
    }

    static class ResolverWorker
    extends Thread {
        private final IResolver wrappedResolver;
        private CountDownLatch controllerInfoResolverLatch;
        private CountDownLatch accountInfoResolverLatch;
        private CountDownLatch agentRegistrationInfoResolverLatch;
        private CountDownLatch hostIdResolverLatch;
        private CountDownLatch ipAddressResolverLatch;

        ResolverWorker(IResolver wrappedResolver) {
            super(wrappedResolver.getName());
            this.wrappedResolver = wrappedResolver;
            this.setDaemon(true);
        }

        IResolver getWrappedResolver() {
            return this.wrappedResolver;
        }

        void cancelResolution() {
            this.wrappedResolver.cancelResolution();
            this.interrupt();
        }

        void cleanUpAfterRun() {
            this.wrappedResolver.cleanUpAfterRun();
        }

        private void addControllerInfoResolverLatch(CountDownLatch latch) {
            this.controllerInfoResolverLatch = latch;
        }

        private void addAccountInfoResolverLatch(CountDownLatch latch) {
            this.accountInfoResolverLatch = latch;
        }

        private void addAgentRegistrationInfoResolverLatch(CountDownLatch latch) {
            this.agentRegistrationInfoResolverLatch = latch;
        }

        private void addHostIdResolverLatch(CountDownLatch latch) {
            this.hostIdResolverLatch = latch;
        }

        private void addIPAddressResolverLatch(CountDownLatch latch) {
            this.ipAddressResolverLatch = latch;
        }

        @Override
        public void run() {
            try {
                this.wrappedResolver.run();
            }
            finally {
                if (this.wrappedResolver.resolutionSucceeded()) {
                    this.releaseLatches();
                } else {
                    this.countDownLatches();
                }
            }
        }

        private void countDownLatches() {
            if (this.controllerInfoResolverLatch != null) {
                this.controllerInfoResolverLatch.countDown();
            }
            if (this.accountInfoResolverLatch != null) {
                this.accountInfoResolverLatch.countDown();
            }
            if (this.agentRegistrationInfoResolverLatch != null) {
                this.agentRegistrationInfoResolverLatch.countDown();
            }
            if (this.hostIdResolverLatch != null) {
                this.hostIdResolverLatch.countDown();
            }
            if (this.ipAddressResolverLatch != null) {
                this.ipAddressResolverLatch.countDown();
            }
        }

        private void releaseLatches() {
            if (this.controllerInfoResolverLatch != null) {
                while (this.controllerInfoResolverLatch.getCount() > 0L) {
                    this.controllerInfoResolverLatch.countDown();
                }
            }
            if (this.accountInfoResolverLatch != null) {
                while (this.accountInfoResolverLatch.getCount() > 0L) {
                    this.accountInfoResolverLatch.countDown();
                }
            }
            if (this.agentRegistrationInfoResolverLatch != null) {
                while (this.agentRegistrationInfoResolverLatch.getCount() > 0L) {
                    this.agentRegistrationInfoResolverLatch.countDown();
                }
            }
            if (this.hostIdResolverLatch != null) {
                while (this.hostIdResolverLatch.getCount() > 0L) {
                    this.hostIdResolverLatch.countDown();
                }
            }
            if (this.ipAddressResolverLatch != null) {
                while (this.ipAddressResolverLatch.getCount() > 0L) {
                    this.ipAddressResolverLatch.countDown();
                }
            }
        }
    }
}

