/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.google.common.annotations.VisibleForTesting;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.system.SystemUtilsTranslateable;

public class PublishQueueLengthSupplier {
    private final ILogger logger;
    @VisibleForTesting
    public static final int DEFAULT_PUBLISH_QUEUE_LENGTH = 2;
    @VisibleForTesting
    public static final int PUBLISH_QUEUE_LENGTH_UPPER_LIMIT = 5;
    @VisibleForTesting
    public static final int PUBLISH_QUEUE_LENGTH_LOWER_LIMIT = 1;

    public PublishQueueLengthSupplier(ILogger logger) {
        this.logger = logger;
    }

    public Integer get() {
        int publishQueueLength = SystemUtilsTranslateable.getIntProperty((String)"appdynamics.agent.metrics.publish.queue.size", (int)2);
        if (publishQueueLength < 1) {
            this.logger.warn("The configured value [" + publishQueueLength + "] for the property " + "appdynamics.agent.metrics.publish.queue.size" + " is lower than the minimum allowed value of [" + 1 + "]. The default value [" + 2 + "] will be used.");
            publishQueueLength = 2;
        } else if (publishQueueLength > 5) {
            this.logger.warn("The configured value [" + publishQueueLength + "] for the property " + "appdynamics.agent.metrics.publish.queue.size" + " is higher than the maximum allowed value of [" + 5 + "]. The default value [" + 2 + "] will be used.");
            publishQueueLength = 2;
        }
        return publishQueueLength;
    }
}

