/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.ADefaultResolver;
import com.singularity.ee.agent.resolver.IHostIdentifierResolver;
import com.singularity.ee.agent.util.SystemInfo;
import com.singularity.ee.agent.util.container.ContainerIdExtractor;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.io.File;

public class KubernetesResolver
extends ADefaultResolver
implements IHostIdentifierResolver {
    private String uniqueHostInformation;
    private final ContainerIdExtractor extractor;
    private final boolean isKubernetesEnvironment;
    private static final String UNIQUE_HOST_NAME_FILE_NAME = "/proc/self/cgroup";
    private static final int TRUNCATED_HOST_NAME_STRING_LENGTH = 12;

    public KubernetesResolver(ILogger logger, ContainerIdExtractor extractor) {
        this(logger, extractor, KubernetesResolver.isKubernetesEnvironmentDetected(logger));
    }

    public KubernetesResolver(ILogger logger, ContainerIdExtractor extractor, boolean isKubernetesEnvironment) {
        super(logger);
        this.extractor = extractor;
        this.isKubernetesEnvironment = isKubernetesEnvironment;
    }

    @Override
    public String getUniqueHostIdentifier() {
        return this.uniqueHostInformation;
    }

    @Override
    public String getName() {
        return "Kubernetes Agent Resolver";
    }

    @Override
    public boolean resolveAsync() {
        return false;
    }

    @Override
    public boolean resolutionSucceeded() {
        return StringOperations.isNotEmpty((String)this.uniqueHostInformation);
    }

    @Override
    public void run() {
        this.uniqueHostInformation = null;
        if (SystemInfo.isWindowsMachine()) {
            this.logger.debug("Windows Environment detected, skipping Kubernetes resolution");
            return;
        }
        if (!this.isKubernetesEnvironment) {
            this.logger.debug("No Kubernetes environment variables detected, skipping resolution");
            return;
        }
        try {
            String disablePropertyString = SystemUtils.getProperty((String)"disable.kubernetes.host.resolver");
            if (StringOperations.safeParseBoolean((String)disablePropertyString, (boolean)false)) {
                this.logger.info("Kubernetes resolver disabled via system property");
                return;
            }
        }
        catch (Exception e) {
            this.logger.warn("Error fetching system property: disable.kubernetes.host.resolver", (Throwable)e);
            return;
        }
        this.logger.info("Detected Kubernetes environment, attempting to fetch unique host name");
        this.uniqueHostInformation = this.getProperty("APPDYNAMICS_AGENT_UNIQUE_HOST_ID", "appdynamics.agent.uniqueHostId", "unique host identifier");
        if (this.uniqueHostInformation == null) {
            this.logger.info("Attempting to fetch unique host name from extractor");
            this.uniqueHostInformation = this.extractor.getContainerID();
            if (this.uniqueHostInformation == null) {
                this.logger.info("Kubernetes Container ID is null");
                return;
            }
            this.uniqueHostInformation = KubernetesResolver.truncateIfNecessary(this.uniqueHostInformation, 12);
        }
    }

    protected boolean isHostNameFilePresent(File nameFile) {
        return nameFile.exists() && nameFile.canRead();
    }

    protected static String truncateIfNecessary(String input, int maxReturnLength) {
        if (input.length() > maxReturnLength) {
            return input.substring(0, maxReturnLength);
        }
        return input;
    }

    public static boolean isKubernetesEnvironmentDetected(ILogger logger) {
        boolean retVal = false;
        try {
            retVal = SystemUtils.getenv((String)"KUBERNETES_PORT") != null || SystemUtils.getenv((String)"KUBERNETES_SERVICE_HOST") != null || SystemUtils.getenv((String)"KUBERNETES_SERVICE_PORT") != null || SystemUtils.getenv((String)"APPDYNAMICS_AGENT_KUBERNETES") != null;
        }
        catch (SecurityException se) {
            logger.warn("Hit SecurityException trying to read kubernetes environment properties", (Throwable)se);
        }
        return retVal;
    }
}

