/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.google.common.annotations.VisibleForTesting;
import com.singularity.ee.agent.resolver.ADefaultResolver;
import com.singularity.ee.agent.resolver.AgentRegistrationInfo;
import com.singularity.ee.agent.resolver.AgentResolverHelper;
import com.singularity.ee.agent.resolver.EphemeralNodeNameResolverHelper;
import com.singularity.ee.agent.resolver.FullAgentRegistrationInfoResolverHelper;
import com.singularity.ee.agent.resolver.IAgentRegistrationInfoResolver;
import com.singularity.ee.agent.resolver.ISelfServiceNameProvider;
import com.singularity.ee.agent.util.AgentSystemUtil;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.util.Arrays;
import java.util.HashSet;

public class FullAgentRegistrationInfoResolver
extends ADefaultResolver
implements IAgentRegistrationInfoResolver {
    public static final String CREATE_DEFAULT_AGENT_INFO_IF_MISSING_PROP_NAME = "appdynamics.agent.create.agent.info.if.missing";
    private final String[] identityConfigFilePath;
    private AgentRegistrationInfo agentRegistrationInfo;
    private boolean unableToRegister;
    private boolean dataPipelineEnabled;
    protected boolean createDefaultAgentRegistrationInfoIfMissing;
    private ISelfServiceNameProvider selfServiceNameProvider;

    public FullAgentRegistrationInfoResolver(ILogger logger) {
        this(logger, (ISelfServiceNameProvider)null, (String[])null);
    }

    public FullAgentRegistrationInfoResolver(ILogger logger, ISelfServiceNameProvider selfServiceNameProvider) {
        this(logger, selfServiceNameProvider, (String[])null);
    }

    public FullAgentRegistrationInfoResolver(ILogger logger, String ... identityFilePath) {
        this(logger, (ISelfServiceNameProvider)null, identityFilePath);
    }

    public FullAgentRegistrationInfoResolver(ILogger logger, ISelfServiceNameProvider selfServiceNameProvider, String ... identityFilePath) {
        super(logger);
        this.identityConfigFilePath = identityFilePath;
        this.selfServiceNameProvider = selfServiceNameProvider;
        this.createDefaultAgentRegistrationInfoIfMissing = this.shouldCreateAgentInfoIfMissing();
    }

    protected boolean shouldCreateAgentInfoIfMissing() {
        String prop = this.getProperty("", CREATE_DEFAULT_AGENT_INFO_IF_MISSING_PROP_NAME, CREATE_DEFAULT_AGENT_INFO_IF_MISSING_PROP_NAME);
        return StringOperations.safeParseBoolean((String)prop, (boolean)true);
    }

    @Override
    public AgentRegistrationInfo getAgentRegistrationInfo() {
        return this.agentRegistrationInfo;
    }

    @Override
    public String getName() {
        return "Full Agent Registration Info Resolver";
    }

    @Override
    public boolean resolutionSucceeded() {
        return this.agentRegistrationInfo != null;
    }

    @Override
    public boolean resolveAsync() {
        return false;
    }

    @Override
    public void run() {
        String agentNodeName;
        this.logger.debug(this.getName() + " is running");
        String resolvedAppName = this.getProperty("APPDYNAMICS_AGENT_APPLICATION_NAME", "appdynamics.agent.applicationName", "application name");
        String resolvedComponentName = this.getProperty("APPDYNAMICS_AGENT_TIER_NAME", "appdynamics.agent.tierName", "tier name");
        String resolvedNodeName = this.getProperty("APPDYNAMICS_AGENT_NODE_NAME", "appdynamics.agent.nodeName", "node name");
        String resolvedAgentRuntimeDir = this.getProperty("APPDYNAMICS_AGENT_BASE_DIR", "appdynamics.agent.runtime.dir", "agent runtime dir");
        String resolvedDataPipeline = this.getProperty("APPDYNAMICS_AGENT_ENABLE_DATA_PIPELINE", "appdynamics.agent.enable.datapipeline", "data pipeline");
        String selfServiceString = this.getProperty("APPDYNAMICS_SELF_SERVICE", "appdynamics.agent.selfService", "Self Service");
        Boolean useAsEphemeralNode = null;
        boolean isSelfService = false;
        boolean forceAgentRegistrationConfig = false;
        if (this.identityConfigFilePath != null && this.identityConfigFilePath.length > 0) {
            for (String nextConfigFilePath : this.identityConfigFilePath) {
                String useAsEphermalString;
                String agentRuntimeDir;
                String nodeName;
                String componentName;
                String applicationName;
                if (nextConfigFilePath == null || !AgentResolverHelper.configFileExists(nextConfigFilePath)) continue;
                Document xmlDoc = null;
                try {
                    xmlDoc = XMLParseUtility.getXMLDocument((String)nextConfigFilePath, (String)"Agent Identity XML File", (ILogger)this.logger);
                }
                catch (Exception e) {
                    this.logger.error("Error reading identity xml file", (Throwable)e);
                }
                if (xmlDoc == null) continue;
                Element rootElement = xmlDoc.getDocumentElement();
                if (resolvedAppName == null && (applicationName = XMLParseUtility.getTextForTagForElement((Node)rootElement, (String)"application-name")) != null && applicationName.length() > 0) {
                    resolvedAppName = applicationName;
                }
                if (resolvedComponentName == null && (componentName = XMLParseUtility.getTextForTagForElement((Node)rootElement, (String)"tier-name")) != null && componentName.length() > 0) {
                    resolvedComponentName = componentName;
                }
                if (resolvedNodeName == null && (nodeName = XMLParseUtility.getTextForTagForElement((Node)rootElement, (String)"node-name")) != null && nodeName.length() > 0) {
                    resolvedNodeName = nodeName;
                }
                if (resolvedAgentRuntimeDir == null && (agentRuntimeDir = XMLParseUtility.getTextForTagForElement((Node)rootElement, (String)"agent-runtime-dir")) != null && agentRuntimeDir.length() > 0) {
                    this.logger.info(this.getName() + " using agent runtime dir [" + agentRuntimeDir + "]");
                    resolvedAgentRuntimeDir = agentRuntimeDir;
                }
                if (forceAgentRegistrationConfig = Boolean.parseBoolean(XMLParseUtility.getTextForTagForElement((Node)rootElement, (String)"force-agent-registration"))) {
                    this.logger.info(this.getName() + " is forcing the agent registration configuration");
                }
                if (selfServiceString == null) {
                    selfServiceString = XMLParseUtility.getTextForTagForElement((Node)rootElement, (String)"auto-naming");
                }
                isSelfService = !StringOperations.isEmpty((String)selfServiceString);
                this.logger.info(this.getName() + " using selfService [" + Boolean.toString(isSelfService) + "]");
                if (useAsEphemeralNode != null || StringOperations.isEmpty((String)(useAsEphermalString = XMLParseUtility.getTextForTagForElement((Node)rootElement, (String)"use-as-ephemeral-node")))) continue;
                useAsEphemeralNode = StringOperations.safeParseBoolean((String)useAsEphermalString, (boolean)false);
                this.logger.info(this.getName() + " found use node as ephemeral in xml [" + useAsEphemeralNode + "]");
            }
        }
        if (useAsEphemeralNode == null) {
            useAsEphemeralNode = false;
        }
        String useAsEphemeralNodeString = AgentSystemUtil.getProperty("appdynamics.agent.node.use.as.ephemeral", "APPDYNAMICS_JAVA_AGENT_EPHEMERAL_NODE", "ephemeral node", this.logger);
        useAsEphemeralNode = StringOperations.safeParseBoolean((String)useAsEphemeralNodeString, (boolean)useAsEphemeralNode);
        this.logger.info(this.getName() + " using ephemeral node setting [" + useAsEphemeralNode + "]");
        resolvedAppName = FullAgentRegistrationInfoResolverHelper.getResolvedNameIfSystemProperty(resolvedAppName);
        if (this.createDefaultAgentRegistrationInfoIfMissing && (resolvedAppName == null || resolvedAppName.length() == 0) && StringOperations.isNotEmpty((String)(agentNodeName = SystemUtils.getProperty((String)"appdynamics.agent.nodeName.from.javaagent")))) {
            resolvedAppName = SystemUtils.getProperty((String)"appdynamics.agent.default.app.name", (String)"MyApp");
        }
        this.logger.info(this.getName() + " using application name [" + resolvedAppName + "]");
        String nodeNameFromJavaAgent = this.getNodeNameFromJavaAgentArg();
        resolvedComponentName = FullAgentRegistrationInfoResolverHelper.getResolvedNameIfSystemProperty(resolvedComponentName);
        boolean autoResolution = false;
        boolean reuseNodeName = FullAgentRegistrationInfoResolverHelper.isNodeNameReuseEnabled(this.logger);
        if (this.createDefaultAgentRegistrationInfoIfMissing && (resolvedComponentName == null || resolvedComponentName.length() == 0 || resolvedComponentName.equals("NULL"))) {
            if (nodeNameFromJavaAgent != null) {
                resolvedComponentName = nodeNameFromJavaAgent;
                autoResolution = true;
            } else if (!isSelfService || this.selfServiceNameProvider == null) {
                this.unableToRegister = true;
                resolvedComponentName = "unknown";
            }
        }
        this.logger.info(this.getName() + " using tier name [" + resolvedComponentName + "]");
        resolvedNodeName = FullAgentRegistrationInfoResolverHelper.getResolvedNameIfSystemProperty(resolvedNodeName);
        if (useAsEphemeralNode.booleanValue() && StringOperations.isEmpty((String)resolvedNodeName)) {
            resolvedNodeName = EphemeralNodeNameResolverHelper.generateEphemeralNodeName();
        }
        if (this.createDefaultAgentRegistrationInfoIfMissing && (resolvedNodeName == null || resolvedNodeName.length() == 0 || resolvedNodeName.equals("NULL"))) {
            if (nodeNameFromJavaAgent != null) {
                resolvedNodeName = nodeNameFromJavaAgent;
                autoResolution = true;
            } else if (!(reuseNodeName || useAsEphemeralNode.booleanValue() || isSelfService)) {
                this.unableToRegister = true;
                resolvedNodeName = "unknown";
            }
        }
        this.logger.info(this.getName() + " using node name [" + resolvedNodeName + "]");
        boolean deferredRegistration = false;
        boolean componentNameWasGenerated = false;
        if (isSelfService && this.selfServiceNameProvider != null) {
            this.selfServiceNameProvider.setApplicationName(resolvedAppName);
            this.selfServiceNameProvider.setApplicationComponentName(resolvedComponentName);
            this.selfServiceNameProvider.setApplicationComponentNodeName(resolvedNodeName);
            this.selfServiceNameProvider.resolveNames();
            resolvedAppName = this.selfServiceNameProvider.getApplicationName();
            resolvedComponentName = this.selfServiceNameProvider.getApplicationComponentName();
            componentNameWasGenerated = this.selfServiceNameProvider.isComponentNameWasGenerated();
            resolvedNodeName = this.selfServiceNameProvider.getApplicationComponentNodeName();
            deferredRegistration = this.selfServiceNameProvider.shouldRegistrationBeDeferred();
            if (!deferredRegistration) {
                boolean nodeNameMissing;
                boolean appNameMissing = resolvedAppName == null || resolvedAppName.length() == 0 || resolvedAppName.equals("NULL") || resolvedAppName.equals("unknown");
                boolean tierNameMissing = resolvedComponentName == null || resolvedComponentName.length() == 0 || resolvedComponentName.equals("NULL") || resolvedComponentName.equals("unknown");
                boolean bl = nodeNameMissing = !reuseNodeName && (resolvedNodeName == null || resolvedNodeName.length() == 0 || resolvedNodeName.equals("NULL") || resolvedNodeName.equals("unknown"));
                if (appNameMissing || tierNameMissing || nodeNameMissing) {
                    this.logger.info(String.format("SelfServiceNameProvider was unable to provide AppName[%s] TierName[%s] or NodeName[%s]", resolvedAppName != null ? resolvedAppName : "null", resolvedComponentName != null ? resolvedComponentName : "null", resolvedNodeName != null ? resolvedNodeName : "null"));
                    this.unableToRegister = true;
                }
            }
        }
        this.agentRegistrationInfo = new AgentRegistrationInfo(new HashSet<String>(Arrays.asList(resolvedAppName)), resolvedComponentName, resolvedNodeName, resolvedAgentRuntimeDir, forceAgentRegistrationConfig, autoResolution, isSelfService, deferredRegistration, componentNameWasGenerated, useAsEphemeralNode.booleanValue(), this.selfServiceNameProvider);
        if (this.selfServiceNameProvider != null) {
            this.selfServiceNameProvider.setAgentRegistrationInfo(this.agentRegistrationInfo);
        }
        this.dataPipelineEnabled = StringOperations.safeParseBoolean((String)resolvedDataPipeline, (boolean)false);
        this.logger.debug(this.getName() + " finished running");
    }

    protected String getNodeNameFromJavaAgentArg() {
        return this.getProperty("", "appdynamics.agent.nodeName.from.javaagent", "appdynamics.agent.nodeName.from.javaagent");
    }

    public boolean isUnableToRegister() {
        return this.unableToRegister;
    }

    public ISelfServiceNameProvider getSelfServiceNameProvider() {
        return this.selfServiceNameProvider;
    }

    @VisibleForTesting
    String[] getIdentityConfigFilePath() {
        return this.identityConfigFilePath;
    }

    public boolean isDataPipelineEnabled() {
        return this.dataPipelineEnabled;
    }
}

